/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.gui.dialogs.OptionDialog;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.orderform.OrderRequests;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.orderform.data.OrderSummary;
import net.creeperhost.minetogether.orderform.elements.DetailsElement;
import net.creeperhost.minetogether.orderform.elements.LocationElement;
import net.creeperhost.minetogether.orderform.elements.ServerConfigElement;
import net.creeperhost.minetogether.orderform.elements.WorldElement;
import net.creeperhost.minetogether.orderform.requests.GetDataCentresRequest;
import net.creeperhost.minetogether.orderform.requests.PostCreateAccountRequest;
import net.creeperhost.minetogether.orderform.requests.PostOrderRequest;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.minetogether.util.GetClosestDCRequest;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiScrolling;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextList;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstraintImpl;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OrderGui
implements GuiProvider {
    public static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Order Requests Thread %d").setDaemon(true).build());
    private static final ExecutorService PING_EXECUTOR = Executors.newFixedThreadPool(12, new ThreadFactoryBuilder().setNameFormat("MT Ping Thread %d").setDaemon(true).build());
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Random RAND = new Random();
    public final Order order = new Order();
    private final Map<String, String> dcIdMap = new ConcurrentHashMap<String, String>();
    public final Map<String, GetDataCentresRequest.DC> dcMap = new ConcurrentHashMap<String, GetDataCentresRequest.DC>();
    public final Map<String, Integer> dcPing = new ConcurrentHashMap<String, Integer>();
    public final Map<String, Long> dcDistance = new ConcurrentHashMap<String, Long>();
    private CompletableFuture<?> initTask;
    private CompletableFuture<?> pingTask;
    private CompletableFuture<?> orderTask;
    private CompletableFuture<?> summaryTask;
    private volatile boolean nameValid = false;
    private volatile Component nameMessage = null;
    private int nameCheckTimer = 60;
    private int pingTimer = 0;
    private volatile boolean pingUpdated = false;
    private volatile boolean emailValid = false;
    private volatile Component emailMessage;
    private int emailCheckTimer = 60;
    private boolean inputsValid = false;
    public Component invalidMessage = null;
    private boolean summaryUpdateRequired = false;
    private volatile boolean summaryUpdating = false;
    private volatile OrderSummary summary = new OrderSummary("Loading Summary...");
    private String invoiceID;
    private volatile boolean processing = false;
    private Component processingText = Component.m_237119_();
    private GuiButton processingButton;
    private boolean processingShowCloseButton = false;
    public LocationElement locations;
    public DetailsElement details;
    public WorldElement world;

    private OrderGui() {
    }

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    private void initDefaults() {
        this.initTask = CompletableFuture.runAsync(() -> {
            OrderRequests.getLocations().forEach((dc, id) -> this.dcIdMap.put((String)dc, String.valueOf(id)));
            OrderRequests.getDataCenters(512).forEach(dc -> this.dcMap.put(dc.slug, (GetDataCentresRequest.DC)dc));
            this.dcIdMap.forEach((dc, i) -> this.dcPing.put((String)dc, -1));
            GetClosestDCRequest.Response byDistance = OrderRequests.getDCsByDistance();
            if (byDistance != null) {
                this.order.serverLocation = byDistance.getDataCenter().getName();
                byDistance.getDataCenters().forEach(dc -> this.dcDistance.put(dc.getName(), dc.getDistance()));
            }
            this.order.country = Countries.getOurCountry();
            this.summaryUpdateRequired = true;
        }, EXECUTOR);
        this.order.name = OrderGui.getDefaultName();
    }

    public void buildGui(ModularGui gui) {
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.m_237115_((String)"minetogether:gui.order.title"));
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        GuiElement orderBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-170.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)22.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-5.0));
        GuiElement priceBg = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.BOTTOM), (double)-17.0));
        GuiElement summaryBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)priceBg.get(GeoParam.TOP), (double)-2.0));
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.m_237115_((String)"minetogether:gui.button.back_arrow")).onPress(() -> gui.mc().m_91152_(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)50.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton placeOrder = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(root, this::getOrderButtonText).onPress(() -> new OptionDialog((GuiParent<?>)this.locations.getModularGui().getRoot(), (Component)Component.m_237115_((String)"minetogether:gui.order.place_order.confirm"), new Component[]{Component.m_237115_((String)"minetogether:gui.button.confirm").m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)"minetogether:gui.button.cancel").m_130940_(ChatFormatting.RED)}).onButtonPress(0, () -> this.placeOrder(gui)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)70.0))).setDisabled(() -> !this.inputsValid || this.orderTask != null || this.summaryUpdateRequired || this.summaryUpdating).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)priceBg.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)priceBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)priceBg.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.BOTTOM)));
        GuiScrolling scrollArea = new GuiScrolling((GuiParent)orderBg);
        scrollArea.getContentElement().constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)scrollArea.get(GeoParam.RIGHT)));
        Constraints.bind((ConstrainedGeometry)scrollArea, (ConstrainedGeometry)orderBg);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(orderBg, Axis.Y);
        ((GuiSlider)scrollBar.primary).setSliderState(scrollArea.scrollState(Axis.Y)).setScrollableElement((GuiElement)scrollArea);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> scrollArea.hiddenSize(Axis.Y) > 0.0).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        this.setupOrderPanel(scrollArea.getContentElement());
        this.setupSummaryPanel(summaryBg);
        this.setupPricePanel(priceBg);
        this.buildProcessingScreen(root);
        gui.onTick(() -> this.tick(gui));
        this.initDefaults();
    }

    private void setupOrderPanel(GuiElement<?> background) {
        int sidePadding = 5;
        int spacing = 4;
        ServerConfigElement config = (ServerConfigElement)((ServerConfigElement)((ServerConfigElement)new ServerConfigElement((GuiParent<?>)background, this).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)sidePadding))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)(-sidePadding)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)spacing));
        this.locations = (LocationElement)((LocationElement)((LocationElement)new LocationElement((GuiParent<?>)background, this).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)sidePadding))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)(-sidePadding)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)config.get(GeoParam.BOTTOM), (double)spacing));
        this.details = (DetailsElement)((DetailsElement)((DetailsElement)new DetailsElement((GuiParent<?>)background, this).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)sidePadding))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)(-sidePadding)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.locations.get(GeoParam.BOTTOM), (double)spacing));
        this.world = (WorldElement)((WorldElement)((WorldElement)new WorldElement((GuiParent<?>)background, this).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)sidePadding))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)(-sidePadding)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.details.get(GeoParam.BOTTOM), (double)spacing));
        Constraints.placeOutside((ConstrainedGeometry)new GuiElement(background).setSize(10.0, (double)spacing), (ConstrainedGeometry)this.world, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER);
    }

    private void setupSummaryPanel(GuiElement<?> background) {
        ConstraintImpl.Relative left = Constraint.match((GeoRef)background.get(GeoParam.LEFT));
        ConstraintImpl.Relative right = Constraint.match((GeoRef)background.get(GeoParam.RIGHT));
        GuiScrolling scrollArea = new GuiScrolling(background);
        GuiElement scrollPane = scrollArea.getContentElement();
        scrollPane.constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)scrollArea.get(GeoParam.RIGHT)));
        Constraints.bind((ConstrainedGeometry)scrollArea, background);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(background, Axis.Y);
        ((GuiSlider)scrollBar.primary).setSliderState(scrollArea.scrollState(Axis.Y)).setScrollableElement((GuiElement)scrollArea);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> scrollArea.hiddenSize(Axis.Y) > 0.0).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        GuiElement lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)scrollPane.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, () -> Component.m_237113_((String)this.summary.summaryError).m_130940_(ChatFormatting.YELLOW)).setEnabled(() -> !this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = ((GuiTextList)((GuiTextList)((GuiTextList)((GuiTextList)new GuiTextList((GuiParent)scrollPane, () -> this.summary.serverFeatures.stream().map(Component::m_237113_).toList()).setScroll(false).setLineSpacing(1).setVerticalAlign(Align.CENTER).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        MutableComponent locText = Component.m_237115_((String)"minetogether:gui.order.summary.location");
        int locWidth = scrollPane.font().m_92852_((FormattedText)locText);
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)locText).setEnabled(() -> this.summary.summaryError.isEmpty())).setTooltipSingle(this::fallbackToolTip)).setTooltipDelay(0)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        ((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)lastElement, (Component)Component.m_237113_((String)"I").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN})).setEnabled(() -> this.summary.summaryError.isEmpty())).setTooltipSingle(this::fallbackToolTip)).setTooltipDelay(0)).setScroll(false).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.RIGHT), () -> OrderGui.lambda$setupSummaryPanel$18((Constraint)right, (Constraint)left, locWidth)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, () -> Component.m_237113_((String)this.getDCName(this.order.serverLocation))).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.plan")).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, () -> Component.m_237113_((String)this.summary.serverHostName)).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.features")).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        for (int i = 1; i < 6; ++i) {
            lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)("minetogether:gui.order.summary.feature" + i))).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)(i == 1 ? 2.0 : 1.0)))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        }
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.paying_for")).setEnabled(() -> this.summary.summaryError.isEmpty())).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.paying_for_details1")).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.paying_for_details2")).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)1.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.cancel_any_time")).setEnabled(() -> this.summary.summaryError.isEmpty())).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
    }

    private Component fallbackToolTip() {
        return Component.m_237110_((String)"minetogether:gui.order.summary.location_fallback", (Object[])new Object[]{Component.m_237113_((String)this.getDCName(this.order.serverLocation)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)this.getDCName(this.computeFallbackLocation())).m_130940_(ChatFormatting.GOLD)});
    }

    private void setupPricePanel(GuiElement<?> background) {
        background.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> 22.0 + (double)(this.summary.tax != 0.0 ? 10 : 0) + (double)(this.summary.discount != 0.0 ? 10 : 0)));
        GuiText total = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.total")).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0));
        GuiText totalValue = new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.total) + " " + this.summary.suffix))).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)totalValue, (ConstrainedGeometry)total);
        GuiText tax = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.tax")).setEnabled(() -> this.summary.tax != 0.0)).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)total.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.summary.tax != 0.0 ? 10.0 : 0.0));
        GuiText taxValue = ((GuiText)new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.tax) + " " + this.summary.suffix))).setEnabled(() -> this.summary.tax != 0.0)).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)taxValue, (ConstrainedGeometry)tax);
        GuiText discount = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.discount")).setEnabled(() -> this.summary.discount != 0.0)).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)tax.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.summary.discount != 0.0 ? 10.0 : 0.0));
        GuiText discountValue = ((GuiText)new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.discount) + " " + this.summary.suffix))).setEnabled(() -> this.summary.discount != 0.0)).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)discountValue, (ConstrainedGeometry)discount);
        GuiText subTotal = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.sub_total")).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)discount.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0));
        GuiText subTotalValue = new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.preDiscount) + " " + this.summary.suffix))).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)subTotalValue, (ConstrainedGeometry)subTotal);
    }

    private void buildProcessingScreen(GuiElement<?> root) {
        GuiRectangle background = ((GuiRectangle)((GuiRectangle)new GuiRectangle(root).setEnabled(() -> this.processing)).setOpaque(true)).fill(-536870912);
        Constraints.bind((ConstrainedGeometry)background, root);
        GuiText textList = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, () -> this.processingText).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.TOP), (GeoRef)background.get(GeoParam.BOTTOM), (double)-5.0))).autoHeight();
        this.processingButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237119_()).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.LEFT), (GeoRef)background.get(GeoParam.RIGHT), (double)-50.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.LEFT), (GeoRef)background.get(GeoParam.RIGHT), (double)50.0))).constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.TOP), (GeoRef)background.get(GeoParam.BOTTOM), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237115_((String)"minetogether:gui.button.close")).setEnabled(() -> this.processingShowCloseButton)).onPress(() -> root.getModularGui().getScreen().m_7379_()).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.processingButton.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.processingButton.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.processingButton.get(GeoParam.BOTTOM), (double)10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
    }

    private void setProcessing(@Nullable Component buttonText, @Nullable Runnable action, Component text) {
        this.processing = true;
        this.processingButton.setEnabled(buttonText != null && action != null);
        if (this.processingButton.isEnabled()) {
            this.processingButton.getLabel().setText(buttonText);
            this.processingButton.onPress(action);
        }
        this.processingText = text;
    }

    private void clearProcessing() {
        this.processing = false;
    }

    private void validateInputs() {
        this.inputsValid = false;
        if (!this.nameValid) {
            this.invalidMessage = this.nameMessage;
        } else if (!this.emailValid) {
            this.invalidMessage = this.emailMessage;
        } else if (!this.details.loginMode && !this.details.confirmPassword.equals(this.order.password)) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.passwords_dont_match");
        } else if (this.order.password.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.password");
        } else if (!this.details.loginMode && this.order.firstName.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.first_name");
        } else if (!this.details.loginMode && this.order.lastName.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.last_name");
        } else if (!this.details.loginMode && this.order.address.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.address");
        } else if (!this.details.loginMode && this.order.city.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.city");
        } else if (!this.details.loginMode && this.order.zip.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.zip");
        } else if (!this.details.loginMode && this.order.state.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.state");
        } else if (!this.details.loginMode && this.order.phone.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.phone");
        } else if (this.details.loginMode && !this.details.loggedIn) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.login_required");
        } else if (this.world.worldUploader != null) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.waiting_for_world_upload");
        } else {
            this.inputsValid = true;
        }
    }

    public void emailDirty() {
        this.emailValid = false;
        if (!EMAIL_PATTERN.matcher(this.order.emailAddress.toLowerCase()).matches()) {
            this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.email_invalid");
            return;
        }
        this.emailCheckTimer = 60;
        this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.email_not_checked");
    }

    public void nameDirty() {
        this.nameValid = false;
        this.nameMessage = Component.m_237115_((String)"minetogether:gui.order.name_not_checked");
        this.nameCheckTimer = 60;
    }

    public void summaryDirty() {
        this.summaryUpdateRequired = true;
    }

    private void placeOrder(ModularGui gui) {
        if (this.orderTask != null) {
            return;
        }
        this.orderTask = CompletableFuture.runAsync(() -> {
            ApiResponse result;
            if (!this.details.loginMode) {
                this.setProcessing(null, null, (Component)Component.m_237115_((String)"minetogether:gui.order.account_creating"));
                result = OrderRequests.createAccount(this.order);
                if (result.getStatus().equals("success")) {
                    this.order.currency = ((PostCreateAccountRequest.Response)result).currency != null ? ((PostCreateAccountRequest.Response)result).currency : "1";
                    this.order.clientID = ((PostCreateAccountRequest.Response)result).userid != null ? ((PostCreateAccountRequest.Response)result).userid : "0";
                } else {
                    this.setProcessing((Component)Component.m_237115_((String)"minetogether:gui.button.ok"), this::clearProcessing, (Component)Component.m_237110_((String)"minetogether:gui.order.account_error", (Object[])new Object[]{result}));
                    return;
                }
            }
            this.setProcessing(null, null, (Component)Component.m_237115_((String)"minetogether:gui.order.order_placing"));
            result = OrderRequests.placeOrder(this.order, this.getDCId(this.order.serverLocation), String.valueOf(Config.instance().pregenDiameter), this.computeFallbackLocation());
            if (!result.getStatus().equals("success")) {
                this.setProcessing((Component)Component.m_237115_((String)"minetogether:gui.button.ok"), this::clearProcessing, (Component)Component.m_237110_((String)"minetogether:gui.order.order_error", (Object[])new Object[]{result}));
                return;
            }
            this.invoiceID = ((PostOrderRequest.Response)result).more == null || ((PostOrderRequest.Response)result).more.invoiceid == null ? "0" : ((PostOrderRequest.Response)result).more.invoiceid;
            this.processingShowCloseButton = true;
            this.setProcessing((Component)Component.m_237115_((String)"minetogether:gui.button.invoice"), () -> {
                try {
                    Util.m_137581_().m_137648_(new URI(OrderGui.getPaymentLink(this.invoiceID)));
                }
                catch (Throwable throwable) {
                    gui.mc().f_91068_.m_90911_(OrderGui.getPaymentLink(this.invoiceID));
                    this.processingText = Component.m_237113_((String)"Something went wrong while attempting to open the link,\nSo the link has been copied to your clipboard.");
                    LOGGER.error("Couldn't open link", throwable);
                }
            }, (Component)Component.m_237115_((String)"minetogether:gui.order.order_success"));
        }, EXECUTOR);
    }

    private void tick(ModularGui gui) {
        if (!this.nameValid && --this.nameCheckTimer == 0) {
            if (this.order.name.isEmpty()) {
                this.nameMessage = Component.m_237115_((String)"minetogether:gui.order.blank.name");
            } else {
                this.nameMessage = Component.m_237115_((String)"minetogether:gui.order.name_checking");
                CompletableFuture.runAsync(() -> {
                    ApiResponse result = OrderRequests.getNameAvailable(this.order.name);
                    this.nameValid = "success".equals(result.getStatus());
                    this.nameMessage = Component.m_237113_((String)result.getMessage());
                }, EXECUTOR);
            }
        }
        if (!this.emailValid && --this.emailCheckTimer == 0) {
            if (this.order.emailAddress.isEmpty()) {
                this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.blank.email");
            } else {
                this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.email_checking");
                CompletableFuture.runAsync(() -> {
                    this.details.loginMode = OrderRequests.doesAccountExist(this.order.emailAddress);
                    this.emailValid = true;
                    this.emailMessage = null;
                }, EXECUTOR);
            }
        }
        if (this.initTask != null && this.initTask.isDone() && this.locations != null) {
            this.initTask = null;
            this.locations.updateLocations();
        }
        if (this.initTask == null && this.pingTask == null && this.pingTimer-- <= 0) {
            this.pingTask = CompletableFuture.runAsync(() -> {
                boolean allDone;
                ArrayList pingers = new ArrayList();
                this.dcMap.forEach((name, dc) -> pingers.add(CompletableFuture.runAsync(() -> {
                    long distance = this.dcDistance.get(name);
                    if (dc.latencyUrl == null || distance == -1L) {
                        this.dcPing.put((String)name, -2);
                    } else {
                        this.dcPing.put((String)name, OrderRequests.getDCLatency(dc.latencyUrl, distance));
                    }
                    this.pingUpdated = true;
                }, PING_EXECUTOR)));
                while (!(allDone = pingers.stream().allMatch(CompletableFuture::isDone))) {
                }
                this.pingTimer = 200;
            }, PING_EXECUTOR);
        } else if (this.pingTask != null && this.pingTask.isDone()) {
            this.pingTask = null;
            this.locations.updateLocations();
        }
        if (this.pingUpdated) {
            this.pingUpdated = false;
            this.locations.updateLocations();
        }
        if (this.summaryUpdateRequired && !this.summaryUpdating) {
            this.summaryUpdating = true;
            this.summaryUpdateRequired = false;
            this.summaryTask = CompletableFuture.runAsync(() -> {
                this.summary = OrderRequests.getSummary(this.order, Config.instance().promoCode);
                this.order.productID = this.summary.productID;
                this.order.currency = this.summary.currency;
                this.summaryUpdating = false;
                CompletableFuture.runAsync(() -> OrderRequests.getDataCenters(this.summary.ram + 4096).forEach(dc -> this.dcMap.put(dc.slug, (GetDataCentresRequest.DC)dc)), EXECUTOR);
            }, EXECUTOR);
        }
        if (this.summaryTask != null && this.summaryTask.isDone()) {
            this.summaryTask = null;
            this.locations.updateLocations();
        }
        if (this.orderTask != null && this.orderTask.isDone()) {
            this.orderTask = null;
        }
        if (this.world.worldUploader != null && !this.world.worldUploader.errored() && this.world.worldUploader.isFinished()) {
            this.order.worldUrl = this.world.worldUploader.getResultFileURL();
            this.world.worldUploader = null;
        }
        this.validateInputs();
    }

    private Component getOrderButtonText() {
        if (this.orderTask != null) {
            return Component.m_237115_((String)"minetogether:gui.order.order_in_progress");
        }
        if (this.summaryUpdating || this.summaryUpdateRequired) {
            return Component.m_237115_((String)"minetogether:gui.order.summary.updating");
        }
        if (this.inputsValid) {
            return Component.m_237115_((String)"minetogether:gui.order.place_order");
        }
        return this.invalidMessage == null ? Component.m_237119_() : this.invalidMessage.m_6881_().m_130940_(ChatFormatting.RED);
    }

    public Country getSelectedCountry() {
        return new Country(this.order.country, Countries.COUNTRIES.get(this.order.country));
    }

    private String getDCId(String dc) {
        return this.dcIdMap.getOrDefault(dc, dc);
    }

    private String getDCName(String dc) {
        return this.dcMap.containsKey(dc) ? this.dcMap.get((Object)dc).name : dc;
    }

    private String computeFallbackLocation() {
        if (!this.order.useFallback) {
            return "";
        }
        String fallBack = "";
        long lowest = Integer.MAX_VALUE;
        for (String dc : this.dcPing.keySet()) {
            int ping = this.dcPing.get(dc);
            if (ping <= 0 || dc.equals(this.order.serverLocation) || (long)ping >= lowest) continue;
            lowest = ping;
            fallBack = dc;
        }
        if (fallBack.isEmpty()) {
            for (String dc : this.dcDistance.keySet()) {
                long distance = this.dcDistance.get(dc);
                if (distance <= 0L || dc.equals(this.order.serverLocation) || distance >= lowest) continue;
                lowest = distance;
                fallBack = dc;
            }
        }
        return fallBack;
    }

    public static String getDefaultName() {
        String[] nm1 = new String[]{"amber", "angel", "spirit", "basin", "lagoon", "basin", "arrow", "autumn", "bare", "bay", "beach", "bear", "bell", "black", "bleak", "blind", "bone", "boulder", "bridge", "brine", "brittle", "bronze", "castle", "cave", "chill", "clay", "clear", "cliff", "cloud", "cold", "crag", "crow", "crystal", "curse", "dark", "dawn", "dead", "deep", "deer", "demon", "dew", "dim", "dire", "dirt", "dog", "dragon", "dry", "dusk", "dust", "eagle", "earth", "east", "ebon", "edge", "elder", "ember", "ever", "fair", "fall", "false", "far", "fay", "fear", "flame", "flat", "frey", "frost", "ghost", "glimmer", "gloom", "gold", "grass", "gray", "green", "grim", "grime", "hazel", "heart", "high", "hollow", "honey", "hound", "ice", "iron", "kil", "knight", "lake", "last", "light", "lime", "little", "lost", "mad", "mage", "maple", "mid", "might", "mill", "mist", "moon", "moss", "mud", "mute", "myth", "never", "new", "night", "north", "oaken", "ocean", "old", "ox", "pearl", "pine", "pond", "pure", "quick", "rage", "raven", "red", "rime", "river", "rock", "rogue", "rose", "rust", "salt", "sand", "scorch", "shade", "shadow", "shimmer", "shroud", "silent", "silk", "silver", "sleek", "sleet", "sly", "small", "smooth", "snake", "snow", "south", "spring", "stag", "star", "steam", "steel", "steep", "still", "stone", "storm", "summer", "sun", "swamp", "swan", "swift", "thorn", "timber", "trade", "west", "whale", "whit", "white", "wild", "wilde", "wind", "winter", "wolf"};
        String[] nm2 = new String[]{"acre", "band", "barrow", "bay", "bell", "born", "borough", "bourne", "breach", "break", "brook", "burgh", "burn", "bury", "cairn", "call", "chill", "cliff", "coast", "crest", "cross", "dale", "denn", "drift", "fair", "fall", "falls", "fell", "field", "ford", "forest", "fort", "front", "frost", "garde", "gate", "glen", "grasp", "grave", "grove", "guard", "gulch", "gulf", "hall", "hallow", "ham", "hand", "harbor", "haven", "helm", "hill", "hold", "holde", "hollow", "horn", "host", "keep", "land", "light", "maw", "meadow", "mere", "mire", "mond", "moor", "more", "mount", "mouth", "pass", "peak", "point", "pond", "port", "post", "reach", "rest", "rock", "run", "scar", "shade", "shear", "shell", "shield", "shore", "shire", "side", "spell", "spire", "stall", "wich", "minster", "star", "storm", "strand", "summit", "tide", "town", "vale", "valley", "vault", "vein", "view", "ville", "wall", "wallow", "ward", "watch", "water", "well", "wharf", "wick", "wind", "wood", "yard"};
        int rnd = RAND.nextInt(nm1.length);
        int rnd2 = RAND.nextInt(nm2.length);
        while (Objects.equals(nm1[rnd], nm2[rnd2])) {
            rnd2 = RAND.nextInt(nm2.length);
        }
        return nm1[rnd] + nm2[rnd2] + RAND.nextInt(999);
    }

    public Material getFlag(GetDataCentresRequest.DC dc) {
        String code = dc.country.toUpperCase(Locale.ROOT);
        code = Countries.COUNTRIES.containsKey(code) ? code.toLowerCase(Locale.ROOT) : "unknown";
        return MTTextures.get("flags/" + code);
    }

    public double flagWidth(GetDataCentresRequest.DC dc, double height) {
        TextureAtlasSprite sprite = this.getFlag(dc).sprite();
        return (double)sprite.m_118405_() / (double)sprite.m_118408_() * height;
    }

    public static String getPaymentLink(String invoiceID) {
        return "https://billing.creeperhost.net/viewinvoice.php?id=" + invoiceID;
    }

    private static /* synthetic */ Double lambda$setupSummaryPanel$18(Constraint right, Constraint left, int locWidth) {
        return 2.0 - (right.get() - left.get() - (double)locWidth) / 2.0;
    }

    public record Country(String key, String name) {
        @Override
        public String toString() {
            return this.name == null ? "" : this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Country country = (Country)o;
            return Objects.equals(this.key, country.key) && Objects.equals(this.name, country.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.name);
        }
    }

    public static class Screen
    extends ModularGuiScreen {
        public Screen(net.minecraft.client.gui.screens.Screen parentScreen) {
            super((GuiProvider)new OrderGui(), parentScreen);
        }
    }
}

