/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.creeperhost.minetogether.chat.gui.MessageElement;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.util.MessageFormatter;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewElement
extends GuiElement<PreviewElement> {
    private static final Pattern META_IMAGE_PATTERN = Pattern.compile("^<meta +property=\"og:image(?::url)?\" +content=\"([^\"]+)\" *\\/>$");
    private static final Set<String> SUPPORTED_IMAGES = ImmutableSet.of((Object)"image/jpeg", (Object)"image/png", (Object)"image/bmp", (Object)"image/gif");
    private static final Set<String> ALLOWED_DOMAINS = ImmutableSet.of((Object)"blockshot.ch");
    private static final boolean DEBUG = Boolean.getBoolean("PreviewRenderer.debug");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().build();
    private static final ExecutorService PREVIEW_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("preview-render-%d").setDaemon(true).build());
    private static final Set<URL> INVALID_URLS = Collections.synchronizedSet(new HashSet());
    private static final Cache<URL, ImageLoader> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(e -> {
        if (e.wasEvicted()) {
            try {
                ((ImageLoader)e.getValue()).close();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to close Preview: {}", e.getKey(), (Object)ex);
            }
        }
    }).build();
    private URLProvider urlProvider;
    private int imageSize = 80;
    private boolean enforceDomains = true;

    public PreviewElement(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public PreviewElement setUrlProvider(URLProvider urlProvider) {
        this.urlProvider = urlProvider;
        return this;
    }

    public PreviewElement setImageSize(int imageSize) {
        this.imageSize = imageSize;
        return this;
    }

    public PreviewElement setEnforceDomains(boolean enforceDomains) {
        this.enforceDomains = enforceDomains;
        return this;
    }

    public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
        if (super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed) || this.urlProvider == null) {
            return true;
        }
        URLInfo url = this.urlProvider.getUrlUnderMouse((int)mouseX, (int)mouseY);
        if (url == null) {
            return false;
        }
        ImageLoader image = this.getImage(url);
        if (image == null) {
            return false;
        }
        if (image.isLoaded()) {
            double aspect = (double)image.width() / (double)image.height();
            double width = aspect > 1.0 ? (double)this.imageSize : (double)this.imageSize * aspect;
            double height = aspect > 1.0 ? (double)this.imageSize / aspect : (double)this.imageSize;
            double border = 3.0;
            double x = Math.min(mouseX, (double)this.scaledScreenWidth() - (width + border * 2.0));
            double y = Math.min(mouseY, (double)this.scaledScreenHeight() - (height + border * 2.0));
            render.toolTipBackground(x, y, width + border * 2.0, height + border * 2.0);
            image.render(render, x + border, y + border, width, height);
        } else {
            render.renderTooltip((Component)Component.m_237115_((String)"minetogether:gui.chat.loading_preview"), mouseX, mouseY);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ImageLoader getImage(URLInfo info) {
        URL url = info.url();
        if (this.enforceDomains && !info.admin() && !ALLOWED_DOMAINS.contains(url.getHost())) {
            return null;
        }
        if (INVALID_URLS.contains(url)) {
            return null;
        }
        Cache<URL, ImageLoader> cache = CACHE;
        synchronized (cache) {
            ImageLoader cached = (ImageLoader)CACHE.getIfPresent((Object)url);
            if (cached != null) {
                return cached;
            }
            ImageLoader preview = new ImageLoader();
            PREVIEW_EXECUTOR.execute(() -> preview.load(url, false));
            CACHE.put((Object)url, (Object)preview);
            return preview;
        }
    }

    @Nullable
    public static URL urlFromStyle(@Nullable Style style) {
        if (style == null) {
            return null;
        }
        HoverEvent event = style.m_131186_();
        if (event == null || event.m_130820_() != MessageFormatter.SHOW_URL_PREVIEW) {
            return null;
        }
        Component value = (Component)event.m_130823_(MessageFormatter.SHOW_URL_PREVIEW);
        try {
            return URI.create(value.getString()).toURL();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static URLInfo getHoveredURL(GuiList<Message> chatList, double mouseX, double mouseY) {
        for (GuiElement child : chatList.getChildren()) {
            if (!(child instanceof MessageElement)) continue;
            MessageElement msgEle = (MessageElement)child;
            if (!child.isMouseOver()) continue;
            Message message = msgEle.getMessage();
            Style style = msgEle.getStyleAtPos(mouseX, mouseY);
            URL url = PreviewElement.urlFromStyle(style);
            if (url == null) {
                return null;
            }
            return new URLInfo(url, message != null && message.sender == null);
        }
        return null;
    }

    public static interface URLProvider {
        public URLInfo getUrlUnderMouse(double var1, double var3);
    }

    public record URLInfo(URL url, boolean admin) {
    }

    private static class ImageLoader {
        @Nullable
        private NativeImage image = null;
        private int glTexture = -1;
        private volatile boolean loaded = false;

        private ImageLoader() {
        }

        private void load(URL url, boolean ogRedirect) {
            try (CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)new HttpGet(url.toURI()));){
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    if (DEBUG) {
                        LOGGER.info("Ignoring {} for preview, Entity null", (Object)url);
                    }
                    INVALID_URLS.add(url);
                    return;
                }
                if (SUPPORTED_IMAGES.contains(entity.getContentType().getValue())) {
                    BufferedImage bufferedImage = ImageIO.read(entity.getContent());
                    this.image = new NativeImage(NativeImage.Format.RGBA, bufferedImage.getWidth(), bufferedImage.getHeight(), false);
                    for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                        for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                            int argb = bufferedImage.getRGB(x, y);
                            int a = argb >>> 24;
                            int r = argb >> 16 & 0xFF;
                            int g = argb >> 8 & 0xFF;
                            int b = argb & 0xFF;
                            this.image.m_84988_(x, y, a << 24 | b << 16 | g << 8 | r);
                        }
                    }
                    this.loaded = true;
                    return;
                }
                if (ogRedirect) {
                    if (DEBUG) {
                        LOGGER.info("Ignoring {} for preview, Invalid og:image type {}", (Object)url, (Object)entity.getContentType());
                    }
                    INVALID_URLS.add(url);
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) != null) {
                            Matcher matcher = META_IMAGE_PATTERN.matcher(line);
                            if (!matcher.find()) continue;
                            String link = matcher.group(1);
                            if (link != null) {
                                this.load(URI.create(link).toURL(), true);
                            }
                            return;
                            continue;
                        }
                        break;
                    }
                }
                INVALID_URLS.add(url);
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to load preview for: {}", (Object)url, (Object)ex);
                INVALID_URLS.add(url);
            }
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        private int width() {
            return this.image.m_84982_();
        }

        private int height() {
            return this.image.m_85084_();
        }

        public void render(GuiRender render, double x, double y, double width, double height) {
            if (this.glTexture == -1) {
                this.glTexture = TextureUtil.m_85280_();
                TextureUtil.m_85287_((int)this.glTexture, (int)0, (int)this.image.m_84982_(), (int)this.image.m_85084_());
                this.image.m_85003_(0, 0, 0, 0, 0, this.image.m_84982_(), this.image.m_85084_(), false, true);
            }
            double x2 = x + width;
            double y2 = y + height;
            RenderSystem.m_157453_((int)0, (int)this.glTexture);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            Matrix4f matrix4f = render.pose().m_85850_().m_85861_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_85982_(matrix4f, (float)x, (float)y2, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(matrix4f, (float)x2, (float)y2, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(matrix4f, (float)x2, (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public void close() {
            if (this.glTexture != -1) {
                TextureUtil.m_85281_((int)this.glTexture);
                this.glTexture = -1;
            }
            if (this.image != null) {
                this.image.close();
            }
        }
    }
}

