/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    public static SecretKey generateAESKey() {
        try {
            KeyGenerator aes = KeyGenerator.getInstance("AES");
            aes.init(128);
            return aes.generateKey();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("No AES??", ex);
        }
    }

    public static Cipher loadCipher(int opmode, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
            cipher.init(opmode, (Key)key, new IvParameterSpec(key.getEncoded()));
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            throw new RuntimeException("Failed to load AES.", ex);
        }
    }

    public static SecretKey readSecretKey(byte[] bytes) {
        return new SecretKeySpec(bytes, "AES");
    }
}

