/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.gui.ServerListAppender;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class FriendServerEntry
extends ServerSelectionList.NetworkServerEntry {
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    private static final Component INCOMPATIBLE_TOOLTIP = Component.m_237115_((String)"multiplayer.status.incompatible");
    private static final Component NO_CONNECTION_TOOLTIP = Component.m_237115_((String)"multiplayer.status.no_connection");
    private static final Component PINGING_TOOLTIP = Component.m_237115_((String)"multiplayer.status.pinging");
    private final JoinMultiplayerScreen screen;
    public final RemoteServer remoteServer;
    public final Profile friendProfile;
    private final ServerListAppender listAppender;
    private final ResourceLocation iconLocation;
    @Nullable
    private String lastIconB64;
    @Nullable
    private DynamicTexture icon;

    protected FriendServerEntry(JoinMultiplayerScreen joinMultiplayerScreen, RemoteServer remoteServer, Profile friendProfile, ServerListAppender listAppender) {
        super(joinMultiplayerScreen, new LanServer("Dummy Server", "0.0.0.0"));
        this.screen = joinMultiplayerScreen;
        this.remoteServer = remoteServer;
        this.friendProfile = friendProfile;
        this.listAppender = listAppender;
        this.iconLocation = new ResourceLocation("servers/" + friendProfile.getFullHash().toLowerCase(Locale.ROOT) + "/icon");
    }

    public void m_6311_(PoseStack poseStack, int entryIndex, int y, int x, int entryWidth, int m, int mouseX, int mouseY, boolean selected, float f) {
        List<Object> playersToolTip;
        Component statusToolTip;
        int singnalBarsInvrse;
        if (!this.remoteServer.pinged) {
            this.remoteServer.pinged = true;
            this.remoteServer.ping = -2L;
            this.remoteServer.motd = Component.m_237119_();
            this.remoteServer.status = Component.m_237119_();
            ServerSelectionList.f_99757_.submit(() -> {
                try {
                    this.listAppender.pingServer(this.remoteServer, this.friendProfile);
                }
                catch (Exception var2) {
                    this.remoteServer.ping = -1L;
                }
            });
        }
        this.f_99828_.f_91062_.m_92889_(poseStack, (Component)Component.m_237110_((String)"minetogether.connect.friend.server.title", (Object[])new Object[]{this.getDisplayName()}), (float)(x + 32 + 3), (float)(y + 1), 0xFFFFFF);
        List list = this.f_99828_.f_91062_.m_92923_((FormattedText)this.remoteServer.motd, entryWidth - 32 - 2);
        for (int line = 0; line < Math.min(list.size(), 2); ++line) {
            Font var10000 = this.f_99828_.f_91062_;
            FormattedCharSequence var10002 = (FormattedCharSequence)list.get(line);
            float var10003 = x + 32 + 3;
            int var10004 = y + 12;
            Objects.requireNonNull(this.f_99828_.f_91062_);
            var10000.m_92877_(poseStack, var10002, var10003, (float)(var10004 + 9 * line), 0x808080);
        }
        boolean versionMismatch = this.remoteServer.protocol != SharedConstants.m_183709_().getProtocolVersion();
        Component statusText = versionMismatch ? this.remoteServer.version.m_6881_().m_130940_(ChatFormatting.RED) : this.remoteServer.status;
        int statusWidth = this.f_99828_.f_91062_.m_92852_((FormattedText)statusText);
        this.f_99828_.f_91062_.m_92889_(poseStack, statusText, (float)(x + entryWidth - statusWidth - 15 - 2), (float)(y + 1), 0x808080);
        int signalTexSelect = 0;
        if (versionMismatch) {
            singnalBarsInvrse = 5;
            statusToolTip = INCOMPATIBLE_TOOLTIP;
            playersToolTip = this.remoteServer.playerList;
        } else if (this.remoteServer.pinged && this.remoteServer.ping != -2L) {
            singnalBarsInvrse = this.remoteServer.ping < 0L ? 5 : (this.remoteServer.ping < 150L ? 0 : (this.remoteServer.ping < 300L ? 1 : (this.remoteServer.ping < 600L ? 2 : (this.remoteServer.ping < 1000L ? 3 : 4))));
            if (this.remoteServer.ping < 0L) {
                statusToolTip = NO_CONNECTION_TOOLTIP;
                playersToolTip = Collections.emptyList();
            } else {
                statusToolTip = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.remoteServer.ping});
                playersToolTip = this.remoteServer.playerList;
            }
        } else {
            signalTexSelect = 1;
            singnalBarsInvrse = (int)(Util.m_137550_() / 100L + (long)entryIndex * 2L & 7L);
            if (singnalBarsInvrse > 4) {
                singnalBarsInvrse = 8 - singnalBarsInvrse;
            }
            statusToolTip = PINGING_TOOLTIP;
            playersToolTip = Collections.emptyList();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + entryWidth - 15), (int)y, (float)(signalTexSelect * 10), (float)(176 + singnalBarsInvrse * 8), (int)10, (int)8, (int)256, (int)256);
        String string = this.remoteServer.getIconB64();
        if (!Objects.equals(string, this.lastIconB64)) {
            if (this.uploadServerIcon(string)) {
                this.lastIconB64 = string;
            } else {
                this.remoteServer.setIconB64(null);
            }
        }
        if (this.icon == null) {
            this.drawIcon(poseStack, x, y, ICON_MISSING);
        } else {
            this.drawIcon(poseStack, x, y, this.iconLocation);
        }
        int t = mouseX - x;
        int u = mouseY - y;
        if (t >= entryWidth - 15 && t <= entryWidth - 5 && u >= 0 && u <= 8) {
            this.screen.m_99707_(Collections.singletonList(statusToolTip));
        } else if (t >= entryWidth - statusWidth - 15 - 2 && t <= entryWidth - 15 - 2 && u >= 0 && u <= 8) {
            this.screen.m_99707_(playersToolTip);
        }
        if (((Boolean)this.f_99828_.f_91066_.m_231828_().m_231551_()).booleanValue() || selected) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + 32), (int)(y + 32), (int)-1601138544);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int v = mouseX - x;
            if (v < 32 && v > 16) {
                GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
            } else {
                GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
            }
        }
    }

    public String getDisplayName() {
        return this.friendProfile.isFriend() ? this.friendProfile.getFriendName() : this.friendProfile.getDisplayName();
    }

    protected void drawIcon(PoseStack poseStack, int i, int j, ResourceLocation resourceLocation) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.m_69478_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        RenderSystem.m_69461_();
    }

    private boolean uploadServerIcon(@Nullable String string) {
        if (string == null) {
            this.f_99828_.m_91097_().m_118513_(this.iconLocation);
            if (this.icon != null && this.icon.m_117991_() != null) {
                this.icon.m_117991_().close();
            }
            this.icon = null;
        } else {
            try {
                NativeImage nativeImage = NativeImage.m_85060_((String)string);
                Validate.validState((nativeImage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((nativeImage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                if (this.icon == null) {
                    this.icon = new DynamicTexture(nativeImage);
                } else {
                    this.icon.m_117988_(nativeImage);
                    this.icon.m_117985_();
                }
                this.f_99828_.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)this.icon);
            }
            catch (Throwable var3) {
                return false;
            }
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double f;
        if (this.listAppender.getServerList() != null && (f = mouseX - (double)this.listAppender.getServerList().m_5747_()) < 32.0 && f > 16.0) {
            this.screen.m_99700_((ServerSelectionList.Entry)this);
            this.screen.m_99729_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

