/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.config;

import dev.architectury.platform.Platform;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.repack.blue.endless.jankson.Comment;
import net.creeperhost.minetogether.repack.blue.endless.jankson.Jankson;
import net.creeperhost.minetogether.repack.blue.endless.jankson.JsonGrammar;
import net.creeperhost.minetogether.repack.blue.endless.jankson.api.SyntaxError;
import net.creeperhost.minetogether.repack.net.covers1624.quack.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LocalConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Jankson JANKSON = Jankson.builder().build();
    private static final JsonGrammar GRAMMAR = JsonGrammar.JSON5;
    @Nullable
    private static LocalConfig INSTANCE;
    @Nullable
    private static Path filePath;
    @Comment(value="If the Chat component of MineTogether is enabled.")
    public boolean chatEnabled = true;
    @Comment(value="If notifications for friends are enabled.")
    public boolean friendNotifications = true;
    @Comment(value="Enable / disable chat settings sliders.")
    public boolean chatSettingsSliders = true;
    @Comment(value="If menu buttons are enabled.")
    public boolean mainMenuButtons = true;
    @Comment(value="If the Multiplayer server list should have CreeperHost adverts.")
    public boolean mpMenuEnabled = true;
    @Comment(value="INTERNAL: Marker for tracking first connections.")
    public Set<String> firstConnect = new HashSet<String>();
    @Comment(value="Stores the currently selected chat TAB. Either VANILLA or PUBLIC.")
    public ChatTarget selectedTab = ChatTarget.PUBLIC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalConfig instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<LocalConfig> clazz = LocalConfig.class;
        synchronized (LocalConfig.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = LocalConfig.loadConfig(Platform.getGameFolder().resolve("local/minetogether/minetogether.json"));
            LocalConfig.save();
            Config.instance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void save() {
        assert (INSTANCE != null);
        assert (filePath != null);
        try (BufferedWriter writer = Files.newBufferedWriter(IOUtils.makeParents(filePath), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.append(JANKSON.toJson(INSTANCE).toJson(GRAMMAR));
            writer.flush();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to save config file to: " + filePath, (Throwable)ex);
        }
    }

    private static synchronized LocalConfig loadConfig(Path file) {
        LocalConfig config;
        if (Files.exists(file = file.toAbsolutePath(), new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                config = JANKSON.fromJson(JANKSON.load(is), LocalConfig.class);
            }
            catch (IOException | SyntaxError ex) {
                LOGGER.error("Failed to read config file from '" + file + "' - Resetting to default.", (Throwable)ex);
                config = new LocalConfig();
            }
        } else {
            config = new LocalConfig();
        }
        filePath = file;
        return config;
    }
}

