/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.builder;

import java.io.OutputStream;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.ServiceBuilderOAuth10a;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.ServiceBuilderOAuth20;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.api.DefaultApi10a;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.api.DefaultApi20;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.HttpClient;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.HttpClientConfig;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.OAuth10aService;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.OAuth20Service;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.Preconditions;

public class ServiceBuilder
implements ServiceBuilderOAuth10a,
ServiceBuilderOAuth20 {
    private String callback;
    private String apiKey;
    private String apiSecret;
    private String scope;
    private OutputStream debugStream;
    private String responseType = "code";
    private String userAgent;
    private HttpClientConfig httpClientConfig;
    private HttpClient httpClient;

    public ServiceBuilder(String apiKey) {
        this.apiKey(apiKey);
    }

    @Override
    public ServiceBuilder callback(String callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public final ServiceBuilder apiKey(String apiKey) {
        Preconditions.checkEmptyString(apiKey, "Invalid Api key");
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public ServiceBuilder apiSecret(String apiSecret) {
        Preconditions.checkEmptyString(apiSecret, "Invalid Api secret");
        this.apiSecret = apiSecret;
        return this;
    }

    private ServiceBuilder setScope(String scope) {
        Preconditions.checkEmptyString(scope, "Invalid OAuth scope");
        this.scope = scope;
        return this;
    }

    @Override
    public ServiceBuilderOAuth20 defaultScope(String defaultScope) {
        return this.setScope(defaultScope);
    }

    @Override
    public ServiceBuilderOAuth10a withScope(String scope) {
        return this.setScope(scope);
    }

    @Override
    public ServiceBuilder debugStream(OutputStream debugStream) {
        Preconditions.checkNotNull(debugStream, "debug stream can't be null");
        this.debugStream = debugStream;
        return this;
    }

    @Override
    public ServiceBuilderOAuth20 responseType(String responseType) {
        Preconditions.checkEmptyString(responseType, "Invalid OAuth responseType");
        this.responseType = responseType;
        return this;
    }

    @Override
    public ServiceBuilder httpClientConfig(HttpClientConfig httpClientConfig) {
        Preconditions.checkNotNull(httpClientConfig, "httpClientConfig can't be null");
        this.httpClientConfig = httpClientConfig;
        return this;
    }

    @Override
    public ServiceBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public ServiceBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public ServiceBuilder debug() {
        return this.debugStream(System.out);
    }

    @Override
    public OAuth10aService build(DefaultApi10a api) {
        return api.createService(this.apiKey, this.apiSecret, this.callback, this.scope, this.debugStream, this.userAgent, this.httpClientConfig, this.httpClient);
    }

    @Override
    public OAuth20Service build(DefaultApi20 api) {
        return api.createService(this.apiKey, this.apiSecret, this.callback, this.scope, this.responseType, this.debugStream, this.userAgent, this.httpClientConfig, this.httpClient);
    }
}

