/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.ingame;

import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.DisplayableMessage;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MTChatComponent
extends ChatComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_MESSAGE_HISTORY = 150;
    private final ChatTarget target;
    private final Minecraft minecraft;
    private boolean internalUpdate = false;
    private final List<InGameDisplayableMessage> changedMessages = new LinkedList<InGameDisplayableMessage>();
    private final LinkedList<Message> pendingMessages = new LinkedList();
    private final List<InGameDisplayableMessage> processedMessages = new ArrayList<InGameDisplayableMessage>();
    @Nullable
    private IrcChannel channel;
    @Nullable
    private Message clickedMessage;

    public MTChatComponent(ChatTarget target, Minecraft minecraft) {
        super(minecraft);
        this.target = target;
        this.minecraft = minecraft;
        assert (target != ChatTarget.VANILLA) : "MTChatComponent doesn't work this way";
    }

    public void attach(IrcChannel channel) {
        if (this.channel != null) {
            return;
        }
        this.channel = channel;
        channel.addListener(message -> {
            LinkedList<Message> linkedList = this.pendingMessages;
            synchronized (linkedList) {
                this.pendingMessages.add(message);
            }
        });
    }

    public void tick() {
        IrcChannel channel;
        if (this.channel == null && this.target == ChatTarget.PUBLIC && (channel = MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel()) != null) {
            this.attach(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_93780_(PoseStack poseStack, int i) {
        List<Object> list;
        if (!this.pendingMessages.isEmpty()) {
            this.internalUpdate = true;
            list = this.pendingMessages;
            synchronized (list) {
                for (Message pendingMessage : this.pendingMessages) {
                    this.addMessage(pendingMessage);
                }
                this.pendingMessages.clear();
            }
            this.internalUpdate = false;
        }
        if (!this.changedMessages.isEmpty()) {
            list = this.changedMessages;
            synchronized (list) {
                for (InGameDisplayableMessage changedMessage : this.changedMessages) {
                    changedMessage.reformat();
                }
                this.changedMessages.clear();
            }
        }
        super.m_93780_(poseStack, i);
    }

    public void m_93769_() {
        if (MineTogetherChat.getTarget() == this.target) {
            MineTogetherChat.vanillaChat.m_93769_();
        }
        this.f_93761_.clear();
        this.m_93810_();
        for (InGameDisplayableMessage message : this.processedMessages) {
            message.format();
            message.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_93795_(boolean bl) {
        if (MineTogetherChat.getTarget() == this.target) {
            MineTogetherChat.vanillaChat.m_93795_(bl);
        }
        LinkedList<Message> linkedList = this.pendingMessages;
        synchronized (linkedList) {
            this.pendingMessages.clear();
        }
        for (InGameDisplayableMessage message : this.processedMessages) {
            message.onDead();
        }
        this.processedMessages.clear();
        this.f_93761_.clear();
    }

    public void m_93783_(String string) {
        if (this.channel == null) {
            LOGGER.error("Can't send message, chat is not bound!");
            return;
        }
        this.channel.sendMessage(string);
    }

    private void addMessage(Message message) {
        InGameDisplayableMessage newMessage = new InGameDisplayableMessage(message);
        this.processedMessages.add(newMessage);
        newMessage.display();
        if (this.m_93818_() && this.f_93763_ > 0) {
            this.f_93764_ = true;
            this.m_205360_(1);
        }
        while (this.processedMessages.size() > 150) {
            InGameDisplayableMessage toRemove = this.processedMessages.remove(0);
            this.f_93761_.removeAll(toRemove.getTrimmedLines());
            toRemove.onDead();
        }
    }

    public void localMessage(@Nullable Component message, MessageSignature signature) {
        LocalMessage oldMessage = FastStream.of(this.processedMessages).filter(e -> {
            if (!(e instanceof LocalMessage)) return false;
            LocalMessage msg = (LocalMessage)e;
            if (!msg.signature.equals((Object)signature)) return false;
            return true;
        }).map(e -> (LocalMessage)e).findFirst().orElse(null);
        if (oldMessage != null) {
            this.processedMessages.remove(oldMessage);
            if (oldMessage.line != null) {
                this.f_93761_.remove(oldMessage.line);
            }
        }
        if (message == null) {
            return;
        }
        LocalMessage newMessage = new LocalMessage(message, signature);
        this.processedMessages.add(newMessage);
        newMessage.display();
        if (this.m_93818_() && this.f_93763_ > 0) {
            this.f_93764_ = true;
            this.m_205360_(1);
        }
        while (this.processedMessages.size() > 150) {
            InGameDisplayableMessage toRemove = this.processedMessages.remove(0);
            this.f_93761_.removeAll(toRemove.getTrimmedLines());
            toRemove.onDead();
        }
    }

    public void m_93785_(Component component) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.m_93785_(component);
    }

    public void m_240964_(Component component, @Nullable MessageSignature messageSignature, @Nullable GuiMessageTag guiMessageTag) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.m_240964_(component, messageSignature, guiMessageTag);
    }

    public void m_240465_(Component component, @Nullable MessageSignature messageSignature, int i, @Nullable GuiMessageTag guiMessageTag, boolean bl) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.m_240465_(component, messageSignature, i, guiMessageTag, bl);
    }

    public void m_240953_(MessageSignature messageSignature) {
        assert (!this.internalUpdate);
        MineTogetherChat.vanillaChat.m_240953_(messageSignature);
    }

    public boolean handleClick(double mouseX, double mouseY) {
        if (!this.m_93818_()) {
            return false;
        }
        double x = mouseX - 2.0;
        double y = (double)this.minecraft.m_91268_().m_85446_() - mouseY - 40.0;
        x = Mth.m_14107_((double)(x / this.m_93815_()));
        y = Mth.m_14107_((double)(y / (this.m_93815_() * ((Double)this.minecraft.f_91066_.m_232101_().m_231551_() + 1.0))));
        if (x < 0.0 || y < 0.0) {
            return false;
        }
        int i = Math.min(this.m_93816_(), this.f_93761_.size());
        if (x <= (double)Mth.m_14107_((double)((double)this.m_93813_() / this.m_93815_()))) {
            Objects.requireNonNull(this.minecraft.f_91062_);
            if (y < (double)(9 * i + i)) {
                Objects.requireNonNull(this.minecraft.f_91062_);
                int j = (int)(y / 9.0 + (double)this.f_93763_);
                if (j >= 0 && j < this.f_93761_.size()) {
                    return this.handleClickedMessage(this.findMessageForTrimmedMessage((GuiMessage.Line)this.f_93761_.get(j)), x);
                }
            }
        }
        return false;
    }

    @Nullable
    public Style getStyleUnderMouse(double mouseX, double mouseY) {
        if (!this.m_93818_()) {
            return null;
        }
        double x = mouseX - 2.0;
        double y = (double)this.minecraft.m_91268_().m_85446_() - mouseY - 40.0;
        x = Mth.m_14107_((double)(x / this.m_93815_()));
        y = Mth.m_14107_((double)(y / (this.m_93815_() * ((Double)this.minecraft.f_91066_.m_232101_().m_231551_() + 1.0))));
        if (x < 0.0 || y < 0.0) {
            return null;
        }
        int i = Math.min(this.m_93816_(), this.f_93761_.size());
        if (x <= (double)Mth.m_14107_((double)((double)this.m_93813_() / this.m_93815_()))) {
            Objects.requireNonNull(this.minecraft.f_91062_);
            if (y < (double)(9 * i + i)) {
                Objects.requireNonNull(this.minecraft.f_91062_);
                int j = (int)(y / 9.0 + (double)this.f_93763_);
                if (j >= 0 && j < this.f_93761_.size()) {
                    InGameDisplayableMessage message = this.findMessageForTrimmedMessage((GuiMessage.Line)this.f_93761_.get(j));
                    if (message == null) {
                        return null;
                    }
                    return this.minecraft.f_91062_.m_92865_().m_92386_((FormattedText)message.getBuiltMessage(), (int)x);
                }
            }
        }
        return null;
    }

    @Nullable
    public Message getMessageUnderMouse(double mouseX, double mouseY) {
        if (!this.m_93818_()) {
            return null;
        }
        double x = mouseX - 2.0;
        double y = (double)this.minecraft.m_91268_().m_85446_() - mouseY - 40.0;
        x = Mth.m_14107_((double)(x / this.m_93815_()));
        y = Mth.m_14107_((double)(y / (this.m_93815_() * ((Double)this.minecraft.f_91066_.m_232101_().m_231551_() + 1.0))));
        if (x < 0.0 || y < 0.0) {
            return null;
        }
        int i = Math.min(this.m_93816_(), this.f_93761_.size());
        if (x <= (double)Mth.m_14107_((double)((double)this.m_93813_() / this.m_93815_()))) {
            Objects.requireNonNull(this.minecraft.f_91062_);
            if (y < (double)(9 * i + i)) {
                Objects.requireNonNull(this.minecraft.f_91062_);
                int j = (int)(y / 9.0 + (double)this.f_93763_);
                if (j >= 0 && j < this.f_93761_.size()) {
                    InGameDisplayableMessage message = this.findMessageForTrimmedMessage((GuiMessage.Line)this.f_93761_.get(j));
                    return message == null ? null : message.getMessage();
                }
            }
        }
        return null;
    }

    private boolean handleClickedMessage(@Nullable InGameDisplayableMessage clickedMessage, double x) {
        if (clickedMessage == null) {
            return false;
        }
        Message message = clickedMessage.getMessage();
        if (message.sender == null) {
            return false;
        }
        if (message.sender == MineTogetherChat.getOurProfile()) {
            return false;
        }
        Style style = this.minecraft.f_91062_.m_92865_().m_92386_((FormattedText)clickedMessage.getBuiltMessage(), (int)x);
        if (style == null) {
            return false;
        }
        ClickEvent event = style.m_131182_();
        if (event == null) {
            return false;
        }
        if (!event.m_130623_().equals("CE:CLICK_NAME")) {
            return false;
        }
        this.clickedMessage = message;
        return true;
    }

    @Nullable
    private InGameDisplayableMessage findMessageForTrimmedMessage(GuiMessage.Line trimmedMessage) {
        for (InGameDisplayableMessage processedMessage : this.processedMessages) {
            if (!processedMessage.getTrimmedLines().contains(trimmedMessage)) continue;
            return processedMessage;
        }
        return null;
    }

    @Nullable
    public Message getClickedMessage() {
        return this.clickedMessage;
    }

    public void clearClickedMessage() {
        this.clickedMessage = null;
    }

    private class InGameDisplayableMessage
    extends DisplayableMessage<GuiMessage.Line> {
        private InGameDisplayableMessage(Message message) {
            super(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onModified() {
            List<InGameDisplayableMessage> list = MTChatComponent.this.changedMessages;
            synchronized (list) {
                MTChatComponent.this.changedMessages.add(this);
            }
        }

        @Override
        protected boolean isForward() {
            return false;
        }

        @Override
        protected GuiMessage.Line createMessage(int addTime, FormattedCharSequence message) {
            return new GuiMessage.Line(addTime, message, null, true);
        }

        @Override
        protected int getMessageIndex(GuiMessage.Line message) {
            return MTChatComponent.this.f_93761_.indexOf(message);
        }

        @Override
        protected void clearMessages() {
            MTChatComponent.this.f_93761_.removeAll(this.getTrimmedLines());
        }

        @Override
        protected void addMessage(int index, GuiMessage.Line message) {
            MTChatComponent.this.f_93761_.add(index, message);
        }

        @Override
        protected double getChatWidth() {
            return (double)MTChatComponent.this.m_93813_() / MTChatComponent.this.m_93815_();
        }
    }

    private class LocalMessage
    extends InGameDisplayableMessage {
        private final Component message;
        private final MessageSignature signature;
        @Nullable
        private GuiMessage.Line line;

        private LocalMessage(Component message, MessageSignature signature) {
            super(new Message(Instant.now(), MineTogetherChat.getOurProfile(), MessageComponent.of(), MessageComponent.of()));
            this.message = message;
            this.signature = signature;
        }

        @Override
        protected GuiMessage.Line createMessage(int addTime, FormattedCharSequence formattedCharSequence) {
            this.line = new GuiMessage.Line(addTime, this.message.m_7532_(), null, true);
            return this.line;
        }
    }
}

