/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.lib.chat.ChatAuth;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.session.MineTogetherSession;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;

public class ChatAuthImpl
implements ChatAuth {
    private final UUID uuid;
    private final String uuidHash;

    public ChatAuthImpl(Minecraft mc) {
        this.uuid = UUIDUtil.m_235875_((GameProfile)mc.m_91094_().m_92548_());
        this.uuidHash = Hashing.sha256().hashString((CharSequence)this.uuid.toString(), StandardCharsets.UTF_8).toString().toUpperCase(Locale.ROOT);
    }

    @Override
    public String getSignature() {
        return MineTogether.FINGERPRINT;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getHash() {
        return this.uuidHash;
    }

    @Override
    public void resetSessionToken() {
        MineTogetherSession.getDefault().forceResetToken();
    }

    @Override
    public CompletableFuture<JWebToken> getSessionTokenAsync() {
        return MineTogetherSession.getDefault().getTokenAsync();
    }
}

