/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.Registries;
import com.gizmo.luggage.client.EnderLuggageRenderer;
import com.gizmo.luggage.client.LuggageModel;
import com.gizmo.luggage.client.LuggageRenderer;
import com.gizmo.luggage.client.LuggageTooltipComponent;
import com.gizmo.luggage.entity.AbstractLuggage;
import com.gizmo.luggage.item.LuggageItem;
import com.gizmo.luggage.network.CallLuggagePetsPacket;
import com.gizmo.luggage.network.LuggageNetworkHandler;
import com.gizmo.luggage.network.SitNearbyLuggagesPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="luggage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static final ModelLayerLocation LUGGAGE = new ModelLayerLocation(new ResourceLocation("luggage", "luggage"), "main");
    private static KeyMapping callKey;
    private static KeyMapping waitKey;

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LUGGAGE, LuggageModel::create);
    }

    @SubscribeEvent
    public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Registries.EntityRegistry.LUGGAGE.get(), LuggageRenderer::new);
        event.registerEntityRenderer((EntityType)Registries.EntityRegistry.ENDER_LUGGAGE.get(), EnderLuggageRenderer::new);
    }

    @SubscribeEvent
    public static void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(LuggageItem.Tooltip.class, LuggageTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        callKey = new KeyMapping("keybind.luggage.call", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 96, "key.categories.misc");
        waitKey = new KeyMapping("keybind.luggage.wait", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 96, "key.categories.misc");
        event.register(ClientEvents.getCallKey());
        event.register(ClientEvents.getWaitKey());
    }

    public static KeyMapping getCallKey() {
        return callKey;
    }

    public static KeyMapping getWaitKey() {
        return waitKey;
    }

    @Mod.EventBusSubscriber(modid="luggage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void commandTheCreatures(InputEvent.Key event) {
            if (event.getAction() == 1 && Minecraft.m_91087_().f_91074_ != null) {
                float pitch = Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 0.1f + 0.9f;
                if (event.getKey() == ClientEvents.getCallKey().getKey().m_84873_() && ClientEvents.getCallKey().m_90859_()) {
                    Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)Registries.SoundRegistry.WHISTLE_CALL.get(), 1.0f, pitch);
                    LuggageNetworkHandler.CHANNEL.sendToServer((Object)new CallLuggagePetsPacket(Minecraft.m_91087_().f_91074_.m_19879_()));
                } else if (event.getKey() == ClientEvents.getWaitKey().getKey().m_84873_() && ClientEvents.getWaitKey().m_90859_()) {
                    Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)Registries.SoundRegistry.WHISTLE_WAIT.get(), 0.85f, pitch);
                    LuggageNetworkHandler.CHANNEL.sendToServer((Object)new SitNearbyLuggagesPacket(Minecraft.m_91087_().f_91074_.m_19879_()));
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void attackThroughLuggage(InputEvent.InteractionKeyMappingTriggered event) {
            EntityHitResult result;
            HitResult hitResult;
            if (event.isAttack() && (hitResult = Minecraft.m_91087_().f_91077_) instanceof EntityHitResult && (result = (EntityHitResult)hitResult).m_82443_() instanceof AbstractLuggage) {
                event.setCanceled(true);
                event.setSwingHand(true);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                Vec3 vec3 = player.m_20299_(1.0f);
                Vec3 vec31 = player.m_20252_(1.0f);
                double d0 = (double)Minecraft.m_91087_().f_91072_.m_105286_() + 1.5;
                double d1 = Minecraft.m_91087_().f_91077_.m_82450_().m_82557_(vec3) + 8.0;
                Vec3 vec32 = vec3.m_82520_(vec31.m_7096_() * d0, vec31.m_7098_() * d0, vec31.m_7094_() * d0);
                AABB aabb = player.m_20191_().m_82369_(vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
                EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, entity -> !entity.m_5833_() && entity.m_6087_() && !(entity instanceof AbstractLuggage), (double)d1);
                if (entityhitresult != null) {
                    Minecraft.m_91087_().f_91072_.m_105223_((Player)player, entityhitresult.m_82443_());
                }
            }
        }
    }
}

