/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CardRender {
    public Direction direction;
    public int cardSlot;
    public float r;
    public float g;
    public float b;
    public BlockPos startBlock;
    public BlockPos endBlock;
    public float diffX;
    public float diffY;
    public float diffZ;
    public Vector3f startLaser;
    public Vector3f endLaser;
    public float[] floatcolors;

    public CardRender(Direction direction, int cardSlot, ItemStack card, BlockPos start, Level level, boolean enabled) {
        boolean reverse;
        this.direction = direction;
        this.cardSlot = cardSlot;
        this.startBlock = start;
        this.endBlock = this.startBlock.m_121945_(direction);
        BlockState targetState = level.m_8055_(this.endBlock);
        VoxelShape voxelShape = targetState.m_60808_((BlockGetter)level, this.endBlock);
        if (((BaseCard)card.m_41720_()).getCardType() == BaseCard.CardType.ITEM) {
            this.r = 0.0f;
            this.g = 1.0f;
            this.b = 0.0f;
        } else if (((BaseCard)card.m_41720_()).getCardType() == BaseCard.CardType.FLUID) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 1.0f;
        } else if (((BaseCard)card.m_41720_()).getCardType() == BaseCard.CardType.ENERGY) {
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 0.0f;
        } else if (((BaseCard)card.m_41720_()).getCardType() == BaseCard.CardType.REDSTONE) {
            this.r = 1.0f;
            this.g = 0.0f;
            this.b = 0.0f;
        }
        if (!enabled) {
            this.r /= 4.0f;
            this.g /= 4.0f;
            this.b /= 4.0f;
        }
        Vector3f offset = MiscTools.findOffset(direction, cardSlot, LaserNodeBERender.offsets);
        Vector3f shapeOffset = CardRender.shapeOffset(offset, voxelShape, this.startBlock, this.endBlock, direction, level, targetState);
        this.diffX = shapeOffset.m_122239_();
        this.diffY = shapeOffset.m_122260_();
        this.diffZ = shapeOffset.m_122269_();
        boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
        if (card.m_41720_() instanceof CardRedstone) {
            if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.INSERT) {
                reverse = !reverse;
            }
        } else if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
            reverse = !reverse;
        }
        this.floatcolors = card.m_41720_() instanceof CardRedstone || BaseCard.getNamedTransferMode(card) == BaseCard.TransferMode.SENSOR ? LaserNodeBERender.colors[BaseCard.getRedstoneChannel(card)].getColorComponents(new float[3]) : LaserNodeBERender.colors[BaseCard.getChannel(card)].getColorComponents(new float[3]);
        if (reverse) {
            this.endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
            this.startLaser = new Vector3f(this.diffX, this.diffY, this.diffZ);
        } else {
            this.startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
            this.endLaser = new Vector3f(this.diffX, this.diffY, this.diffZ);
        }
    }

    public static Vector3f shapeOffset(Vector3f offset, VoxelShape voxelShape, BlockPos startBlock, BlockPos endBlock, Direction direction, Level level, BlockState targetState) {
        float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
        float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
        float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
        if (!voxelShape.m_83281_()) {
            diffX = (float)((voxelShape.m_83215_().f_82291_ - voxelShape.m_83215_().f_82288_) * (double)diffX + voxelShape.m_83215_().f_82288_);
            diffY = (float)((voxelShape.m_83215_().f_82292_ - voxelShape.m_83215_().f_82289_) * (double)diffY + voxelShape.m_83215_().f_82289_);
            diffZ = (float)((voxelShape.m_83215_().f_82293_ - voxelShape.m_83215_().f_82290_) * (double)diffZ + voxelShape.m_83215_().f_82290_);
            if (direction.equals((Object)Direction.WEST)) {
                diffX = targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82479_ != 0.0 ? -1.0f - (float)(targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82479_ + 0.0625 - (voxelShape.m_83215_().f_82291_ - voxelShape.m_83215_().f_82288_)) : -1.0f + (float)voxelShape.m_83215_().f_82291_;
                offset.setX(offset.m_122239_() - 0.1875f);
            } else if (direction.equals((Object)Direction.EAST)) {
                diffX = targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82479_ != 0.0 ? 1.0f + (float)(targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82479_ - 0.0625 + (voxelShape.m_83215_().f_82291_ - voxelShape.m_83215_().f_82288_)) : 1.0f + (float)voxelShape.m_83215_().f_82288_;
                offset.setX(offset.m_122239_() + 0.1875f);
            } else if (direction.equals((Object)Direction.SOUTH)) {
                diffZ = targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82481_ != 0.0 ? 1.0f + (float)(targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82481_ - 0.0625 + (voxelShape.m_83215_().f_82293_ - voxelShape.m_83215_().f_82290_)) : 1.0f + (float)voxelShape.m_83215_().f_82290_;
                offset.setZ(offset.m_122269_() + 0.1875f);
            } else if (direction.equals((Object)Direction.NORTH)) {
                diffZ = targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82481_ != 0.0 ? (float)(targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82481_ + 0.0625 - (voxelShape.m_83215_().f_82293_ - voxelShape.m_83215_().f_82290_)) : -1.0f + (float)voxelShape.m_83215_().f_82293_;
                offset.setZ(offset.m_122269_() - 0.1875f);
            } else if (direction.equals((Object)Direction.UP)) {
                diffY = targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82480_ != 0.0 ? 1.0f + (float)(targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82480_ - 0.0625 + (voxelShape.m_83215_().f_82292_ - voxelShape.m_83215_().f_82289_)) : 1.0f + (float)voxelShape.m_83215_().f_82289_;
                offset.setY(offset.m_122260_() + 0.1875f);
            } else if (direction.equals((Object)Direction.DOWN)) {
                diffY = targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82480_ != 0.0 ? (float)(targetState.m_60824_((BlockGetter)level, (BlockPos)endBlock).f_82480_ + 0.0625 - (voxelShape.m_83215_().f_82292_ - voxelShape.m_83215_().f_82289_)) : -1.0f + (float)voxelShape.m_83215_().f_82292_;
                offset.setY(offset.m_122260_() - 0.1875f);
            }
        }
        return new Vector3f(diffX, diffY, diffZ);
    }
}

