/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.containers.customslot.CardItemSlot;
import com.direwolf20.laserio.common.containers.customslot.CardOverclockSlot;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.setup.Registration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CardItemContainer
extends AbstractContainerMenu {
    public static final int SLOTS = 2;
    public static final int FILTERSLOTS = 15;
    public CardItemHandler handler;
    public FilterBasicHandler filterHandler;
    public ItemStack cardItem;
    public Player playerEntity;
    protected IItemHandler playerInventory;
    public BlockPos sourceContainer = BlockPos.f_121853_;
    public byte direction = (byte)-1;

    protected CardItemContainer(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
    }

    public CardItemContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, extraData.m_130267_());
        this.direction = extraData.readByte();
    }

    public CardItemContainer(int windowId, Inventory playerInventory, Player player, ItemStack cardItem) {
        super((MenuType)Registration.CardItem_Container.get(), windowId);
        this.playerEntity = player;
        this.handler = BaseCard.getInventory(cardItem);
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.cardItem = cardItem;
        if (this.handler != null) {
            this.addSlotRange((IItemHandler)this.handler, 0, 80, 5, 1, 18);
            this.addSlotRange((IItemHandler)this.handler, 1, 153, 5, 1, 18);
            this.addSlotBox((IItemHandler)this.filterHandler, 0, 44, 25, 5, 18, 3, 18);
            this.toggleFilterSlots();
        }
        this.layoutPlayerInventorySlots(8, 84);
    }

    public CardItemContainer(int windowId, Inventory playerInventory, Player player, BlockPos sourcePos, ItemStack cardItem, byte direction) {
        this(windowId, playerInventory, player, cardItem);
        this.sourceContainer = sourcePos;
        this.direction = direction;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 2 && slotId < 17) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void getFilterHandler() {
        ItemStack filterStack = ((Slot)this.f_38839_.get(0)).m_7993_();
        this.filterHandler = filterStack.m_41720_() instanceof FilterBasic ? FilterBasic.getInventory(filterStack) : (filterStack.m_41720_() instanceof FilterCount ? FilterCount.getInventory(filterStack) : new FilterBasicHandler(15, ItemStack.f_41583_));
    }

    public void toggleFilterSlots() {
        this.getFilterHandler();
        this.updateFilterSlots((IItemHandler)this.filterHandler, 0, 44, 25, 5, 18, 3, 18);
    }

    public boolean m_6875_(Player playerIn) {
        if (this.sourceContainer.equals((Object)BlockPos.f_121853_)) {
            return playerIn.m_21205_().equals(this.cardItem) || playerIn.m_21206_().equals(this.cardItem);
        }
        return true;
    }

    public int getStackSize(int slot) {
        ItemStack filterStack = this.filterHandler.stack;
        if (slot >= 2 && slot < 17 && this.f_38839_.get(slot) instanceof FilterBasicSlot && filterStack.m_41720_() instanceof FilterCount) {
            return FilterCount.getSlotCount(filterStack, slot - 2);
        }
        return this.filterHandler.getStackInSlot(slot - 2).m_41613_();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (this.cardItem.m_41613_() > 1) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)this.cardItem)) {
                return ItemStack.f_41583_;
            }
            if (index < 2) {
                if (!this.m_38903_(stack, 17, 53, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else if (index < 2 || index >= 17) {
                ItemStack currentStack = slot.m_7993_().m_41777_();
                if (((Slot)this.f_38839_.get(0)).m_5857_(currentStack) || ((Slot)this.f_38839_.get(1)).m_5857_(currentStack)) {
                    if (!this.m_38903_(stack, 0, 2, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (((Slot)this.f_38839_.get(0)).m_7993_().m_41720_() instanceof BaseFilter) {
                    if (!(((Slot)this.f_38839_.get(0)).m_7993_().m_41720_() instanceof FilterCount)) {
                        currentStack.m_41764_(1);
                    }
                    for (int i = 2; i < 17; ++i) {
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((Slot)this.f_38839_.get(i)).m_7993_(), (ItemStack)currentStack)) continue;
                        return ItemStack.f_41583_;
                    }
                    if (!this.m_38903_(currentStack, 2, 17, false)) {
                        return ItemStack.f_41583_;
                    }
                }
                if (!playerIn.f_19853_.m_5776_()) {
                    BaseCard.setInventory(this.cardItem, this.handler);
                }
                if (this.filterHandler instanceof FilterCountHandler) {
                    ((FilterCountHandler)this.filterHandler).syncSlots();
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stack);
        }
        return itemstack;
    }

    protected void updateFilterSlots(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            for (int i = 0; i < horAmount; ++i) {
                if ((!(handler instanceof CardItemHandler) || index != 0) && handler instanceof FilterBasicHandler) {
                    this.f_38839_.set(index + 2, (Object)new FilterBasicSlot(handler, index, x, y, ((Slot)this.f_38839_.get(0)).m_7993_().m_41720_() instanceof FilterCount));
                    ((Slot)this.f_38839_.get((int)(index + 2))).f_40219_ = index + 2;
                }
                x += dx;
                ++index;
            }
            y += dy;
            x -= dx * horAmount;
        }
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof CardItemHandler && index == 0) {
                this.m_38897_((Slot)new CardItemSlot(handler, this, index, x, y));
            } else if (handler instanceof CardItemHandler && index == 1) {
                this.m_38897_((Slot)new CardOverclockSlot(handler, index, x, y));
            } else if (handler instanceof FilterBasicHandler) {
                this.m_38897_((Slot)new FilterBasicSlot(handler, index, x, y, ((Slot)this.f_38839_.get(0)).m_7993_().m_41720_() instanceof FilterCount));
            } else {
                this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public void m_6877_(Player playerIn) {
        Level world = playerIn.m_9236_();
        if (!world.f_46443_) {
            BlockEntity blockEntity;
            BaseCard.setInventory(this.cardItem, this.handler);
            if (!this.sourceContainer.equals((Object)BlockPos.f_121853_) && (blockEntity = world.m_7702_(this.sourceContainer)) instanceof LaserNodeBE) {
                ((LaserNodeBE)blockEntity).updateThisNode();
            }
        }
        super.m_6877_(playerIn);
    }
}

