/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.renderer;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.client.renderer.MyRenderType;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.util.CardRender;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RenderUtils {
    public static void render(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color, float scale) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.5f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public static void drawLasersTile(BlockEntity be, BlockPos startBlock, BlockPos endBlock, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        Level level = be.m_58904_();
        long gameTime = level.m_46467_();
        double v = (double)gameTime * 0.04;
        float diffX = (float)endBlock.m_123341_() + 0.5f - (float)startBlock.m_123341_();
        float diffY = (float)endBlock.m_123342_() + 0.5f - (float)startBlock.m_123342_();
        float diffZ = (float)endBlock.m_123343_() + 0.5f - (float)startBlock.m_123343_();
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
        VertexConsumer builder = bufferIn.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, 1.0f, 0.0f, 0.0f, 0.5f, 0.025f, v, v + (double)diffY * 1.5, be);
        matrixStackIn.m_85849_();
    }

    public static void drawLasersLast(BlockEntity be, BlockPos startBlock, BlockPos endBlock, PoseStack matrixStackIn) {
        Level level = be.m_58904_();
        long gameTime = level.m_46467_();
        double v = (double)gameTime * 0.04;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        float diffX = (float)endBlock.m_123341_() + 0.5f - (float)startBlock.m_123341_();
        float diffY = (float)endBlock.m_123342_() + 0.5f - (float)startBlock.m_123342_();
        float diffZ = (float)endBlock.m_123343_() + 0.5f - (float)startBlock.m_123343_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
        matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
        VertexConsumer builder = buffer.m_6299_(MyRenderType.CONNECTING_LASER);
        Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, 1.0f, 0.0f, 0.0f, 0.33f, 0.025f, v, v + (double)diffY * 1.5, be);
        matrixStackIn.m_85849_();
        buffer.m_109912_(MyRenderType.CONNECTING_LASER);
    }

    public static void drawLasersLast2(Queue<BaseLaserBE> beRenders, PoseStack matrixStackIn) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        VertexConsumer builder = buffer.m_6299_(MyRenderType.CONNECTING_LASER);
        while (beRenders.size() > 0) {
            BaseLaserBE be = beRenders.remove();
            Level level = be.m_58904_();
            long gameTime = level.m_46467_();
            double v = (double)gameTime * 0.04;
            BlockPos startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
            for (BlockPos target : be.getRenderedConnections()) {
                BlockPos endBlock = be.getWorldPos(target);
                float diffX = (float)endBlock.m_123341_() + 0.5f - (float)startBlock.m_123341_();
                float diffY = (float)endBlock.m_123342_() + 0.5f - (float)startBlock.m_123342_();
                float diffZ = (float)endBlock.m_123343_() + 0.5f - (float)startBlock.m_123343_();
                Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, 1.0f, 0.0f, 0.0f, 0.33f, 0.025f, v, v + (double)diffY * 1.5, be);
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.CONNECTING_LASER);
    }

    public static void drawConnectingLasersLast4(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn) {
        Matrix4f positionMatrix;
        BlockPos startBlock;
        double v;
        long gameTime;
        Level level;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float alpha = 1.0f;
        float thickness = 0.0175f;
        VertexConsumer builder = buffer.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.m_58904_();
            gameTime = level.m_46467_();
            v = (double)gameTime * 0.04;
            startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            positionMatrix = matrixStackIn.m_85850_().m_85861_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.r, cardRender.g, cardRender.b, alpha, thickness, v, v + (double)cardRender.diffY * 4.5, be);
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.m_6299_(MyRenderType.LASER_MAIN_CORE);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.m_58904_();
            gameTime = level.m_46467_();
            v = (double)gameTime * 0.04;
            startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            positionMatrix = matrixStackIn.m_85850_().m_85861_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.floatcolors[0], cardRender.floatcolors[1], cardRender.floatcolors[2], 1.0f, 0.0125f, v, v + (double)cardRender.diffY * 1.5, be);
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_CORE);
    }

    public static void drawConnectingLasersLast3(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn) {
        ItemStack card;
        int slot;
        IItemHandler h;
        Matrix4f positionMatrix;
        BlockPos startBlock;
        double v;
        long gameTime;
        Level level;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        float alpha = 1.0f;
        float thickness = 0.0175f;
        VertexConsumer builder = buffer.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.m_58904_();
            gameTime = level.m_46467_();
            v = (double)gameTime * 0.04;
            startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            positionMatrix = matrixStackIn.m_85850_().m_85861_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            for (Direction direction : Direction.values()) {
                h = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse((Object)new ItemStackHandler(0));
                for (slot = 0; slot < h.getSlots(); ++slot) {
                    Vector3f startLaser;
                    Vector3f endLaser;
                    boolean reverse;
                    card = h.getStackInSlot(slot);
                    if (!(card.m_41720_() instanceof BaseCard) || ((BaseCard)card.m_41720_()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1).equals((Object)LazyOptional.empty())) continue;
                    boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                    if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                        reverse = !reverse;
                    }
                    BlockPos endBlock = startBlock.m_121945_(direction);
                    Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                    float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
                    float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
                    float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
                    if (reverse) {
                        endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                        startLaser = new Vector3f(diffX, diffY, diffZ);
                    } else {
                        startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                        endLaser = new Vector3f(diffX, diffY, diffZ);
                    }
                    RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
                }
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.m_6299_(MyRenderType.LASER_MAIN_CORE);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.m_58904_();
            gameTime = level.m_46467_();
            v = (double)gameTime * 0.04;
            startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            positionMatrix = matrixStackIn.m_85850_().m_85861_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            for (Direction direction : Direction.values()) {
                h = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse((Object)new ItemStackHandler(0));
                for (slot = 0; slot < h.getSlots(); ++slot) {
                    Vector3f startLaser;
                    Vector3f endLaser;
                    boolean reverse;
                    card = h.getStackInSlot(slot);
                    if (!(card.m_41720_() instanceof BaseCard) || ((BaseCard)card.m_41720_()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1).equals((Object)LazyOptional.empty())) continue;
                    float[] floatcolors = LaserNodeBERender.colors[BaseCard.getChannel(card)].getColorComponents(new float[3]);
                    boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                    if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                        reverse = !reverse;
                    }
                    BlockPos endBlock = startBlock.m_121945_(direction);
                    Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                    float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
                    float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
                    float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
                    if (reverse) {
                        endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                        startLaser = new Vector3f(diffX, diffY, diffZ);
                    } else {
                        startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                        endLaser = new Vector3f(diffX, diffY, diffZ);
                    }
                    RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, floatcolors[0], floatcolors[1], floatcolors[2], 1.0f, 0.0125f, v, v + (double)diffY * 1.5, be);
                }
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_CORE);
    }

    public static void drawConnectingLasersLast2(LaserNodeBE be, PoseStack matrixStackIn) {
        ItemStack card;
        int slot;
        IItemHandler h;
        Level level = be.m_58904_();
        long gameTime = level.m_46467_();
        double v = (double)gameTime * 0.04;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        float alpha = 1.0f;
        float thickness = 0.0175f;
        BlockPos startBlock = be.m_58899_();
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
        matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
        VertexConsumer builder = buffer.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        for (Direction direction : Direction.values()) {
            h = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse((Object)new ItemStackHandler(0));
            for (slot = 0; slot < h.getSlots(); ++slot) {
                Vector3f startLaser;
                Vector3f endLaser;
                boolean reverse;
                card = h.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof BaseCard) || ((BaseCard)card.m_41720_()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1).equals((Object)LazyOptional.empty())) continue;
                boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                    reverse = !reverse;
                }
                BlockPos endBlock = startBlock.m_121945_(direction);
                Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
                float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
                float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
                if (reverse) {
                    endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                    startLaser = new Vector3f(diffX, diffY, diffZ);
                } else {
                    startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                    endLaser = new Vector3f(diffX, diffY, diffZ);
                }
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
            }
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.m_6299_(MyRenderType.LASER_MAIN_CORE);
        for (Direction direction : Direction.values()) {
            h = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse((Object)new ItemStackHandler(0));
            for (slot = 0; slot < h.getSlots(); ++slot) {
                Vector3f startLaser;
                Vector3f endLaser;
                boolean reverse;
                card = h.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof BaseCard) || ((BaseCard)card.m_41720_()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1).equals((Object)LazyOptional.empty())) continue;
                float[] floatcolors = LaserNodeBERender.colors[BaseCard.getChannel(card)].getColorComponents(new float[3]);
                boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                    reverse = !reverse;
                }
                BlockPos endBlock = startBlock.m_121945_(direction);
                Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
                float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
                float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
                if (reverse) {
                    endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                    startLaser = new Vector3f(diffX, diffY, diffZ);
                } else {
                    startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
                    endLaser = new Vector3f(diffX, diffY, diffZ);
                }
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, floatcolors[0], floatcolors[1], floatcolors[2], 1.0f, 0.0125f, v, v + (double)diffY * 1.5, be);
            }
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_CORE);
        matrixStackIn.m_85849_();
    }

    public static void drawConnectingLasersLast(BlockEntity be, BlockPos startBlock, BlockPos endBlock, PoseStack matrixStackIn, MultiBufferSource bufferIn, Vector3f offset, float r, float g, float b, float alpha, float thickness, float r2, float g2, float b2, float alpha2, float thickness2, boolean reverse) {
        Vector3f startLaser;
        Vector3f endLaser;
        Level level = be.m_58904_();
        long gameTime = level.m_46467_();
        double v = (double)gameTime * 0.04;
        float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
        float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
        float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
        matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
        if (reverse) {
            endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
            startLaser = new Vector3f(diffX, diffY, diffZ);
        } else {
            startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
            endLaser = new Vector3f(diffX, diffY, diffZ);
        }
        VertexConsumer builder = buffer.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
        buffer.m_109912_(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.m_6299_(MyRenderType.LASER_MAIN_CORE);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r2, g2, b2, alpha2, thickness2, v, v + (double)diffY * 1.5, be);
        buffer.m_109912_(MyRenderType.LASER_MAIN_CORE);
        matrixStackIn.m_85849_();
    }

    public static void drawConnectingLasers(BlockEntity be, BlockPos startBlock, BlockPos endBlock, PoseStack matrixStackIn, MultiBufferSource bufferIn, Vector3f offset, float r, float g, float b, float alpha, float thickness, float r2, float g2, float b2, float alpha2, float thickness2, boolean reverse) {
        Vector3f startLaser;
        Vector3f endLaser;
        Level level = be.m_58904_();
        long gameTime = level.m_46467_();
        double v = (double)gameTime * 0.04;
        float diffX = (float)endBlock.m_123341_() + offset.m_122239_() - (float)startBlock.m_123341_();
        float diffY = (float)endBlock.m_123342_() + offset.m_122260_() - (float)startBlock.m_123342_();
        float diffZ = (float)endBlock.m_123343_() + offset.m_122269_() - (float)startBlock.m_123343_();
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_85861_();
        if (reverse) {
            endLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
            startLaser = new Vector3f(diffX, diffY, diffZ);
        } else {
            startLaser = new Vector3f(offset.m_122239_(), offset.m_122260_(), offset.m_122269_());
            endLaser = new Vector3f(diffX, diffY, diffZ);
        }
        VertexConsumer builder = bufferIn.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
        builder = bufferIn.m_6299_(MyRenderType.LASER_MAIN_CORE);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r2, g2, b2, alpha2, thickness2, v, v + (double)diffY * 1.5, be);
        matrixStackIn.m_85849_();
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockEntity be) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vector3f P = new Vector3f((float)player.m_20185_() - (float)be.m_58899_().m_123341_(), (float)player.m_20188_() - (float)be.m_58899_().m_123342_(), (float)player.m_20189_() - (float)be.m_58899_().m_123343_());
        Vector3f PS = from.m_122281_();
        PS.m_122267_(P);
        Vector3f SE = to.m_122281_();
        SE.m_122267_(from);
        Vector3f adjustedVec = PS.m_122281_();
        adjustedVec.m_122279_(SE);
        adjustedVec.m_122278_();
        return adjustedVec;
    }

    public static void drawLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, double v1, double v2, BlockEntity be) {
        Vector3f adjustedVec = RenderUtils.adjustBeamToEyes(from, to, be);
        adjustedVec.m_122261_(thickness);
        Vector3f p1 = from.m_122281_();
        p1.m_122253_(adjustedVec);
        Vector3f p2 = from.m_122281_();
        p2.m_122267_(adjustedVec);
        Vector3f p3 = to.m_122281_();
        p3.m_122253_(adjustedVec);
        Vector3f p4 = to.m_122281_();
        p4.m_122267_(adjustedVec);
        builder.m_85982_(positionMatrix, p1.m_122239_(), p1.m_122260_(), p1.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(1.0f, (float)v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(positionMatrix, p3.m_122239_(), p3.m_122260_(), p3.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(1.0f, (float)v2).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(positionMatrix, p4.m_122239_(), p4.m_122260_(), p4.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(0.0f, (float)v2).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(positionMatrix, p2.m_122239_(), p2.m_122260_(), p2.m_122269_()).m_85950_(r, g, b, alpha).m_7421_(0.0f, (float)v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
    }
}

