/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ItemStack> create(StackHelper stackHelper) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<String> itemNameSet = new HashSet<String>();
        for (CreativeModeTab itemGroup : CreativeModeTab.f_40748_) {
            if (itemGroup == CreativeModeTab.f_40760_ || itemGroup == CreativeModeTab.f_40761_) continue;
            NonNullList creativeTabItemStacks = NonNullList.m_122779_();
            try {
                itemGroup.m_6151_(creativeTabItemStacks);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting items.Some items from this group will be missing from the ingredient list. {}", (Object)itemGroup, (Object)e);
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.m_41619_()) {
                    LOGGER.error("Found an empty itemStack from creative tab: {}", (Object)itemGroup);
                    continue;
                }
                ItemStackListFactory.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
        }
        return itemList;
    }

    private static void addItemStack(StackHelper stackHelper, ItemStack stack, List<ItemStack> itemList, Set<String> itemNameSet) {
        String itemKey;
        if (stack.m_41720_() == Items.f_42680_) {
            return;
        }
        try {
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return;
        }
        if (!itemNameSet.contains(itemKey)) {
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }
}

