/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt.network.serverbound;

import me.tepis.integratednbt.NBTExtractorBE;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateServerMessageBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class NBTExtractorUpdateOutputModeMessage
extends NBTExtractorUpdateServerMessageBase {
    private NBTExtractorOutputMode outputMode;

    private NBTExtractorUpdateOutputModeMessage() {
    }

    public NBTExtractorUpdateOutputModeMessage(BlockPos blockPos, NBTExtractorOutputMode outputMode) {
        super(blockPos);
        this.outputMode = outputMode;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.outputMode = NBTExtractorOutputMode.values()[buf.readByte()];
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.outputMode.ordinal());
    }

    public static class NBTExtractorUpdateOutputModeMessageHandler
    extends NBTExtractorUpdateServerMessageBase.NBTExtractorUpdateServerMessageHandlerBase<NBTExtractorUpdateOutputModeMessage> {
        @Override
        public void updateTileEntity(NBTExtractorUpdateOutputModeMessage message, NBTExtractorBE nbtExtractorTileEntity) {
            nbtExtractorTileEntity.setOutputMode(message.outputMode);
        }

        @Override
        protected Class<NBTExtractorUpdateOutputModeMessage> getMessageClass() {
            return NBTExtractorUpdateOutputModeMessage.class;
        }

        @Override
        protected NBTExtractorUpdateOutputModeMessage createEmpty() {
            return new NBTExtractorUpdateOutputModeMessage();
        }
    }
}

