/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.tepis.integratednbt.ExtendedContainerScreen;
import me.tepis.integratednbt.FontHelper;
import me.tepis.integratednbt.NBTExtractorScreen;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import me.tepis.integratednbt.Wrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;

public abstract class NBTTreeViewer {
    private static final long SMOOTH_SCROLLING_TRANSITION_TIME_MS = 75L;
    private static final double SCROLL_SPEED = 30.0;
    private static final int LINE_SPACE = 1;
    private static final int EXPAND_BUTTON_RIGHT_MARGIN = 3;
    private static final int INDENTATION = 10;
    private static final int HIGHLIGHT_COLOR = 0x505050;
    private static final int SELECTED_COLOR = 5269584;
    private static final int LABEL_COLOR = 0xFFFF55;
    private static final int EXPAND_COLOR = 0xFFBB11;
    private static final int NUMBER_COLOR = 0x66FFFF;
    private static final int STRING_COLOR = 0x55FF55;
    private static final int COMPLEX_COLOR = 0xAAAAAA;
    private static final int EMPTY_COLOR = 0x777777;
    private static final int SCREEN_BACKGROUND_COLOR = 0x303030;
    private static final int SCROLL_BAR_COLOR = 0xCCCCCC;
    private static final int SCROLL_BAR_PADDING = 2;
    private static final int SCROLL_BAR_WIDTH = 3;
    private static final int EXPAND_BUTTON_SIZE = 7;
    private static final TexturePart PLUS_BUTTON = NBTExtractorScreen.GUI_TEXTURE.createPart(48, 0, 7, 7);
    private static final TexturePart PLUS_BUTTON_HOVER = NBTExtractorScreen.GUI_TEXTURE.createPart(48, 9, 7, 7);
    private static final TexturePart MINUS_BUTTON = NBTExtractorScreen.GUI_TEXTURE.createPart(57, 0, 7, 7);
    private static final TexturePart MINUS_BUTTON_HOVER = NBTExtractorScreen.GUI_TEXTURE.createPart(57, 9, 7, 7);
    private static final TexturePart PURE_COLOR = new Texture("integratednbt", "textures/gui/1x1.png").createPart(0, 0, 1, 1);
    private final Set<NBTPath> expandedPaths;
    private final Wrapper<Integer> scrollTop;
    private final Font fontRenderer;
    private ExtendedContainerScreen<?> gui;
    private int left;
    private int top;
    private int width;
    private int height;
    private double renderScroll;
    private long renderScrollTransitionStartTime;
    private double renderScrollTransitionStartLocation;
    private int maxScroll;
    private int currentY;
    private int currentX;
    private NBTPath currentPath;
    private NBTPath hoveringPath;
    private Tag hoveringNBTNode;
    private NBTPath selecting;
    private int mouseX;
    private int mouseY;
    private NBTPath hoveringExpandableButton;

    public NBTTreeViewer(ExtendedContainerScreen<?> gui, Set<NBTPath> expandedPaths, Wrapper<Integer> scrollTop) {
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.maxScroll = 0;
        this.gui = gui;
        this.expandedPaths = expandedPaths;
        this.scrollTop = scrollTop;
        this.renderScroll = scrollTop.get().intValue();
    }

    public void updateBounds(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public void mouseScrolled(double dWheel) {
        int newValue = (int)((double)this.scrollTop.get().intValue() - dWheel * 30.0);
        if (newValue < 0) {
            newValue = 0;
        } else if (newValue > this.maxScroll) {
            newValue = this.maxScroll;
        }
        if (this.scrollTop.get() != newValue) {
            this.scrollTop.set(newValue);
            this.startScrollTransition();
        }
    }

    private void startScrollTransition() {
        this.renderScrollTransitionStartLocation = this.renderScroll;
        this.renderScrollTransitionStartTime = System.currentTimeMillis();
    }

    private boolean renderKVPair(PoseStack matrixStack, String label, String value, int valueColor) {
        boolean isThreeSideInBounds;
        if (label.isEmpty()) {
            return false;
        }
        boolean isSelected = this.getSelectedPath().equals(this.currentPath);
        boolean isHovering = false;
        Objects.requireNonNull(this.fontRenderer);
        int bottomBoundary = this.currentY + 9;
        boolean bl = isThreeSideInBounds = this.mouseX >= 0 && this.mouseX < this.width && (double)this.mouseY >= this.renderScroll && (double)this.mouseY < this.renderScroll + (double)this.height && this.mouseY >= this.currentY && this.mouseY < bottomBoundary + 1 && this.mouseX >= this.currentX;
        if (isThreeSideInBounds || isSelected) {
            int rightBoundary = this.currentX + this.fontRenderer.m_92895_(label + (String)(value.isEmpty() ? "" : ": " + value));
            if (isSelected || this.mouseX < rightBoundary) {
                if (isThreeSideInBounds && this.mouseX < rightBoundary) {
                    isHovering = true;
                }
                PURE_COLOR.renderToScaled(this.gui, matrixStack, this.currentX - 1, this.currentY - 1, rightBoundary - this.currentX + 1, bottomBoundary - this.currentY + 1, isSelected ? 5269584 : 0x505050);
            }
        }
        if (value.isEmpty()) {
            this.fontRenderer.m_92883_(matrixStack, label, (float)this.currentX, (float)this.currentY, 0xFFFF55);
        } else {
            int valueX = this.fontRenderer.m_92883_(matrixStack, label + ": ", (float)this.currentX, (float)this.currentY, 0xFFFF55);
            this.fontRenderer.m_92883_(matrixStack, value, (float)valueX, (float)this.currentY, valueColor);
        }
        return isHovering;
    }

    private void renderExpandableButton(PoseStack matrixStack, boolean expanded) {
        TexturePart part;
        boolean hovering;
        boolean bl = hovering = this.mouseX >= this.currentX && this.mouseX < this.currentX + 7 && this.mouseY >= this.currentY && this.mouseY < this.currentY + PLUS_BUTTON.getHeight();
        TexturePart texturePart = expanded ? (hovering ? MINUS_BUTTON_HOVER : MINUS_BUTTON) : (part = hovering ? PLUS_BUTTON_HOVER : PLUS_BUTTON);
        if (hovering) {
            this.hoveringExpandableButton = this.currentPath.copy();
        }
        part.renderTo((GuiComponent)this.gui, matrixStack, this.currentX, this.currentY, 0xFFBB11);
        this.currentX += 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(PoseStack matrixStack, Tag nbt, int absMouseX, int absMouseY) {
        this.hoveringPath = null;
        this.hoveringNBTNode = null;
        this.hoveringExpandableButton = null;
        this.currentPath = new NBTPath();
        this.currentY = 4;
        this.updateScroll();
        this.mouseX = absMouseX - this.left;
        this.mouseY = (int)((double)(absMouseY - this.top) + this.renderScroll);
        matrixStack.m_85836_();
        try {
            matrixStack.m_85837_((double)this.left, (double)this.top - this.renderScroll, 0.0);
            if (nbt == null) {
                this.fontRenderer.m_92883_(matrixStack, I18n.m_118938_((String)"integratednbt:nbt_extractor.empty", (Object[])new Object[0]), 4.0f, (float)this.currentY, 0x777777);
            } else {
                this.renderNode(matrixStack, I18n.m_118938_((String)"integratednbt:nbt_extractor.root", (Object[])new Object[0]), nbt);
            }
            int totalHeight = this.currentY + 4;
            matrixStack.m_85837_(0.0, this.renderScroll, 0.0);
            this.maxScroll = Math.max(totalHeight - this.height, 0);
            if (this.scrollTop.get() > this.maxScroll) {
                this.scrollTop.set(this.maxScroll);
                this.startScrollTransition();
            }
            if (this.maxScroll != 0) {
                PURE_COLOR.renderToScaled(this.gui, matrixStack, this.width - 4 - 3, -1, 9, this.height, 0x303030);
                PURE_COLOR.renderToScaled(this.gui, matrixStack, this.width - 2 - 3, 2 + (int)(this.renderScroll / (double)totalHeight * (double)(this.height - 4)), 3, (int)Math.ceil((double)this.height / (double)totalHeight * (double)(this.height - 4)), 0xCCCCCC);
            }
            if (this.hoveringPath != null) {
                IValueType<? extends IValue> hoveringValueType = NBTValueConverter.mapNBTToValueType(this.hoveringNBTNode);
                ArrayList<String> list = new ArrayList<String>(5);
                list.add(this.hoveringPath.getDisplayText());
                list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.nbt_type", (Object[])new Object[]{TagTypes.m_129397_((int)this.hoveringNBTNode.m_7060_()).m_5986_()}));
                list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.converted_type", (Object[])new Object[]{hoveringValueType.getDisplayColorFormat() + I18n.m_118938_((String)hoveringValueType.getTranslationKey(), (Object[])new Object[0])}));
                list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.default_value", (Object[])new Object[]{NBTValueConverter.getDefaultValueDisplayText(this.hoveringNBTNode.m_7060_())}));
                if (Objects.equals(this.getSelectedPath(), this.hoveringPath)) {
                    list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.selected", (Object[])new Object[0]));
                } else if (Objects.equals(this.selecting, this.hoveringPath)) {
                    list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.selecting", (Object[])new Object[0]));
                } else {
                    list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.left_click", (Object[])new Object[0]));
                }
                if (NBTTreeViewer.isNodeExpandable(this.hoveringNBTNode)) {
                    if (this.expandedPaths.contains(this.hoveringPath)) {
                        list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.right_click_collapse", (Object[])new Object[0]));
                    } else {
                        list.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.tooltip.right_click_expand", (Object[])new Object[0]));
                    }
                }
                this.gui.m_96617_(matrixStack, FontHelper.wrap(list.stream().map(s -> Component.m_237113_((String)s)).collect(Collectors.toList()), 250), this.mouseX, (int)((double)this.mouseY - this.renderScroll));
            }
        }
        finally {
            matrixStack.m_85849_();
        }
    }

    private void updateScroll() {
        long transitionTime = System.currentTimeMillis() - this.renderScrollTransitionStartTime;
        if (transitionTime > 75L) {
            this.renderScroll = this.scrollTop.get().intValue();
            return;
        }
        double ratio = (double)transitionTime / 75.0;
        this.renderScroll = this.renderScrollTransitionStartLocation + ((double)this.scrollTop.get().intValue() - this.renderScrollTransitionStartLocation) * ratio;
    }

    public void mouseClicked(int mouseButton) {
        if (mouseButton == 0) {
            if (this.hoveringExpandableButton != null) {
                this.toggleExpanded(this.hoveringExpandableButton);
            }
            if (this.hoveringPath != null) {
                this.selecting = this.hoveringPath;
                this.onUpdateSelectedPath(this.hoveringPath, this.hoveringNBTNode);
            }
        } else if (mouseButton == 1 && this.hoveringPath != null && NBTTreeViewer.isNodeExpandable(this.hoveringNBTNode)) {
            this.toggleExpanded(this.hoveringPath);
        }
    }

    private void toggleExpanded(NBTPath path) {
        if (this.expandedPaths.contains(path)) {
            this.expandedPaths.remove(path);
        } else {
            this.expandedPaths.add(path.copy());
        }
    }

    public abstract void onUpdateSelectedPath(NBTPath var1, Tag var2);

    private static boolean isNodeExpandable(Tag nbt) {
        byte nbtId = nbt.m_7060_();
        return nbtId == 9 || nbtId == 10;
    }

    private void renderEmpty(PoseStack matrixStack) {
        this.currentX = (this.currentPath.getDepth() + 1) * 10 + 4 + 3 + 7;
        this.fontRenderer.m_92883_(matrixStack, I18n.m_118938_((String)"integratednbt:nbt_extractor.empty", (Object[])new Object[0]), (float)this.currentX, (float)this.currentY, 0x777777);
        Objects.requireNonNull(this.fontRenderer);
        this.currentY += 9 + 1;
    }

    private void renderNode(PoseStack matrixStack, String label, Tag node) {
        this.currentX = this.currentPath.getDepth() * 10 + 4;
        boolean isExpandedIfExpandable = false;
        if (NBTTreeViewer.isNodeExpandable(node)) {
            isExpandedIfExpandable = this.expandedPaths.contains(this.currentPath);
        } else if (this.currentPath.getDepth() != 0) {
            this.currentX += 10;
        }
        if (switch (node.m_7060_()) {
            case 1 -> this.renderKVPair(matrixStack, label, String.valueOf(((ByteTag)node).m_7063_()), 0x66FFFF);
            case 2 -> this.renderKVPair(matrixStack, label, String.valueOf(((ShortTag)node).m_7053_()), 0x66FFFF);
            case 3 -> this.renderKVPair(matrixStack, label, String.valueOf(((IntTag)node).m_7047_()), 0x66FFFF);
            case 4 -> this.renderKVPair(matrixStack, label, String.valueOf(((LongTag)node).m_7046_()), 0x66FFFF);
            case 5 -> this.renderKVPair(matrixStack, label, String.valueOf(((FloatTag)node).m_7057_()), 0x66FFFF);
            case 6 -> this.renderKVPair(matrixStack, label, String.valueOf(((DoubleTag)node).m_7061_()), 0x66FFFF);
            case 7, 11, 12 -> this.renderKVPair(matrixStack, label, "[]", 0x66FFFF);
            case 8 -> this.renderKVPair(matrixStack, label, "\"" + node.m_7916_() + "\"", 0x55FF55);
            case 9, 10 -> {
                this.renderExpandableButton(matrixStack, isExpandedIfExpandable);
                yield this.renderKVPair(matrixStack, label, isExpandedIfExpandable ? "" : node.toString(), 0xAAAAAA);
            }
            default -> throw new RuntimeException("Unexpected NBT id:" + node.m_7060_());
        }) {
            this.hoveringPath = this.currentPath.copy();
            this.hoveringNBTNode = node;
        }
        Objects.requireNonNull(this.fontRenderer);
        this.currentY += 9 + 1;
        if (isExpandedIfExpandable) {
            switch (node.m_7060_()) {
                case 9: {
                    if (((ListTag)node).size() == 0) {
                        this.renderEmpty(matrixStack);
                        break;
                    }
                    int i = 0;
                    for (Tag item : (ListTag)node) {
                        this.currentPath.pushIndex(i);
                        this.renderNode(matrixStack, "#" + i, item);
                        this.currentPath.pop();
                        ++i;
                    }
                    break;
                }
                case 10: {
                    if (((CompoundTag)node).m_128440_() == 0) {
                        this.renderEmpty(matrixStack);
                        break;
                    }
                    CompoundTag compound = (CompoundTag)node;
                    for (String key : compound.m_128431_()) {
                        this.currentPath.pushKey(key);
                        this.renderNode(matrixStack, key, compound.m_128423_(key));
                        this.currentPath.pop();
                    }
                    break;
                }
            }
        }
    }

    public abstract NBTPath getSelectedPath();
}

