/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Objects;
import javax.annotation.Nonnull;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.IntegratedNBT;
import me.tepis.integratednbt.Integration;
import me.tepis.integratednbt.NBTExtractorBE;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.Wrapper;
import me.tepis.integratednbt.network.PacketHandler;
import me.tepis.integratednbt.network.clientbound.NBTExtractorUpdateClientMessage;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;

public class NBTExtractorContainer
extends AbstractContainerMenu {
    private static final int SRC_NBT = 0;
    private static final int VAR_OUT = 1;
    private static final int INVENTORY_START = 2;
    private static final int INVENTORY_END = 38;
    private Inventory playerInventory;
    private NBTExtractorBE nbtExtractorEntity;
    private NBTExtractorUpdateClientMessage.ErrorCode clientErrorCode = null;
    private Wrapper<Tag> clientNBT = null;
    private NBTPath clientPath = null;
    private NBTExtractorOutputMode clientOutputMode = null;
    private Component clientErrorMessage = null;
    private Boolean clientAutoRefresh = null;

    public NBTExtractorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, NBTExtractorContainer.getTileEntity(playerInventory, data));
    }

    public NBTExtractorContainer(int windowId, Inventory playerInventory, NBTExtractorBE nbtExtractorEntity) {
        super((MenuType)Additions.NBT_EXTRACTOR_CONTAINER.get(), windowId);
        int i;
        this.playerInventory = playerInventory;
        this.nbtExtractorEntity = nbtExtractorEntity;
        this.m_38897_(new SrcNBTSlot(nbtExtractorEntity, 0, 9, 6));
        this.m_38897_(new VarOutSlot(nbtExtractorEntity, 1, 153, 6));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new ResponsiveSlot((Container)playerInventory, j + i * 9 + 9, 9 + j * 18, 28 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new ResponsiveSlot((Container)playerInventory, i, 9 + i * 18, 86));
        }
    }

    private static NBTExtractorBE getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory);
        Objects.requireNonNull(data);
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof NBTExtractorBE) {
            return (NBTExtractorBE)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct: " + tileAtPos);
    }

    public NBTExtractorBE getNbtExtractorEntity() {
        return this.nbtExtractorEntity;
    }

    public void m_38946_() {
        super.m_38946_();
        Level world = this.nbtExtractorEntity.m_58904_();
        if (world != null && !world.f_46443_) {
            NBTExtractorOutputMode outputMode;
            NBTPath nbtPath;
            NBTExtractorUpdateClientMessage.ErrorCode errorCode;
            Wrapper<Tag> newNBT = this.clientNBT;
            MutableComponent errorMessage = null;
            if (!this.m_38853_(0).m_6657_()) {
                this.clientErrorCode = null;
                errorCode = null;
            } else {
                try {
                    Wrapper<Tag> frozenValue = this.nbtExtractorEntity.getFrozenValue();
                    if (frozenValue == null) {
                        IVariable<?> variable = this.nbtExtractorEntity.getSrcNBTVariable();
                        if (variable == null) {
                            errorCode = NBTExtractorUpdateClientMessage.ErrorCode.EVAL_ERROR;
                            errorMessage = this.nbtExtractorEntity.getFirstErrorMessage();
                        } else {
                            IValue value = variable.getValue();
                            if (value instanceof ValueTypeNbt.ValueNbt) {
                                newNBT = Wrapper.of(((ValueTypeNbt.ValueNbt)value).getRawValue().orElse(null));
                                errorCode = NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR;
                            } else {
                                errorCode = NBTExtractorUpdateClientMessage.ErrorCode.TYPE_ERROR;
                            }
                        }
                    } else {
                        errorCode = NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR;
                        newNBT = frozenValue;
                    }
                }
                catch (PartStateException | EvaluationException exception) {
                    exception.printStackTrace();
                    errorCode = NBTExtractorUpdateClientMessage.ErrorCode.EVAL_ERROR;
                    errorMessage = Component.m_237113_((String)exception.getMessage());
                }
                catch (Exception exception) {
                    errorCode = NBTExtractorUpdateClientMessage.ErrorCode.UNEXPECTED_ERROR;
                    IntegratedNBT.LOGGER.error("Unexpected error occurred while evaluating variable.", (Throwable)exception);
                }
            }
            NBTExtractorUpdateClientMessage message = new NBTExtractorUpdateClientMessage();
            if (!Objects.equals(this.clientNBT, newNBT)) {
                message.updateNBT(newNBT.get());
                this.clientNBT = newNBT;
            }
            if (this.clientErrorCode != errorCode) {
                message.updateErrorCode(errorCode);
                this.clientErrorCode = errorCode;
            }
            if (this.clientPath != (nbtPath = this.nbtExtractorEntity.getExtractionPath())) {
                message.updateExtractionPath(nbtPath);
                this.clientPath = nbtPath;
            }
            if (this.clientOutputMode != (outputMode = this.nbtExtractorEntity.getOutputMode())) {
                message.updateOutputMode(outputMode);
                this.clientOutputMode = outputMode;
            }
            if (!Objects.equals(errorMessage, this.clientErrorMessage)) {
                message.updateErrorMessage((Component)errorMessage);
                this.clientErrorMessage = errorMessage;
            }
            if (this.clientAutoRefresh == null || this.nbtExtractorEntity.isAutoRefresh() != this.clientAutoRefresh.booleanValue()) {
                message.updateAutoRefresh(this.nbtExtractorEntity.isAutoRefresh());
                this.clientAutoRefresh = this.nbtExtractorEntity.isAutoRefresh();
            }
            if (!message.isEmpty()) {
                ServerPlayer playerMP = (ServerPlayer)this.playerInventory.f_35978_;
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)message);
            }
            if (errorCode == NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR) {
                this.nbtExtractorEntity.updateLastEvaluatedNBT(newNBT.get());
            } else {
                this.nbtExtractorEntity.updateLastEvaluatedNBT(null);
            }
        }
    }

    public void setSlotOffset(int x, int y) {
        for (Slot slot : this.f_38839_) {
            ((ResponsiveSlot)slot).setOffset(x, y);
        }
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    @Nonnull
    public Slot getSrcNBTSlot() {
        return this.m_38853_(0);
    }

    @Nonnull
    public Slot getVarOutSlot() {
        return this.m_38853_(1);
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack leftOver = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack fromSlot = slot.m_7993_();
            leftOver = fromSlot.m_41777_();
            if (index == 0 || index == 1) {
                if (!this.m_38903_(fromSlot, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (Integration.isVariable(fromSlot)) {
                if (((Slot)this.f_38839_.get(0)).m_6657_()) {
                    if (((Slot)this.f_38839_.get(1)).m_6657_()) {
                        return ItemStack.f_41583_;
                    }
                    Slot varOutSlot = this.m_38853_(1);
                    varOutSlot.m_5852_(fromSlot.m_41620_(1));
                    varOutSlot.m_6654_();
                } else {
                    Slot srcNBTSlot = this.m_38853_(0);
                    srcNBTSlot.m_5852_(fromSlot.m_41620_(1));
                    srcNBTSlot.m_6654_();
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (fromSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (fromSlot.m_41613_() == leftOver.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, fromSlot);
        }
        return leftOver;
    }

    private static class SrcNBTSlot
    extends VariableSlot {
        public SrcNBTSlot(Container inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
        }
    }

    private static class VarOutSlot
    extends VariableSlot {
        public VarOutSlot(Container inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
        }
    }

    private static class ResponsiveSlot
    extends Slot {
        private int baseX;
        private int baseY;

        public ResponsiveSlot(Container inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
            this.baseX = baseX;
            this.baseY = baseY;
        }

        public void setOffset(int xPos, int yPos) {
            this.f_40220_ = this.baseX + xPos;
            this.f_40221_ = this.baseY + yPos;
        }
    }

    private static class VariableSlot
    extends ResponsiveSlot {
        public VariableSlot(Container inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
        }

        public boolean m_5857_(ItemStack stack) {
            return Integration.isVariable(stack);
        }

        public int m_5866_(ItemStack stack) {
            return 1;
        }
    }
}

