/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import net.minecraft.nbt.Tag;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariableInvalidateListener;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;

public class NBTExtractedVariable
extends VariableAdapter<IValue> {
    private IVariable<ValueTypeNbt.ValueNbt> sourceNBTVariable;
    private NBTPath extractionPath;
    private Tag cachedValue;
    private byte defaultNBTId;

    public NBTExtractedVariable(IVariable<ValueTypeNbt.ValueNbt> sourceNBTVariable, NBTPath extractionPath, byte defaultNBTId) {
        this.sourceNBTVariable = sourceNBTVariable;
        this.extractionPath = extractionPath;
        this.defaultNBTId = defaultNBTId;
    }

    public IValueType<IValue> getType() {
        try {
            this.ensureCachedValue();
            if (this.cachedValue == null) {
                return NBTValueConverter.getDefaultValue(this.defaultNBTId).getType();
            }
            return NBTValueConverter.mapNBTToValueType(this.cachedValue);
        }
        catch (EvaluationException ex) {
            return NBTValueConverter.getDefaultValue(this.defaultNBTId).getType();
        }
    }

    private void ensureCachedValue() throws EvaluationException {
        if (this.cachedValue == null) {
            this.sourceNBTVariable.addInvalidationListener((IVariableInvalidateListener)this);
            this.cachedValue = this.extractionPath.extract(((ValueTypeNbt.ValueNbt)this.sourceNBTVariable.getValue()).getRawValue().orElse(null));
        }
    }

    public IValue getValue() throws EvaluationException {
        this.ensureCachedValue();
        if (this.cachedValue == null) {
            return NBTValueConverter.getDefaultValue(this.defaultNBTId);
        }
        return NBTValueConverter.mapNBTToValue(this.cachedValue);
    }

    public void invalidate() {
        this.cachedValue = null;
        super.invalidate();
    }
}

