/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.network;

import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class PacketChannel {
    protected final ResourceLocation channelId;
    protected final Object2ByteOpenHashMap<Class<? extends AbstractPacket>> clzToId;
    protected final Class<? extends AbstractPacket>[] idToClz;

    @SafeVarargs
    public PacketChannel(ResourceLocation name, Class<? extends AbstractPacket> ... packetTypes) {
        this.channelId = name;
        this.clzToId = new Object2ByteOpenHashMap(packetTypes.length);
        for (int i = 0; i < packetTypes.length; ++i) {
            this.clzToId.put(packetTypes[i], (byte)i);
        }
        this.idToClz = packetTypes;
    }

    public abstract void sendToServer(AbstractPacket var1);

    public abstract void sendTo(AbstractPacket var1, ServerPlayer var2);

    public abstract void sendToAll(AbstractPacket var1);

    public abstract void sendToTracking(AbstractPacket var1, Entity var2);

    public abstract void sendToAround(AbstractPacket var1, ServerLevel var2, double var3, double var5, double var7, double var9);

    protected PacketPayload payload(AbstractPacket packet) {
        return new PacketPayload(packet);
    }

    protected PacketPayload readPacket(FriendlyByteBuf buffer) {
        AbstractPacket packet;
        byte id = buffer.readByte();
        Class<? extends AbstractPacket> clz = this.idToClz[id];
        try {
            packet = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            packet.readFrom(buffer);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create packet for " + this.channelId.toString() + " with id " + id, e);
        }
        return new PacketPayload(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getPlayer() {
        return iChunUtil.eC().getPlayer();
    }

    protected class PacketPayload {
        private final AbstractPacket packet;

        private PacketPayload(AbstractPacket packet) {
            this.packet = packet;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte((int)PacketChannel.this.clzToId.getByte(this.packet.getClass()));
            this.packet.writeTo(buffer);
        }

        public Optional<Runnable> process(@Nullable Player player) {
            return this.packet.process(player);
        }
    }
}

