/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MessageCountUpdate {
    private int x;
    private int y;
    private int z;
    private int slot;
    private int count;
    private boolean failed;

    public MessageCountUpdate(BlockPos pos, int slot, int count) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.slot = slot;
        this.count = count;
        this.failed = false;
    }

    private MessageCountUpdate(boolean failed) {
        this.failed = failed;
    }

    public static MessageCountUpdate decode(ByteBuf buf) {
        try {
            int x = buf.readInt();
            short y = buf.readShort();
            int z = buf.readInt();
            byte slot = buf.readByte();
            int count = buf.readInt();
            return new MessageCountUpdate(new BlockPos(x, (int)y, z), slot, count);
        }
        catch (IndexOutOfBoundsException e) {
            return new MessageCountUpdate(true);
        }
    }

    public static void encode(MessageCountUpdate msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.x);
        buf.writeShort(msg.y);
        buf.writeInt(msg.z);
        buf.writeByte(msg.slot);
        buf.writeInt(msg.count);
    }

    public static void handle(MessageCountUpdate msg, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MessageCountUpdate.lambda$handle$0(msg, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(MessageCountUpdate msg, NetworkEvent.Context ctx) {
        BlockPos pos;
        BlockEntity tileEntity;
        ClientLevel world;
        if (!msg.failed && (world = Minecraft.m_91087_().f_91073_) != null && (tileEntity = world.m_7702_(pos = new BlockPos(msg.x, msg.y, msg.z))) instanceof HerbJarTile) {
            ((HerbJarTile)tileEntity).clientUpdateCount(msg.slot, msg.count);
        }
        ctx.setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(MessageCountUpdate msg, Supplier ctx) {
        MessageCountUpdate.handleClient(msg, (NetworkEvent.Context)ctx.get());
    }
}

