/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.fluid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.fluid.PotionFluid;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionMixingRecipes {
    public static final List<Item> SUPPORTED_CONTAINERS = List.of(Items.f_42589_, Items.f_42736_, Items.f_42739_);
    public static List<FluidMixingRecipe> ALL;
    public static Map<Item, List<FluidMixingRecipe>> BY_ITEM;

    public static List<FluidMixingRecipe> createRecipes() {
        ArrayList<FluidMixingRecipe> mixingRecipes = new ArrayList<FluidMixingRecipe>();
        int recipeIndex = 0;
        ArrayList<Item> allowedSupportedContainers = new ArrayList<Item>();
        ArrayList<ItemStack> supportedContainerStacks = new ArrayList<ItemStack>();
        for (Item container : SUPPORTED_CONTAINERS) {
            ItemStack stack = new ItemStack((ItemLike)container);
            supportedContainerStacks.add(stack);
            if (!PotionBrewing.f_43497_.test(stack)) continue;
            allowedSupportedContainers.add(container);
        }
        for (Item container : allowedSupportedContainers) {
            PotionFluid.BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(container);
            for (PotionBrewing.Mix mix : PotionBrewing.f_43494_) {
                FluidStack fromFluid = PotionFluidHandler.getFluidFromPotion((Potion)mix.f_43532_.get(), bottleType, 1000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion((Potion)mix.f_43534_.get(), bottleType, 1000);
                if (mix.f_43533_.m_43908_().length == 0 || mix.f_43533_.m_43908_()[0] == null || mix.f_43533_.m_43908_()[0].m_41619_()) continue;
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, mix.f_43533_, fromFluid, toFluid));
            }
        }
        for (PotionBrewing.Mix mix : PotionBrewing.f_43495_) {
            Item to;
            Item from = (Item)mix.f_43532_.get();
            if (!allowedSupportedContainers.contains(from) || !allowedSupportedContainers.contains(to = (Item)mix.f_43534_.get())) continue;
            PotionFluid.BottleType fromBottleType = PotionFluidHandler.bottleTypeFromItem(from);
            PotionFluid.BottleType toBottleType = PotionFluidHandler.bottleTypeFromItem(to);
            Ingredient ingredient = mix.f_43533_;
            if (mix.f_43533_.m_43908_()[0] == null) continue;
            for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
                if (potion == Potions.f_43598_) continue;
                FluidStack fromFluid = PotionFluidHandler.getFluidFromPotion(potion, fromBottleType, 1000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion(potion, toBottleType, 1000);
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, ingredient, fromFluid, toFluid));
            }
        }
        recipeIndex = 0;
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            BrewingRecipe recipeImpl;
            ItemStack output;
            if (!(recipe instanceof BrewingRecipe) || !SUPPORTED_CONTAINERS.contains((output = (recipeImpl = (BrewingRecipe)recipe).getOutput()).m_41720_())) continue;
            Ingredient input = recipeImpl.getInput();
            Ingredient ingredient = recipeImpl.getIngredient();
            FluidStack outputFluid = null;
            for (ItemStack stack : supportedContainerStacks) {
                if (!input.test(stack)) continue;
                FluidStack inputFluid = PotionFluidHandler.getFluidFromPotionItem(stack);
                if (outputFluid == null) {
                    outputFluid = PotionFluidHandler.getFluidFromPotionItem(output);
                }
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_modded_" + recipeIndex++, ingredient, inputFluid, outputFluid));
            }
        }
        if (mixingRecipes.size() == 0) {
            mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, Ingredient.f_43901_, new FluidStack((Fluid)Fluids.f_76193_, 2000), new FluidStack((Fluid)Fluids.f_76193_, 2000)));
        }
        return mixingRecipes;
    }

    private static FluidMixingRecipe createRecipe(String id, Ingredient ingredient, FluidStack fromFluid, FluidStack toFluid) {
        NonNullList nonNullList = NonNullList.m_122780_((int)8, (Object)Ingredient.f_43901_);
        nonNullList.set(0, (Object)ingredient);
        nonNullList.set(4, (Object)ingredient);
        return new FluidMixingRecipe(new ResourceLocation(id), (NonNullList<Ingredient>)nonNullList, fromFluid, toFluid, FluidMixingRecipe.HeatCondition.HEATED);
    }

    public static Map<Item, List<FluidMixingRecipe>> sortRecipesByItem(List<FluidMixingRecipe> all) {
        HashMap<Item, List<FluidMixingRecipe>> byItem = new HashMap<Item, List<FluidMixingRecipe>>();
        HashSet<Item> processedItems = new HashSet<Item>();
        if (all != null) {
            for (FluidMixingRecipe recipe : all) {
                for (Ingredient ingredient : recipe.m_7527_()) {
                    for (ItemStack itemStack : ingredient.m_43908_()) {
                        Item item = itemStack.m_41720_();
                        if (!processedItems.add(item)) continue;
                        byItem.computeIfAbsent(item, i -> new ArrayList()).add(recipe);
                    }
                }
                processedItems.clear();
            }
        }
        return byItem;
    }
}

