/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.ArrayList;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class BookEntries {
    public ArrayList<BookChapter> chapterList;
    public int numberOfPages;

    public BookEntries(ArrayList<BookChapter> chapterList, int numberOfPages) {
        this.chapterList = chapterList;
        this.numberOfPages = numberOfPages;
    }

    public static CompoundTag saveToTag(BookEntries bookEntries) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("numberOfChapters", bookEntries.chapterList.size());
        for (int i = 0; i < bookEntries.chapterList.size(); ++i) {
            BookChapter bookChapter = bookEntries.chapterList.get(i);
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("name", bookChapter.name);
            int num = bookChapter.pages.size();
            compound.m_128405_("num", num);
            for (int k = 0; k < num; ++k) {
                BookPageEntry bookPageEntry = (BookPageEntry)bookChapter.pages.toArray()[k];
                CompoundTag compoundBoxes = new CompoundTag();
                compoundBoxes.m_128359_("location" + k, bookPageEntry.location);
                compoundBoxes.m_128405_("pageNum" + k, bookPageEntry.pageNum);
                compound.m_128365_("page" + k, (Tag)compoundBoxes);
            }
            tag.m_128365_("chapter" + i, (Tag)compound);
        }
        return tag;
    }

    public static BookEntries loadFromTag(CompoundTag tag) {
        int size = tag.m_128451_("numberOfChapters");
        int numOfPages = 0;
        ArrayList<BookChapter> list = new ArrayList<BookChapter>();
        for (int i = 0; i < size; ++i) {
            CompoundTag paragraph = tag.m_128469_("chapter" + i);
            String string = paragraph.m_128461_("name");
            int num = paragraph.m_128451_("num");
            numOfPages += num;
            ArrayList<BookPageEntry> pageEntryList = new ArrayList<BookPageEntry>();
            for (int k = 0; k < num; ++k) {
                CompoundTag pageEntries = paragraph.m_128469_("page" + k);
                String location = pageEntries.m_128461_("location" + k);
                int pageNum = pageEntries.m_128451_("pageNum" + k);
                BookPageEntry bookChapter = new BookPageEntry(location, pageNum);
                pageEntryList.add(bookChapter);
            }
            BookChapter bookChapter = new BookChapter(pageEntryList, string, numOfPages, numOfPages);
            list.add(bookChapter);
        }
        return new BookEntries(list, numOfPages);
    }
}

