/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.Map;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OwlModel<T extends OwlEntity>
extends ColorableAgeableListModel<T> {
    public final ModelPart owl;
    public final ModelPart body;
    public final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hexerei", "owl"), "main");
    public static final ModelLayerLocation POWER_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hexerei", "owl_power_layer"), "main");

    public OwlModel(ModelPart root) {
        this.owl = root.m_171324_("owl");
        this.body = this.owl.m_171324_("body");
        this.head = this.owl.m_171324_("head");
    }

    public static LayerDefinition createBodyLayerNone() {
        return OwlModel.createBodyLayer(CubeDeformation.f_171458_);
    }

    public static LayerDefinition createBodyLayerEnlarge() {
        return OwlModel.createBodyLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition owl = partdefinition.m_171599_("owl", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)1.2166f, (float)-0.3823f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition body = owl.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -2.0f, -2.5f, 7.0f, 4.0f, 6.0f, cube), PartPose.m_171419_((float)0.0f, (float)-0.9668f, (float)-0.6345f));
        PartDefinition chest_r1 = body.m_171599_("chest_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-3.0f, -3.25f, -1.75f, 6.0f, 7.0f, 5.0f, cube), PartPose.m_171423_((float)0.0f, (float)1.75f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid = owl.m_171599_("tailMid", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)2.2834f, (float)3.3823f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid_r1 = tailMid.m_171599_("tailMid_r1", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-1.0f, -2.0959f, 2.5885f, 2.0f, 0.0f, 7.0f, cube), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)-3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftTail = owl.m_171599_("leftTail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.75f, (float)2.7834f, (float)2.8823f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition leftTail_r1 = leftTail.m_171599_("leftTail_r1", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-0.0531f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-0.75f, (float)3.0f, (float)-2.5f, (float)-0.1688f, (float)0.008f, (float)-0.0444f));
        PartDefinition rightTail = owl.m_171599_("rightTail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.75f, (float)2.7834f, (float)2.8823f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition rightTail_r1 = rightTail.m_171599_("rightTail_r1", CubeListBuilder.m_171558_().m_171514_(27, 30).m_171488_(-1.9469f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)0.75f, (float)3.0f, (float)-2.5f, (float)-0.1688f, (float)-0.008f, (float)0.0444f));
        PartDefinition leftWingBase = owl.m_171599_("leftWingBase", CubeListBuilder.m_171558_().m_171514_(36, 8).m_171480_().m_171488_(-0.5f, -0.5f, -2.5f, 4.0f, 1.0f, 1.0f, cube).m_171555_(false).m_171514_(14, 30).m_171480_().m_171488_(-0.5f, 0.0f, -1.5f, 4.0f, 0.0f, 5.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-1.7166f, (float)-0.1177f, (float)0.0f, (float)0.0f, (float)1.4835f));
        PartDefinition leftWingCloseMiddle = leftWingBase.m_171599_("leftWingCloseMiddle", CubeListBuilder.m_171558_().m_171514_(36, 5).m_171480_().m_171488_(-0.25f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, cube).m_171555_(false).m_171514_(21, 5).m_171480_().m_171488_(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 6.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)0.0f, (float)-2.0f, (float)-0.0873f, (float)-0.5236f, (float)0.1745f));
        PartDefinition leftWingFarMiddle = leftWingCloseMiddle.m_171599_("leftWingFarMiddle", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171480_().m_171488_(-0.25f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, cube).m_171555_(false).m_171514_(23, 12).m_171480_().m_171488_(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 5.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.75f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)-1.0472f, (float)0.1745f));
        PartDefinition leftWingTip = leftWingFarMiddle.m_171599_("leftWingTip", CubeListBuilder.m_171558_().m_171514_(18, 12).m_171480_().m_171488_(-0.25f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, cube).m_171555_(false).m_171514_(21, 0).m_171480_().m_171488_(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 4.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightWingBase = owl.m_171599_("rightWingBase", CubeListBuilder.m_171558_().m_171514_(36, 8).m_171488_(-3.5f, -0.5f, -2.5f, 4.0f, 1.0f, 1.0f, cube).m_171514_(14, 30).m_171488_(-3.5f, 0.0f, -1.5f, 4.0f, 0.0f, 5.0f, cube), PartPose.m_171423_((float)-3.5f, (float)-1.7166f, (float)-0.1177f, (float)0.0f, (float)0.0f, (float)-1.4835f));
        PartDefinition rightWingCloseMiddle = rightWingBase.m_171599_("rightWingCloseMiddle", CubeListBuilder.m_171558_().m_171514_(36, 5).m_171488_(-3.75f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, cube).m_171514_(21, 5).m_171488_(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-3.5f, (float)0.0f, (float)-2.0f, (float)-0.0873f, (float)0.5236f, (float)-0.1745f));
        PartDefinition rightWingFarMiddle = rightWingCloseMiddle.m_171599_("rightWingFarMiddle", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-3.75f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, cube).m_171514_(23, 12).m_171488_(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 5.0f, cube), PartPose.m_171423_((float)-3.75f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)1.0472f, (float)-0.1745f));
        PartDefinition rightWingTip = rightWingFarMiddle.m_171599_("rightWingTip", CubeListBuilder.m_171558_().m_171514_(18, 12).m_171488_(-2.75f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, cube).m_171514_(21, 0).m_171488_(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 4.0f, cube), PartPose.m_171423_((float)-3.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition rightLeg = owl.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.0f, 0.0f, 0.25f, 1.0f, 2.0f, 1.0f, cube).m_171514_(12, 29).m_171488_(-1.5f, 2.0f, -0.75f, 2.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-1.0f, (float)3.567f, (float)-1.094f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = owl.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(12, 24).m_171488_(0.0f, 0.0f, 0.25f, 1.0f, 2.0f, 1.0f, cube).m_171514_(37, 15).m_171488_(-0.5f, 2.0f, -0.75f, 2.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)1.0f, (float)3.567f, (float)-1.094f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = owl.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 19).m_171488_(-3.0f, -3.5126f, -2.7186f, 6.0f, 5.0f, 5.0f, cube), PartPose.m_171423_((float)0.0f, (float)-3.9001f, (float)0.3282f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition beak_r1 = head.m_171599_("beak_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, -0.75f, 1.0f, 2.0f, 1.0f, cube), PartPose.m_171423_((float)0.0f, (float)-0.0126f, (float)-2.9686f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition rightBrow = head.m_171599_("rightBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.85f, (float)-3.2626f, (float)-2.8186f));
        PartDefinition rightBrow_r1 = rightBrow.m_171599_("rightBrow_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-1.2462f, -1.4566f, 0.0f, 3.0f, 2.0f, 0.0f, cube), PartPose.m_171423_((float)-1.15f, (float)1.0f, (float)-0.15f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightBrow_r2 = rightBrow.m_171599_("rightBrow_r2", CubeListBuilder.m_171558_().m_171514_(11, 32).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0451f, (float)0.0834f, (float)0.1725f));
        PartDefinition rightBrow_r3 = rightBrow.m_171599_("rightBrow_r3", CubeListBuilder.m_171558_().m_171514_(36, 20).m_171488_(-1.6f, -0.5f, -0.6f, 3.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)-2.2437f, (float)-0.5276f, (float)1.2532f, (float)0.3589f, (float)1.0414f, (float)0.6033f));
        PartDefinition rightBrow_r4 = rightBrow.m_171599_("rightBrow_r4", CubeListBuilder.m_171558_().m_171514_(11, 36).m_171488_(-2.1f, 0.0f, 0.4f, 4.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-2.2437f, (float)-0.7776f, (float)1.2532f, (float)0.3589f, (float)1.0414f, (float)0.6033f));
        PartDefinition leftBrow = head.m_171599_("leftBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.85f, (float)-3.2626f, (float)-2.8186f));
        PartDefinition leftBrow_r1 = leftBrow.m_171599_("leftBrow_r1", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-1.7538f, -1.4566f, 0.0f, 3.0f, 2.0f, 0.0f, cube), PartPose.m_171423_((float)1.15f, (float)1.0f, (float)-0.15f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftBrow_r2 = leftBrow.m_171599_("leftBrow_r2", CubeListBuilder.m_171558_().m_171514_(21, 37).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0451f, (float)-0.0834f, (float)-0.1725f));
        PartDefinition leftBrow_r3 = leftBrow.m_171599_("leftBrow_r3", CubeListBuilder.m_171558_().m_171514_(37, 12).m_171488_(-1.4f, -0.5f, -0.6f, 3.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)2.2437f, (float)-0.5276f, (float)1.2532f, (float)0.3589f, (float)-1.0414f, (float)-0.6033f));
        PartDefinition leftBrow_r4 = leftBrow.m_171599_("leftBrow_r4", CubeListBuilder.m_171558_().m_171514_(36, 18).m_171488_(-1.9f, 0.0f, 0.4f, 4.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)2.2437f, (float)-0.7776f, (float)1.2532f, (float)0.3589f, (float)-1.0414f, (float)-0.6033f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues(entity, netHeadYaw, headPitch);
        ModelPart leftWing = this.owl.m_171324_("leftWingBase");
        ModelPart rightWing = this.owl.m_171324_("rightWingBase");
        ModelPart rightLeg = this.owl.m_171324_("rightLeg");
        ModelPart leftLeg = this.owl.m_171324_("leftLeg");
        ModelPart head = this.owl.m_171324_("head");
        ModelPart rightTail = this.owl.m_171324_("rightTail");
        ModelPart leftTail = this.owl.m_171324_("leftTail");
        ModelPart tailMid = this.owl.m_171324_("tailMid");
        ModelPart beak_r1 = head.m_171324_("beak_r1");
        ModelPart leftWingCloseMiddle = leftWing.m_171324_("leftWingCloseMiddle");
        ModelPart leftWingFarMiddle = leftWingCloseMiddle.m_171324_("leftWingFarMiddle");
        ModelPart leftWingTip = leftWingFarMiddle.m_171324_("leftWingTip");
        ModelPart rightWingCloseMiddle = rightWing.m_171324_("rightWingCloseMiddle");
        ModelPart rightWingFarMiddle = rightWingCloseMiddle.m_171324_("rightWingFarMiddle");
        ModelPart rightWingTip = rightWingFarMiddle.m_171324_("rightWingTip");
        float partialTicks = Hexerei.getPartial();
        this.owl.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.bodyRotXo, (float)entity.bodyRotX);
        leftWing.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingBaseRotXo, (float)entity.leftWingBaseRotX) - this.owl.f_104203_ / 2.0f;
        leftWing.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingBaseRotYo, (float)entity.leftWingBaseRotY);
        leftWing.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingBaseRotZo, (float)entity.leftWingBaseRotZ);
        leftWingCloseMiddle.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingCloseMiddleRotXo, (float)entity.leftWingCloseMiddleRotX);
        leftWingCloseMiddle.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingCloseMiddleRotYo, (float)entity.leftWingCloseMiddleRotY);
        leftWingCloseMiddle.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingCloseMiddleRotZo, (float)entity.leftWingCloseMiddleRotZ);
        leftWingFarMiddle.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingFarMiddleRotXo, (float)entity.leftWingFarMiddleRotX);
        leftWingFarMiddle.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingFarMiddleRotYo, (float)entity.leftWingFarMiddleRotY);
        leftWingFarMiddle.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingFarMiddleRotZo, (float)entity.leftWingFarMiddleRotZ);
        leftWingTip.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingTipRotXo, (float)entity.leftWingTipRotX);
        leftWingTip.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingTipRotYo, (float)entity.leftWingTipRotY);
        leftWingTip.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.leftWingTipRotZo, (float)entity.leftWingTipRotZ);
        rightWing.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingBaseRotXo, (float)entity.rightWingBaseRotX) - this.owl.f_104203_ / 2.0f;
        rightWing.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingBaseRotYo, (float)entity.rightWingBaseRotY);
        rightWing.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingBaseRotZo, (float)entity.rightWingBaseRotZ);
        rightWingCloseMiddle.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingCloseMiddleRotXo, (float)entity.rightWingCloseMiddleRotX);
        rightWingCloseMiddle.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingCloseMiddleRotYo, (float)entity.rightWingCloseMiddleRotY);
        rightWingCloseMiddle.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingCloseMiddleRotZo, (float)entity.rightWingCloseMiddleRotZ);
        rightWingFarMiddle.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingFarMiddleRotXo, (float)entity.rightWingFarMiddleRotX);
        rightWingFarMiddle.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingFarMiddleRotYo, (float)entity.rightWingFarMiddleRotY);
        rightWingFarMiddle.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingFarMiddleRotZo, (float)entity.rightWingFarMiddleRotZ);
        rightWingTip.f_104203_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingTipRotXo, (float)entity.rightWingTipRotX);
        rightWingTip.f_104204_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingTipRotYo, (float)entity.rightWingTipRotY);
        rightWingTip.f_104205_ = Mth.m_14179_((float)partialTicks, (float)entity.rightWingTipRotZo, (float)entity.rightWingTipRotZ);
        if (!entity.m_20096_() || !entity.m_21825_()) {
            this.owl.f_104201_ = 18.5f;
        }
        if (entity.m_20096_()) {
            if (entity.m_21824_() && entity.m_21825_()) {
                rightLeg.f_104203_ = -0.5235988f;
                leftLeg.f_104203_ = -0.5235988f;
                this.owl.f_104201_ = 19.0f;
            } else {
                rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
                this.owl.f_104205_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount / 5.0f;
                rightWing.f_104204_ += Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount * 0.15f;
                leftWing.f_104204_ += Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount * 0.15f;
                rightWingTip.f_104204_ += Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount * 0.15f;
                leftWingTip.f_104204_ += Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount * 0.15f;
            }
            head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f - this.owl.f_104203_;
            rightTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            rightWing.f_104203_ += Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.05f;
            rightWing.f_104205_ -= Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.05f;
            leftWing.f_104203_ += Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.05f;
            leftWing.f_104205_ += Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.05f;
            rightWingFarMiddle.f_104205_ -= Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.05f;
            leftWingFarMiddle.f_104205_ += Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.05f;
            rightWingTip.f_104204_ -= Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.15f;
            leftWingTip.f_104204_ += Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.15f;
            rightTail.f_104204_ = -Mth.m_14031_((float)0.05f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.05f);
            rightTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            tailMid.f_104204_ = Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            if (entity.tailWag) {
                rightTail.f_104204_ += Mth.m_14031_((float)0.15f) * 0.5f;
                leftTail.f_104204_ -= Mth.m_14031_((float)0.15f) * 0.5f;
            }
            rightTail.f_104204_ -= Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
        } else {
            if (entity.m_20159_()) {
                rightLeg.f_104203_ = -0.5235988f;
                leftLeg.f_104203_ = -0.5235988f;
                this.owl.f_104201_ = 19.0f;
                head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f - this.owl.f_104203_;
                rightTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
                leftTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
                tailMid.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
                rightTail.f_104204_ = -Mth.m_14031_((float)0.05f);
                leftTail.f_104204_ = Mth.m_14031_((float)0.05f);
                rightTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
                leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
                tailMid.f_104204_ = Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
                if (entity.tailWag) {
                    rightTail.f_104204_ += Mth.m_14031_((float)0.15f) * 0.5f;
                    leftTail.f_104204_ -= Mth.m_14031_((float)0.15f) * 0.5f;
                }
                rightTail.f_104204_ -= Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
                leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
            } else {
                leftWing.f_104207_ = true;
                rightWing.f_104207_ = true;
                rightLeg.f_104203_ = Mth.m_14031_((float)20.0f);
                leftLeg.f_104203_ = Mth.m_14031_((float)20.0f);
                head.f_104203_ = (float)Math.toRadians(headPitch) - this.owl.f_104203_;
                rightTail.f_104204_ = -Mth.m_14031_((float)0.15f);
                leftTail.f_104204_ = Mth.m_14031_((float)0.15f);
            }
            this.owl.f_104201_ += Mth.m_14179_((float)Hexerei.getPartial(), (float)((float)Math.sin((float)entity.flappingAnimPrev / 2.0f)), (float)((float)Math.sin((float)entity.flappingAnim / 2.0f))) * 2.0f;
        }
        head.f_104204_ = (float)Math.toRadians(netHeadYaw);
        head.f_104205_ = Mth.m_14031_((float)(entity.headZTiltAngleActual / 100.0f)) / 2.0f;
        head.f_104203_ += Mth.m_14031_((float)(entity.headXTiltAngleActual / 100.0f)) / 2.0f;
        if ((entity.m_20096_() || entity.m_20159_()) && entity.dance) {
            head.f_104205_ = 0.0f;
            head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)((float)entity.animationCounter / 1.5f)) / 12.0f;
            head.f_104204_ = (float)Math.toRadians(netHeadYaw) + Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) / 4.0f;
            rightTail.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            this.owl.f_104204_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.2f;
            rightTail.f_104204_ = Mth.m_14031_((float)0.1f);
            leftTail.f_104204_ = -Mth.m_14031_((float)0.1f);
            this.owl.f_104201_ = 17.5f + Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            rightTail.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            leftTail.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            tailMid.f_104204_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
        } else {
            this.owl.f_104204_ = 0.0f;
        }
        beak_r1.f_104203_ = Mth.m_14031_((float)(entity.cawTiltAngleActual / 100.0f));
        if (entity.peckTiltAngleActual > 0.0f) {
            beak_r1.f_104203_ = Mth.m_14031_((float)(entity.peckTiltAngleActual / 100.0f));
        }
        if (entity.playingDead > 0 && !entity.m_21224_()) {
            this.owl.f_104205_ = HexereiUtil.moveTo(this.owl.f_104205_, 1.3962634f, 0.025f);
            this.owl.f_104201_ -= 4.0f * this.owl.f_104205_ / (float)Math.PI;
            head.f_104207_ = false;
        } else {
            if (this.owl.f_104205_ != 0.0f) {
                this.owl.f_104205_ = HexereiUtil.moveTo(this.owl.f_104205_, 0.0f, 0.075f);
                this.owl.f_104201_ -= 4.0f * this.owl.f_104205_ / (float)Math.PI;
            }
            head.f_104207_ = true;
        }
        this.owl.f_104201_ = (float)((double)this.owl.f_104201_ - 0.1);
        this.saveAnimationValues(entity);
    }

    private Vector3f getRotationVector(ModelPart pModelPart) {
        return new Vector3f(pModelPart.f_104203_, pModelPart.f_104204_, pModelPart.f_104205_);
    }

    private void setRotationFromVector(ModelPart pModelPart, Vector3f pRotationVector) {
        pModelPart.m_171327_(pRotationVector.m_122239_(), pRotationVector.m_122260_(), pRotationVector.m_122269_());
    }

    private void saveAnimationValues(OwlEntity owl) {
        Map<String, Vector3f> map = owl.getModelRotationValues();
        map.put("owl", this.getRotationVector(this.owl));
    }

    private void setupInitialAnimationValues(OwlEntity owl, float pNetHeadYaw, float pHeadPitch) {
        this.owl.f_104200_ = 0.0f;
        this.owl.f_104201_ = 15.0f;
        Map<String, Vector3f> map = owl.getModelRotationValues();
        if (map.isEmpty()) {
            this.owl.m_171327_(pHeadPitch * ((float)Math.PI / 180), pNetHeadYaw * ((float)Math.PI / 180), 0.0f);
        } else {
            this.setRotationFromVector(this.owl, map.get("owl"));
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.owl.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return Collections.singleton(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Collections.singleton(this.owl);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

