/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.network;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.util.TriConsumer;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.common.network.MsgAddRenderLinkAck;
import ram.talia.hexal.common.network.MsgParticleLinesAck;
import ram.talia.hexal.common.network.MsgRemoveEverbookAck;
import ram.talia.hexal.common.network.MsgRemoveRenderLinkAck;
import ram.talia.hexal.common.network.MsgSendEverbookSyn;
import ram.talia.hexal.common.network.MsgSetEverbookAck;
import ram.talia.hexal.common.network.MsgSetRenderLinksAck;
import ram.talia.hexal.common.network.MsgSingleParticleAck;
import ram.talia.hexal.common.network.MsgToggleMacroAck;
import ram.talia.hexal.common.network.MsgWispCastSoundAck;

public class ForgePacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)HexalAPI.modLoc("main"), () -> "1", "1"::equals, "1"::equals);

    public static SimpleChannel getNetwork() {
        return NETWORK;
    }

    public static void init() {
        int messageIdx = 0;
        NETWORK.registerMessage(messageIdx++, MsgSendEverbookSyn.class, MsgSendEverbookSyn::serialize, MsgSendEverbookSyn::deserialise, ForgePacketHandler.makeServerBoundHandler(MsgSendEverbookSyn::handle));
        NETWORK.registerMessage(messageIdx++, MsgSetEverbookAck.class, MsgSetEverbookAck::serialize, MsgSetEverbookAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgSetEverbookAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgRemoveEverbookAck.class, MsgRemoveEverbookAck::serialize, MsgRemoveEverbookAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgRemoveEverbookAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgToggleMacroAck.class, MsgToggleMacroAck::serialize, MsgToggleMacroAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgToggleMacroAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgWispCastSoundAck.class, MsgWispCastSoundAck::serialize, MsgWispCastSoundAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgWispCastSoundAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgAddRenderLinkAck.class, MsgAddRenderLinkAck::serialize, MsgAddRenderLinkAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgAddRenderLinkAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgRemoveRenderLinkAck.class, MsgRemoveRenderLinkAck::serialize, MsgRemoveRenderLinkAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgRemoveRenderLinkAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgSetRenderLinksAck.class, MsgSetRenderLinksAck::serialize, MsgSetRenderLinksAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgSetRenderLinksAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgSingleParticleAck.class, MsgSingleParticleAck::serialize, MsgSingleParticleAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgSingleParticleAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgParticleLinesAck.class, MsgParticleLinesAck::serialize, MsgParticleLinesAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgParticleLinesAck::handle));
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeServerBoundHandler(TriConsumer<T, MinecraftServer, ServerPlayer> handler) {
        return (m, ctx) -> {
            handler.accept(m, (Object)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()).m_20194_(), (Object)((NetworkEvent.Context)ctx.get()).getSender());
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeClientBoundHandler(Consumer<T> consumer) {
        return (m, ctx) -> {
            consumer.accept(m);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }
}

