/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.nbt;

import at.petrak.hexcasting.api.spell.iota.EntityIota;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.IotaType;
import at.petrak.hexcasting.api.spell.iota.ListIota;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0011\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\tB\u001f\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0002J\u001e\u0010 \u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003H\u0002J\u0014\u0010\"\u001a\u00020\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010#\u001a\u00020$R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lram/talia/hexal/api/nbt/SerialisedIotaList;", "", "iotas", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "(Ljava/util/List;)V", "tag", "Lnet/minecraft/nbt/ListTag;", "(Lnet/minecraft/nbt/ListTag;)V", "()V", "(Lnet/minecraft/nbt/ListTag;Ljava/util/List;)V", "iotasReferencedEntities", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/server/level/ServerLevel;", "tagReferencedEntitiesAreLoaded", "", "tagReferencedEntityUUIDs", "Ljava/util/UUID;", "add", "", "iota", "Lnet/minecraft/nbt/CompoundTag;", "clear", "getIotas", "", "getReferencedEntities", "getTag", "pop", "refreshIotas", "scanIotaForEntities", "entityList", "scanTagForEntities", "referencedEntityUUIDs", "set", "size", "", "hexal-forge-1.19.2"})
public final class SerialisedIotaList {
    @Nullable
    private ListTag tag;
    @Nullable
    private List<Iota> iotas;
    @Nullable
    private ServerLevel level;
    @Nullable
    private List<UUID> tagReferencedEntityUUIDs;
    @Nullable
    private List<Boolean> tagReferencedEntitiesAreLoaded;
    @Nullable
    private List<Entity> iotasReferencedEntities;

    public SerialisedIotaList(@Nullable ListTag tag, @Nullable List<Iota> iotas) {
        this.tag = tag;
        this.iotas = iotas;
    }

    public SerialisedIotaList(@Nullable List<Iota> iotas) {
        this(null, iotas);
    }

    public SerialisedIotaList(@Nullable ListTag tag) {
        this(tag, null);
    }

    public SerialisedIotaList() {
        this(null, null);
    }

    private final void scanIotaForEntities(Iota iota, List<Entity> entityList) {
        IotaType iotaType = iota.getType();
        if (Intrinsics.areEqual((Object)iotaType, (Object)HexIotaTypes.ENTITY)) {
            Intrinsics.checkNotNull((Object)iota, (String)"null cannot be cast to non-null type at.petrak.hexcasting.api.spell.iota.EntityIota");
            Entity entity = ((EntityIota)iota).getEntity();
            if (!entityList.contains(entity)) {
                Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
                entityList.add(entity);
            }
        } else if (Intrinsics.areEqual((Object)iotaType, (Object)HexIotaTypes.LIST)) {
            Intrinsics.checkNotNull((Object)iota, (String)"null cannot be cast to non-null type at.petrak.hexcasting.api.spell.iota.ListIota");
            for (Iota subIota : ((ListIota)iota).getList()) {
                this.scanIotaForEntities(subIota, entityList);
            }
        }
    }

    private final void scanTagForEntities(CompoundTag tag, List<UUID> referencedEntityUUIDs) {
        IotaType iotaType = HexIotaTypes.getTypeFromTag((CompoundTag)tag);
        if (iotaType == null) {
            return;
        }
        IotaType type2 = iotaType;
        Tag tag2 = tag.m_128423_("hexcasting:data");
        if (tag2 == null) {
            return;
        }
        Tag data = tag2;
        IotaType iotaType2 = HexIotaTypes.getTypeFromTag((CompoundTag)tag);
        if (Intrinsics.areEqual((Object)iotaType2, (Object)HexIotaTypes.ENTITY)) {
            TagType tagType = CompoundTag.f_128326_;
            Intrinsics.checkNotNullExpressionValue((Object)tagType, (String)"TYPE");
            Tag tag3 = ((CompoundTag)HexUtils.downcast((Tag)data, (TagType)tagType)).m_128423_("uuid");
            if (tag3 == null) {
                return;
            }
            Tag uuidTag = tag3;
            UUID uuid = NbtUtils.m_129233_((Tag)uuidTag);
            if (!referencedEntityUUIDs.contains(uuid)) {
                Intrinsics.checkNotNullExpressionValue((Object)uuid, (String)"uuid");
                referencedEntityUUIDs.add(uuid);
            }
        } else if (Intrinsics.areEqual((Object)iotaType2, (Object)HexIotaTypes.LIST)) {
            TagType tagType = ListTag.f_128714_;
            Intrinsics.checkNotNullExpressionValue((Object)tagType, (String)"TYPE");
            ListTag listTag = (ListTag)HexUtils.downcast((Tag)data, (TagType)tagType);
            for (Tag sub : listTag) {
                Intrinsics.checkNotNullExpressionValue((Object)sub, (String)"sub");
                TagType tagType2 = CompoundTag.f_128326_;
                Intrinsics.checkNotNullExpressionValue((Object)tagType2, (String)"TYPE");
                Tag tag4 = HexUtils.downcast((Tag)sub, (TagType)tagType2);
                Intrinsics.checkNotNullExpressionValue((Object)tag4, (String)"sub.downcast(CompoundTag.TYPE)");
                this.scanTagForEntities((CompoundTag)tag4, referencedEntityUUIDs);
            }
        }
    }

    public final void clear() {
        this.iotas = null;
        this.tag = null;
        this.level = null;
        this.tagReferencedEntityUUIDs = null;
        this.tagReferencedEntitiesAreLoaded = null;
        this.iotasReferencedEntities = null;
    }

    public final void set(@NotNull List<Iota> iotas) {
        Intrinsics.checkNotNullParameter(iotas, (String)"iotas");
        this.iotas = iotas;
        this.tag = null;
        this.level = null;
        this.tagReferencedEntityUUIDs = null;
        this.tagReferencedEntitiesAreLoaded = null;
        this.iotasReferencedEntities = null;
    }

    public final void set(@NotNull ListTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
        this.level = null;
        this.iotas = null;
        this.tagReferencedEntityUUIDs = null;
        this.tagReferencedEntitiesAreLoaded = null;
        this.iotasReferencedEntities = null;
    }

    public final void refreshIotas(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.tag != null) {
            boolean regenerateCache;
            boolean bl = regenerateCache = this.iotas == null || !Intrinsics.areEqual((Object)this.level, (Object)level);
            if (this.tagReferencedEntityUUIDs != null) {
                List<UUID> list = this.tagReferencedEntityUUIDs;
                Intrinsics.checkNotNull(list);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    List<UUID> list2 = this.tagReferencedEntityUUIDs;
                    Intrinsics.checkNotNull(list2);
                    UUID uuid = list2.get(i);
                    List<Boolean> list3 = this.tagReferencedEntitiesAreLoaded;
                    Intrinsics.checkNotNull(list3);
                    boolean entityIsLoaded = list3.get(i);
                    Entity entity = level.m_8791_(uuid);
                    if (entity != null == entityIsLoaded) continue;
                    regenerateCache = true;
                    break;
                }
            }
            if (regenerateCache) {
                this.tagReferencedEntityUUIDs = new ArrayList();
                this.tagReferencedEntitiesAreLoaded = new ArrayList();
                this.level = level;
                Object object = this.tag;
                if (object == null || (object = HexalNBTHelperKt.toIotaList(object, level)) == null) {
                    object = this.iotas = (List)new ArrayList();
                }
                if (this.tag != null) {
                    ListTag listTag = this.tag;
                    Intrinsics.checkNotNull((Object)listTag);
                    for (Tag innerTag : listTag) {
                        Intrinsics.checkNotNullExpressionValue((Object)innerTag, (String)"innerTag");
                        CompoundTag compoundTag = NBTHelper.getAsCompound((Tag)innerTag);
                        List<UUID> list = this.tagReferencedEntityUUIDs;
                        Intrinsics.checkNotNull(list);
                        this.scanTagForEntities(compoundTag, list);
                    }
                }
                List<UUID> list = this.tagReferencedEntityUUIDs;
                Intrinsics.checkNotNull(list);
                for (UUID uuid : list) {
                    List<Boolean> list4 = this.tagReferencedEntitiesAreLoaded;
                    Intrinsics.checkNotNull(list4);
                    list4.add(level.m_8791_(uuid) != null);
                }
            }
        } else if (this.iotas != null) {
            if (this.iotasReferencedEntities == null) {
                this.iotasReferencedEntities = new ArrayList();
                List<Iota> list = this.iotas;
                Intrinsics.checkNotNull(list);
                for (Iota iota : list) {
                    List<Entity> list5 = this.iotasReferencedEntities;
                    Intrinsics.checkNotNull(list5);
                    this.scanIotaForEntities(iota, list5);
                }
            }
            boolean forceSerialize = false;
            List<Entity> list = this.iotasReferencedEntities;
            Intrinsics.checkNotNull(list);
            for (Entity entity : list) {
                if (!entity.m_213877_()) continue;
                forceSerialize = true;
                break;
            }
            if (forceSerialize) {
                List<Iota> list6 = this.iotas;
                Intrinsics.checkNotNull(list6);
                ListTag listTag = this.tag = HexalNBTHelperKt.toNbtListSpellDatum(list6);
                Intrinsics.checkNotNull((Object)listTag);
                this.iotas = HexalNBTHelperKt.toIotaList(listTag, level);
                this.level = level;
                this.iotasReferencedEntities = null;
                this.tagReferencedEntityUUIDs = null;
                this.tagReferencedEntitiesAreLoaded = null;
            }
        }
    }

    @NotNull
    public final List<Iota> getIotas(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.refreshIotas(level);
        List list = this.iotas;
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @NotNull
    public final ListTag getTag() {
        ListTag listTag;
        if (this.tag == null && this.iotas != null) {
            List<Iota> list = this.iotas;
            Intrinsics.checkNotNull(list);
            this.tag = HexalNBTHelperKt.toNbtListSpellDatum(list);
            this.iotas = null;
            this.level = null;
            this.iotasReferencedEntities = null;
            this.tagReferencedEntityUUIDs = null;
            this.tagReferencedEntitiesAreLoaded = null;
        }
        if ((listTag = this.tag) == null) {
            listTag = new ListTag();
        }
        return listTag;
    }

    public final void add(@NotNull Iota iota) {
        Intrinsics.checkNotNullParameter((Object)iota, (String)"iota");
        if (this.tag != null) {
            CompoundTag newTag = HexIotaTypes.serialize((Iota)iota);
            ListTag listTag = this.tag;
            Intrinsics.checkNotNull((Object)listTag);
            listTag.add((Object)newTag);
            this.level = null;
            this.iotas = null;
            this.tagReferencedEntityUUIDs = null;
            this.tagReferencedEntitiesAreLoaded = null;
            this.iotasReferencedEntities = null;
        } else if (this.iotas != null) {
            List<Iota> list = this.iotas;
            Intrinsics.checkNotNull(list);
            list.add(iota);
            this.iotasReferencedEntities = null;
        } else {
            Object[] objectArray = new Iota[]{iota};
            this.iotas = CollectionsKt.mutableListOf((Object[])objectArray);
        }
    }

    public final void add(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (this.tag != null) {
            ListTag listTag = this.tag;
            Intrinsics.checkNotNull((Object)listTag);
            listTag.add((Object)tag);
            this.level = null;
            this.iotas = null;
            this.tagReferencedEntityUUIDs = null;
            this.tagReferencedEntitiesAreLoaded = null;
            this.iotasReferencedEntities = null;
        } else if (this.iotas != null) {
            List<Iota> list = this.iotas;
            Intrinsics.checkNotNull(list);
            ListTag listTag = this.tag = HexalNBTHelperKt.toNbtListSpellDatum(list);
            Intrinsics.checkNotNull((Object)listTag);
            listTag.add((Object)tag);
            this.level = null;
            this.iotas = null;
            this.iotasReferencedEntities = null;
            this.tagReferencedEntityUUIDs = null;
            this.tagReferencedEntitiesAreLoaded = null;
        } else {
            ListTag listTag = this.tag = new ListTag();
            Intrinsics.checkNotNull((Object)listTag);
            listTag.add((Object)tag);
        }
    }

    @Nullable
    public final Iota pop(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.tag != null) {
            ListTag listTag = this.tag;
            Intrinsics.checkNotNull((Object)listTag);
            if (listTag.size() == 0) {
                return null;
            }
            ListTag listTag2 = this.tag;
            Intrinsics.checkNotNull((Object)listTag2);
            Tag poppedTag = (Tag)listTag2.remove(0);
            this.level = null;
            this.iotas = null;
            this.tagReferencedEntityUUIDs = null;
            this.tagReferencedEntitiesAreLoaded = null;
            this.iotasReferencedEntities = null;
            ListTag listTag3 = this.tag;
            Intrinsics.checkNotNull((Object)listTag3);
            if (listTag3.size() == 0) {
                this.tag = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)poppedTag, (String)"poppedTag");
            return HexIotaTypes.deserialize((CompoundTag)NBTHelper.getAsCompound((Tag)poppedTag), (ServerLevel)level);
        }
        if (this.iotas != null) {
            List<Iota> list = this.iotas;
            Intrinsics.checkNotNull(list);
            if (list.size() == 0) {
                return null;
            }
            List<Iota> list2 = this.iotas;
            Intrinsics.checkNotNull(list2);
            Iota poppedIota = list2.remove(0);
            this.iotasReferencedEntities = null;
            return poppedIota;
        }
        return null;
    }

    public final int size() {
        int n;
        if (this.tag != null) {
            ListTag listTag = this.tag;
            Intrinsics.checkNotNull((Object)listTag);
            n = listTag.size();
        } else if (this.iotas != null) {
            List<Iota> list = this.iotas;
            Intrinsics.checkNotNull(list);
            n = list.size();
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final List<Entity> getReferencedEntities(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.tag != null) {
            if (this.tagReferencedEntityUUIDs == null) {
                this.tagReferencedEntityUUIDs = new ArrayList();
                this.tagReferencedEntitiesAreLoaded = new ArrayList();
                ListTag listTag = this.tag;
                Intrinsics.checkNotNull((Object)listTag);
                for (Tag tag : listTag) {
                    Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"innerTag");
                    CompoundTag compoundTag = NBTHelper.getAsCompound((Tag)tag);
                    List<UUID> list = this.tagReferencedEntityUUIDs;
                    Intrinsics.checkNotNull(list);
                    this.scanTagForEntities(compoundTag, list);
                }
                List<UUID> list = this.tagReferencedEntityUUIDs;
                Intrinsics.checkNotNull(list);
                for (UUID uUID : list) {
                    List<Boolean> list2 = this.tagReferencedEntitiesAreLoaded;
                    Intrinsics.checkNotNull(list2);
                    list2.add(level.m_8791_(uUID) != null);
                }
            }
            List referencedEntities = new ArrayList();
            List<UUID> list = this.tagReferencedEntityUUIDs;
            Intrinsics.checkNotNull(list);
            for (UUID uuid : list) {
                Entity entity = level.m_8791_(uuid);
                if (entity == null) continue;
                referencedEntities.add(entity);
            }
            return referencedEntities;
        }
        if (this.iotas != null) {
            if (this.iotasReferencedEntities == null) {
                this.iotasReferencedEntities = new ArrayList();
                List<Iota> list = this.iotas;
                Intrinsics.checkNotNull(list);
                for (Iota iota : list) {
                    List<Entity> list3 = this.iotasReferencedEntities;
                    Intrinsics.checkNotNull(list3);
                    this.scanIotaForEntities(iota, list3);
                }
            }
            List<Entity> list = this.iotasReferencedEntities;
            Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<net.minecraft.world.entity.Entity>");
            return list;
        }
        return new ArrayList();
    }
}

