/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.UnaryOperator;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.entity.FishingDynamiteEntity;
import ky.someone.mods.gag.entity.MiningDynamiteEntity;
import ky.someone.mods.gag.item.DynamiteItem;
import ky.someone.mods.gag.item.EnergizedHearthstoneItem;
import ky.someone.mods.gag.item.EscapeRopeItem;
import ky.someone.mods.gag.item.HearthstoneItem;
import ky.someone.mods.gag.item.LabelingToolItem;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.RepellingItem;
import ky.someone.mods.gag.item.TemporalPouchItem;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public interface ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"gag", (ResourceKey)Registry.f_122904_);
    public static final RegistrySupplier<TemporalPouchItem> TIME_SAND_POUCH = ITEMS.register("time_sand_pouch", TemporalPouchItem::new);
    public static final RegistrySupplier<Item> ESCAPE_ROPE = ITEMS.register("escape_rope", EscapeRopeItem::new);
    public static final RegistrySupplier<Item> HEARTHSTONE = ITEMS.register("hearthstone", HearthstoneItem::new);
    public static final RegistrySupplier<Item> ENERGIZED_HEARTHSTONE = ITEMS.register("energized_hearthstone", EnergizedHearthstoneItem::new);
    public static final RegistrySupplier<Item> SACRED_SALT = ItemRegistry.repelling("sacred_salt", p -> p.m_41487_(16).m_41497_(Rarity.UNCOMMON), 800, 1, false);
    public static final RegistrySupplier<Item> SACRED_SALVE = ItemRegistry.repelling("sacred_salve", p -> p.m_41487_(4).m_41497_(Rarity.RARE), 2400, 2, true);
    public static final RegistrySupplier<Item> SACRED_BALM = ItemRegistry.repelling("sacred_balm", p -> p.m_41487_(4).m_41497_(Rarity.RARE), 7200, 0, true);
    public static final RegistrySupplier<Item> MINING_DYNAMITE = ItemRegistry.dynamite("mining_dynamite", MiningDynamiteEntity::new, List.of(Component.m_237115_((String)"item.gag.mining_dynamite.info").m_130938_(GAGUtil.TOOLTIP_MAIN)), 1.5);
    public static final RegistrySupplier<Item> FISHING_DYNAMITE = ItemRegistry.dynamite("fishing_dynamite", FishingDynamiteEntity::new, List.of(Component.m_237115_((String)"item.gag.fishing_dynamite.info").m_130938_(GAGUtil.TOOLTIP_MAIN)), 1.5);
    public static final RegistrySupplier<Item> LABELING_TOOL = ITEMS.register("labeling_tool", LabelingToolItem::new);
    public static final RegistrySupplier<Item> PIGMENT_JAR = ITEMS.register("pigment_jar", PigmentJarItem::new);

    private static RegistrySupplier<Item> repelling(String name, UnaryOperator<Item.Properties> properties, int duration, int amplifier, boolean hasTooltip) {
        return ITEMS.register(name, () -> new RepellingItem((Item.Properties)properties.apply(new Item.Properties().m_41491_(GAG.CREATIVE_TAB)), duration, amplifier, hasTooltip));
    }

    private static RegistrySupplier<Item> dynamite(String name, DynamiteItem.EntityFactory factory, List<Component> tooltip, double throwSpeed) {
        return ITEMS.register(name, () -> new DynamiteItem(new Item.Properties().m_41491_(GAG.CREATIVE_TAB), factory, tooltip, throwSpeed));
    }
}

