/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.HearthstoneItem;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.misc.TeleportPos;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnergizedHearthstoneItem
extends HearthstoneItem {
    private static final String TARGET_KEY = "target";

    public EnergizedHearthstoneItem() {
        super((Integer)GAGConfig.Hearthstone.ENERGIZED_DURABILITY.get());
    }

    public boolean isBound(ItemStack stack) {
        return stack.m_41737_(TARGET_KEY) != null;
    }

    @Override
    public TeleportPos getTeleportPos(@Nullable Player player, ItemStack stack) {
        if (this.isBound(stack)) {
            return TeleportPos.fromNbt(stack.m_41737_(TARGET_KEY));
        }
        return null;
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(this.getTargetText(null, stack));
        GAGUtil.appendInfoTooltip(tooltip, List.of(this.getTranslation("info_adv", new Object[0]).m_130938_(GAGUtil.TOOLTIP_MAIN), this.getTranslation("info_adv_2", new Object[0]).m_130938_(GAGUtil.TOOLTIP_MAIN), this.getTranslation("info_adv_3", new Object[0]).m_130938_(GAGUtil.TOOLTIP_MAIN), Component.m_237115_((String)"info.gag.supports_unbreaking").m_130938_(GAGUtil.TOOLTIP_EXTRA)));
    }

    @Override
    public Component getTargetText(@Nullable Player player, ItemStack stack) {
        TeleportPos target = this.getTeleportPos(player, stack);
        if (target != null) {
            Vec3 pos = target.pos();
            ResourceLocation level = target.level();
            MutableComponent text = Component.m_237115_((String)String.format("(%.1f %.1f %.1f)", pos.f_82479_, pos.f_82480_, pos.f_82481_)).m_130938_(GAGUtil.COLOUR_TRUE);
            if (player == null || !level.equals((Object)player.f_19853_.m_46472_().m_135782_())) {
                text.m_130946_(" @ ").m_7220_((Component)Component.m_237115_((String)level.toString()).m_130940_(ChatFormatting.GRAY));
            }
            return this.getTranslation("target.bound", text).m_130938_(GAGUtil.COLOUR_INFO);
        }
        return this.getTranslation("target.unbound", new Object[0]).m_130938_(GAGUtil.COLOUR_FALSE);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.isBound(stack)) {
            if (player.m_6144_()) {
                TeleportPos pos = new TeleportPos(player.f_19853_.m_46472_().m_135782_(), player.m_20182_(), player.m_146908_());
                stack.m_41700_(TARGET_KEY, (Tag)pos.toNbt());
                player.m_5496_(SoundEvents.f_12521_, 0.5f, 1.25f);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Override
    public int m_8105_(ItemStack stack) {
        return this.isBound(stack) ? super.m_8105_(stack) : 0;
    }

    public static void lightningStrike(LightningBolt bolt, Level level, Vec3 pos, List<Entity> toStrike) {
        Iterator<Entity> iter = toStrike.iterator();
        while (iter.hasNext()) {
            Entity entity = iter.next();
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_150930_((Item)ItemRegistry.HEARTHSTONE.get())) {
                ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.ENERGIZED_HEARTHSTONE.get());
                float damage = (float)stack.m_41773_() / (float)stack.m_41776_();
                newStack.m_41721_((int)((float)newStack.m_41776_() * damage));
                EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)stack), (ItemStack)newStack);
                itemEntity.m_32045_(newStack);
                bolt.f_147134_.add(entity);
                iter.remove();
                continue;
            }
            if (!stack.m_150930_((Item)ItemRegistry.ENERGIZED_HEARTHSTONE.get())) continue;
            if (!bolt.f_147134_.contains(entity)) {
                stack.m_41749_(TARGET_KEY);
                float damage = (float)stack.m_41773_() / (float)stack.m_41776_();
                stack.m_41721_((int)((double)stack.m_41776_() * Math.max(0.0, (double)damage - 0.25)));
            }
            itemEntity.m_20331_(true);
            bolt.f_147134_.add(entity);
            iter.remove();
        }
    }
}

