/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilePackResources.class})
public class FilePackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow
    private static Logger f_215322_;
    @Unique
    private String overridesFolder;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolder = folder;
    }

    @Shadow
    private ZipFile m_10247_() {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Ljava/lang/String;)Ljava/io/InputStream;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<InputStream> ci) throws IOException {
        ZipEntry zipEntry;
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + (String)path;
        ZipFile zipFile = this.m_10247_();
        if (zipFile != null && (zipEntry = zipFile.getEntry((String)path)) != null) {
            ci.setReturnValue((Object)zipFile.getInputStream(zipEntry));
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasResource(String path, CallbackInfoReturnable<Boolean> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + (String)path;
        try {
            ZipFile zipFile = this.m_10247_();
            if (zipFile != null && zipFile.getEntry((String)path) != null) {
                ci.setReturnValue((Object)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        ZipFile zipFile;
        if (this.overridesFolder == null) {
            return;
        }
        try {
            zipFile = this.m_10247_();
        }
        catch (Exception ignored) {
            return;
        }
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            if (!name.startsWith(this.overridesFolder) || !(name = name.substring(this.overridesFolder.length())).startsWith(type.m_10305_() + "/") || (list = Lists.newArrayList((Iterable)FilePackResources.f_10232_.split((CharSequence)name))).size() <= 1) continue;
            String namespace = (String)list.get(1);
            if (namespace.equals(namespace.toLowerCase(Locale.ROOT))) {
                namespaces.add(namespace);
                continue;
            }
            f_215322_.warn("Ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)((FilePackResources)this).f_10203_);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @Inject(method={"getResources"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResources(PackType type, String namespace, String folderName, Predicate<ResourceLocation> predicate, CallbackInfoReturnable<Collection<ResourceLocation>> ci) {
        ZipFile zipFile;
        if (this.overridesFolder == null) {
            return;
        }
        if (ci.getReturnValue() == null) {
            return;
        }
        List<ResourceLocation> locations = ci.getReturnValue() instanceof ArrayList ? (List)ci.getReturnValue() : new ArrayList((Collection)ci.getReturnValue());
        HashSet locationSet = new HashSet(locations);
        try {
            zipFile = this.m_10247_();
        }
        catch (Exception ignored) {
            return;
        }
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String namespaceDirectory = this.overridesFolder + type.m_10305_() + "/" + namespace + "/";
        String pathDirectory = namespaceDirectory + folderName + "/";
        while (enumeration.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || (name = zipEntry.getName()).endsWith(".mcmeta") || !name.startsWith(pathDirectory)) continue;
            String identifier = name.substring(namespaceDirectory.length());
            ResourceLocation location = ResourceLocation.m_214293_((String)namespace, (String)identifier);
            if (location != null) {
                if (locationSet.contains(location) || !predicate.test(location)) continue;
                locations.add(location);
                continue;
            }
            f_215322_.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)identifier);
        }
        ci.setReturnValue(locations);
    }
}

