/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidDrawerRenderer
implements BlockEntityRenderer<FluidDrawerTile> {
    public static void renderFluidStack(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay, FluidStack stack, int amount, int maxAmount, float scale, ControllableDrawerTile.DrawerOptions options, AABB bounds, boolean halfText, boolean isSmallBar) {
        matrixStack.m_85836_();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        ResourceLocation texture = renderProperties.getStillTexture(stack);
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110466_());
        float[] color = FluidDrawerRenderer.decomposeColorF(renderProperties.getTintColor(stack));
        float red = color[1];
        float green = color[2];
        float blue = color[3];
        float alpha = amount == 0 ? 0.3f : color[0];
        float x1 = (float)bounds.f_82288_;
        float x2 = (float)bounds.f_82291_;
        float y1 = (float)bounds.f_82289_;
        float y2 = (float)bounds.f_82292_;
        float z1 = (float)bounds.f_82290_;
        float z2 = (float)bounds.f_82293_;
        double bx1 = bounds.f_82288_ * 16.0;
        double bx2 = bounds.f_82291_ * 16.0;
        double by1 = bounds.f_82289_ * 16.0;
        double by2 = bounds.f_82292_ * 16.0;
        double bz1 = bounds.f_82290_ * 16.0;
        double bz2 = bounds.f_82293_ * 16.0;
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        float u1 = still.m_118367_(bx1);
        float u2 = still.m_118367_(bx2);
        float v1 = still.m_118393_(bz1);
        float v2 = still.m_118393_(bz2);
        builder.m_85982_(posMat, x1, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(posMat, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(posMat, x2, y2, z1).m_85950_(red, green, blue, alpha).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(posMat, x1, y2, z1).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        u1 = still.m_118367_(bx1);
        u2 = still.m_118367_(bx2);
        v1 = still.m_118393_(by1);
        v2 = still.m_118393_(by2);
        builder.m_85982_(posMat, x2, y1, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, x1, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, x1, y1, z2).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        matrixStack.m_85849_();
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.84, 0.97);
            if (halfText) {
                matrixStack.m_85837_(-0.25, 0.0, 0.0);
            }
            DrawerRenderer.renderText(matrixStack, bufferIn, combinedOverlay, (Component)Component.m_237113_((String)(ChatFormatting.WHITE + NumberUtils.getFormatedFluidBigNumber(amount))), Direction.NORTH, scale);
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.453, 0.97);
        if (halfText) {
            matrixStack.m_85841_(0.5f, 0.65f, 0.5f);
            matrixStack.m_85837_(-0.5, -0.18, 0.0);
        }
        DrawerRenderer.renderIndicator(matrixStack, bufferIn, combinedLight, combinedOverlay, Math.min(1.0f, (float)amount / (float)maxAmount), options);
        matrixStack.m_85849_();
    }

    public static float[] decomposeColorF(int color) {
        float[] res = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return res;
    }

    public void render(FluidDrawerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (Minecraft.m_91087_().f_91074_ != null && !tile.m_58899_().m_123314_((Vec3i)Minecraft.m_91087_().f_91074_.m_20097_(), (double)FunctionalStorageClientConfig.DRAWER_RENDER_RANGE)) {
            return;
        }
        matrixStack.m_85836_();
        Direction facing = tile.getFacingDirection();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
        if (facing == Direction.NORTH) {
            matrixStack.m_85837_(-1.0, 0.0, -1.0);
        }
        if (facing == Direction.EAST) {
            matrixStack.m_85837_(0.0, 0.0, -1.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        }
        if (facing == Direction.SOUTH) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
        }
        if (facing == Direction.WEST) {
            matrixStack.m_85837_(-1.0, 0.0, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
        combinedLightIn = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_121945_(facing));
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_1) {
            this.render1Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_2) {
            this.render2Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_4) {
            this.render4Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.9688);
        DrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    private void render1Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, FluidDrawerTile tile) {
        BigFluidHandler inventoryHandler = tile.getFluidHandler();
        if (!inventoryHandler.getFluidInTank(0).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[0].isEmpty()) {
            FluidStack fluidStack = inventoryHandler.getFluidInTank(0);
            int displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[0].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[0];
                displayAmount = 0;
            }
            AABB bounds = new AABB(0.0625, 0.078125, 0.0625, 0.9375, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(0) * 0.78125, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(0), 0.007f, tile.getDrawerOptions(), bounds, false, false);
        }
    }

    private void render2Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, FluidDrawerTile tile) {
        AABB bounds;
        int displayAmount;
        FluidStack fluidStack;
        BigFluidHandler inventoryHandler = tile.getFluidHandler();
        if (!inventoryHandler.getFluidInTank(0).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[0].isEmpty()) {
            fluidStack = inventoryHandler.getFluidInTank(0);
            displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[0].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[0];
                displayAmount = 0;
            }
            bounds = new AABB(0.0625, 0.078125, 0.0625, 0.9375, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(0) * 0.34375, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(0), 0.007f, tile.getDrawerOptions(), bounds, false, true);
        }
        if (!inventoryHandler.getFluidInTank(1).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[1].isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.5, 0.0);
            fluidStack = inventoryHandler.getFluidInTank(1);
            displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[1].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[1];
                displayAmount = 0;
            }
            bounds = new AABB(0.0625, 0.078125, 0.0625, 0.9375, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(1) * 0.34375, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(1), 0.007f, tile.getDrawerOptions(), bounds, false, true);
            matrixStack.m_85849_();
        }
    }

    private void render4Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, FluidDrawerTile tile) {
        AABB bounds;
        int displayAmount;
        FluidStack fluidStack;
        BigFluidHandler inventoryHandler = tile.getFluidHandler();
        if (!inventoryHandler.getFluidInTank(0).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[0].isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.0, 0.0);
            fluidStack = inventoryHandler.getFluidInTank(0);
            displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[0].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[0];
                displayAmount = 0;
            }
            bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(0) * 0.34375, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(0), 0.007f, tile.getDrawerOptions(), bounds, true, true);
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getFluidInTank(1).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[1].isEmpty()) {
            matrixStack.m_85836_();
            fluidStack = inventoryHandler.getFluidInTank(1);
            displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[1].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[1];
                displayAmount = 0;
            }
            bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(1) * 0.34375, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(1), 0.007f, tile.getDrawerOptions(), bounds, true, true);
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getFluidInTank(2).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[2].isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.0);
            fluidStack = inventoryHandler.getFluidInTank(2);
            displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[2].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[2];
                displayAmount = 0;
            }
            bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(2) * 0.34375, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(2), 0.007f, tile.getDrawerOptions(), bounds, true, true);
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getFluidInTank(3).isEmpty() || tile.isLocked() && !inventoryHandler.getFilterStack()[3].isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.5, 0.0);
            fluidStack = inventoryHandler.getFluidInTank(3);
            displayAmount = fluidStack.getAmount();
            if (fluidStack.isEmpty() && tile.isLocked() && !inventoryHandler.getFilterStack()[3].isEmpty()) {
                fluidStack = inventoryHandler.getFilterStack()[3];
                displayAmount = 0;
            }
            bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)inventoryHandler.getTankCapacity(3) * 0.34375, 0.9375);
            FluidDrawerRenderer.renderFluidStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, fluidStack, displayAmount, inventoryHandler.getTankCapacity(3), 0.007f, tile.getDrawerOptions(), bounds, true, true);
            matrixStack.m_85849_();
        }
    }
}

