/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.promoter.api.InfoFetcher;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.screen.AdScreen;
import dev.ftb.mods.promoter.screen.RemoteTexture;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScreenInitEvent {
    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (!(event.getScreen() instanceof JoinMultiplayerScreen)) {
            return;
        }
        for (GuiEventListener guiEventListener : event.getListenersList()) {
            if (!(guiEventListener instanceof ServerSelectionList)) continue;
            ServerSelectionList selectionList = (ServerSelectionList)guiEventListener;
            for (ServerSelectionList.Entry child : selectionList.m_6702_()) {
                if (!(child instanceof ServerPromotionEntry)) continue;
                return;
            }
            if (InfoFetcher.get().getPromotions().isEmpty()) {
                return;
            }
            selectionList.m_6702_().add(0, new ServerPromotionEntry(event.getScreen()));
        }
    }

    public static boolean renderAnnouncement(PoseStack stack, int x, int y, int width, String announcement, @Nullable List<Component> tooltipLines, int mouseX, int mouseY) {
        announcement = announcement.toUpperCase();
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(announcement);
        float textX = (float)(x + width) - (float)textWidth * 0.6f - 12.0f;
        int textY = y - 1;
        int borderSize = 1;
        int paddingX = 3;
        int paddingY = 2;
        int textHeight = 8;
        stack.m_85836_();
        stack.m_85837_((double)textX, (double)textY, 100.0);
        stack.m_85841_(0.6f, 0.6f, 0.6f);
        GuiComponent.m_93172_((PoseStack)stack, (int)(-paddingX - borderSize), (int)(-paddingY - borderSize), (int)(textWidth + paddingX + borderSize), (int)(textHeight + paddingY + borderSize), (int)-2137632222);
        GuiComponent.m_93172_((PoseStack)stack, (int)(-paddingX), (int)(-paddingY), (int)(textWidth + paddingX), (int)(textHeight + paddingY), (int)-1144769);
        GuiComponent.m_93236_((PoseStack)stack, (Font)font, (String)announcement, (int)0, (int)0, (int)0xFFFFFF);
        stack.m_85849_();
        boolean overAnnouncement = false;
        if (tooltipLines != null && !tooltipLines.isEmpty() && (float)mouseX >= textX - (float)paddingX && (float)mouseX <= textX + (float)(textWidth + paddingX * 2) * 0.6f && mouseY >= textY && mouseY <= textY + textHeight) {
            overAnnouncement = true;
        }
        return overAnnouncement;
    }

    private static class ServerPromotionEntry
    extends ServerSelectionList.LANHeader {
        final List<EntryOption> options = new ArrayList<EntryOption>();
        private final Screen parent;

        public ServerPromotionEntry(Screen screen) {
            this.parent = screen;
            List<PromoData> promotions = InfoFetcher.get().getPromotions();
            if (promotions.isEmpty()) {
                return;
            }
            for (PromoData promotion : promotions.subList(0, Math.min(2, promotions.size()))) {
                this.options.add(new EntryOption(this, promotion, new RemoteTexture(URI.create(promotion.logo()), promotion.uuid().toString() + promotion.logoVersion(), Minecraft.m_91087_().m_91097_())));
            }
        }

        public Component m_142172_() {
            return Component.m_237119_();
        }

        public boolean m_6375_(double p_331676_, double p_330254_, int p_331536_) {
            Minecraft.m_91087_().m_91152_((Screen)new AdScreen(this.parent));
            return false;
        }

        public void m_6311_(PoseStack stack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int halfWidth = width / 2;
            if (this.m_5953_(mouseX, mouseY)) {
                GuiComponent.m_93172_((PoseStack)stack, (int)(left - 2), (int)top, (int)(left + width - 4), (int)(top + height), (int)0x30FFFFFF);
            }
            int leftOffset = 0;
            for (EntryOption option : this.options) {
                option.render(stack, left + leftOffset, top, mouseX, mouseY, this.options.size() == 1 ? width : halfWidth, height);
                leftOffset += halfWidth;
            }
            leftOffset = 0;
            for (EntryOption option : this.options) {
                option.renderToolTips(stack, left + leftOffset, top, mouseX, mouseY, this.options.size() == 1 ? width : halfWidth, height);
                leftOffset += halfWidth;
            }
        }
    }

    private static final class EntryOption {
        private final ServerPromotionEntry parent;
        private final PromoData data;
        private final RemoteTexture texture;
        private final List<Component> entryTooltipLines;
        private final List<Component> announcementTooltipLines;
        boolean isOverAnnouncement = false;

        private EntryOption(ServerPromotionEntry parent, PromoData data, RemoteTexture texture) {
            this.parent = parent;
            this.data = data;
            this.texture = texture;
            this.announcementTooltipLines = this.createTooltipLines(data.announcementTooltip());
            this.entryTooltipLines = this.createTooltipLines(data.tooltip());
        }

        private List<Component> createTooltipLines(@Nullable String tooltip) {
            if (tooltip == null || tooltip.isEmpty()) {
                return Collections.emptyList();
            }
            String[] lines = tooltip.split("\n");
            ArrayList<Component> components = new ArrayList<Component>();
            for (String line : lines) {
                components.add((Component)Component.m_237113_((String)line));
            }
            return components;
        }

        public void render(PoseStack stack, int x, int y, int mouseX, int mouseY, int width, int height) {
            GuiComponent.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)this.data.name(), (int)(x + 35), (int)(y + 2), (int)0xFFFFFF);
            if (this.data.lineOneSubtitle() != null && !this.data.lineOneSubtitle().isEmpty()) {
                stack.m_85836_();
                stack.m_85837_((double)(x + 35), (double)(y + 14), 0.0);
                stack.m_85841_(0.75f, 0.75f, 0.75f);
                GuiComponent.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)this.data.lineOneSubtitle(), (int)0, (int)0, (int)-1291845633);
                if (this.data.lineTwoSubtitle() != null && !this.data.lineTwoSubtitle().isEmpty()) {
                    stack.m_85837_(0.0, 12.0, 0.0);
                    GuiComponent.m_93236_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)this.data.lineTwoSubtitle(), (int)0, (int)0, (int)-1291845633);
                }
                stack.m_85849_();
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture.getTextureLocation());
            GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)(y + 1), (float)0.0f, (float)0.0f, (int)30, (int)30, (int)30, (int)30);
            if (this.data.announcement() != null && !this.data.announcement().isEmpty()) {
                this.isOverAnnouncement = ScreenInitEvent.renderAnnouncement(stack, x, y, width, this.data.announcement(), this.announcementTooltipLines, mouseX, mouseY);
            }
        }

        public void renderToolTips(PoseStack stack, int x, int y, int mouseX, int mouseY, int width, int height) {
            if (!this.entryTooltipLines.isEmpty() && !this.isOverAnnouncement && mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height) {
                this.parent.parent.m_169388_(stack, this.entryTooltipLines, Optional.empty(), mouseX, mouseY + 10);
            }
            if (this.isOverAnnouncement) {
                this.parent.parent.m_169388_(stack, this.announcementTooltipLines, Optional.empty(), mouseX, mouseY + 10);
            }
        }
    }
}

