/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.promoter.api.InfoFetcher;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.integrations.Integrations;
import dev.ftb.mods.promoter.screen.RemoteTexture;
import dev.ftb.mods.promoter.screen.ScreenInitEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class AdScreen
extends Screen {
    private final List<PromoDataHolder> promos = new ArrayList<PromoDataHolder>();
    private Screen parent;
    private Button buttonLeft = null;
    private Button buttonRight = null;

    public AdScreen(Screen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        for (PromoData promo : InfoFetcher.get().getPromotions()) {
            this.promos.add(new PromoDataHolder(promo));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int middle = this.f_96543_ / 2;
        int sectionOneLeft = middle - 154 - 2;
        this.m_142416_((GuiEventListener)new ButtonBuilder((Component)Component.m_237113_((String)"X"), b -> this.m_7379_()).pos(sectionOneLeft + 308 - 18, 3).size(14, 14).build());
        int buttonWidth = 148;
        int horizontalShift = this.promos.size() == 1 ? middle - 77 : sectionOneLeft;
        for (PromoDataHolder promotion : this.promos) {
            ButtonBuilder button = new ButtonBuilder((Component)Component.m_237113_((String)promotion.getData().buttonText()), b -> {
                boolean result = Integrations.clickAction(promotion.getData(), this);
                String url = promotion.getData().url();
                if (!result && url != null && !url.isEmpty()) {
                    Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(success -> {
                        if (success) {
                            Util.m_137581_().m_137646_("https://aka.ms/JavaAccountSettings");
                        }
                        Minecraft.m_91087_().m_91152_((Screen)this);
                    }, (Component)Component.m_237113_((String)promotion.getData().name()), url, true));
                }
            }).pos(horizontalShift + 3, this.f_96544_ - 30).width(buttonWidth);
            String buttonTooltip = promotion.data.buttonTooltip();
            if (buttonTooltip != null && !buttonTooltip.isEmpty()) {
                button.tooltip(this, Collections.singletonList(Component.m_237113_((String)buttonTooltip)));
            }
            Button btn = button.build();
            if (this.buttonLeft == null) {
                this.buttonLeft = btn;
            } else {
                this.buttonRight = btn;
            }
            this.m_142416_((GuiEventListener)btn);
            horizontalShift += 156;
        }
    }

    public void m_7379_() {
        if (this.parent != null) {
            Minecraft.m_91087_().m_91152_(this.parent);
            return;
        }
        super.m_7379_();
    }

    public void m_7333_(PoseStack guiGraphics) {
        super.m_7333_(guiGraphics);
        int availableWidth = AdScreen.getAvailableWidth(this.promos);
        int middle = this.f_96543_ / 2;
        int horizontalShift = middle - 2 - availableWidth * this.promos.size() / 2;
        for (PromoDataHolder promotion : this.promos) {
            this.renderSectionBackground(promotion, guiGraphics, horizontalShift, availableWidth);
            horizontalShift += availableWidth + 2;
        }
    }

    public void m_6305_(PoseStack guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(guiGraphics);
        super.m_6305_(guiGraphics, mouseX, mouseY, partialTick);
        int availableWidth = AdScreen.getAvailableWidth(this.promos);
        int middle = this.f_96543_ / 2 - 2;
        int horizontalShift = middle - availableWidth * this.promos.size() / 2;
        for (PromoDataHolder promotion : this.promos) {
            boolean isLeft = promotion == this.promos.get(0);
            this.renderSection(promotion, guiGraphics, horizontalShift, availableWidth, mouseX, mouseY, isLeft ? this.buttonLeft : this.buttonRight);
            horizontalShift += availableWidth + 2;
        }
    }

    private static int getAvailableWidth(List<PromoDataHolder> promos) {
        return promos.size() > 1 ? 154 : 308;
    }

    private void renderSection(PromoDataHolder holder, PoseStack poseStack, int x, int width, int mouseX, int mouseY, Button btn) {
        PromoData data = holder.getData();
        RenderSystem.m_157456_((int)0, (ResourceLocation)holder.getLogo().getTextureLocation());
        AdScreen.m_93133_((PoseStack)poseStack, (int)(x + width / 2 - 15), (int)10, (float)0.0f, (float)0.0f, (int)30, (int)30, (int)30, (int)30);
        AdScreen.m_93208_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)data.name(), (int)(x + width / 2), (int)50, (int)0xFFFFFF);
        MultiLineLabel description = holder.getDescription();
        description.m_6516_(poseStack, x + 8, 70, 10, 0xFFFFFF);
        String announcement = data.announcement();
        if (announcement != null && !announcement.isEmpty() && !btn.m_198029_()) {
            ScreenInitEvent.renderAnnouncement(poseStack, x, this.f_96544_ - 30, width, announcement, null, mouseX, mouseY);
        }
    }

    private void renderSectionBackground(PromoDataHolder holder, PoseStack stack, int x, int width) {
        AdScreen.m_93172_((PoseStack)stack, (int)x, (int)0, (int)(x + width), (int)this.f_96544_, (int)0x9FFFFFF);
        AdScreen.m_93172_((PoseStack)stack, (int)(x + 2), (int)0, (int)(x + width - 2), (int)this.f_96544_, (int)Integer.MIN_VALUE);
    }

    private static class PromoDataHolder {
        private final PromoData data;
        private final RemoteTexture logo;
        private final MultiLineLabel description;

        public PromoDataHolder(PromoData data) {
            this.data = data;
            this.logo = new RemoteTexture(URI.create(data.logo()), data.uuid().toString() + data.logoVersion(), Minecraft.m_91087_().m_91097_());
            this.description = MultiLineLabel.m_94341_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)Component.m_237113_((String)data.description()), (int)140);
        }

        public PromoData getData() {
            return this.data;
        }

        public RemoteTexture getLogo() {
            return this.logo;
        }

        public MultiLineLabel getDescription() {
            return this.description;
        }
    }

    private static class ButtonBuilder {
        private int x = 0;
        private int y = 0;
        private int width = 150;
        private int height = 20;
        private Component text;
        private Button.OnPress onPress;
        private Button.OnTooltip onTooltip = Button.f_93716_;

        public ButtonBuilder(Component text, Button.OnPress onPress) {
            this.text = text;
            this.onPress = onPress;
        }

        public ButtonBuilder x(int x) {
            this.x = x;
            return this;
        }

        public ButtonBuilder y(int y) {
            this.y = y;
            return this;
        }

        public ButtonBuilder width(int width) {
            this.width = width;
            return this;
        }

        public ButtonBuilder height(int height) {
            this.height = height;
            return this;
        }

        public ButtonBuilder bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public ButtonBuilder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public ButtonBuilder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public ButtonBuilder tooltip(Screen screen, List<Component> text) {
            this.onTooltip = (button, stack, x, y) -> screen.m_96597_(stack, text, x, y);
            return this;
        }

        public Button build() {
            return new Button(this.x, this.y, this.width, this.height, this.text, this.onPress, this.onTooltip);
        }
    }
}

