/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.TeamPropertyArgument;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class FTBTeamsCommands {
    private Predicate<CommandSourceStack> requiresOPorSP() {
        return source -> source.m_81377_().m_129792_() || source.m_6761_(2);
    }

    private RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> teamArg() {
        return Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create());
    }

    private String string(CommandContext<?> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    private boolean hasNoParty(CommandSourceStack source) {
        if (source.m_81373_() instanceof ServerPlayer) {
            Team team = FTBTeamsAPI.getPlayerTeam(source.m_81373_().m_20148_());
            return team != null && !team.getType().isParty();
        }
        return false;
    }

    private boolean hasParty(CommandSourceStack source, TeamRank rank) {
        if (source.m_81373_() instanceof ServerPlayer) {
            Team team = FTBTeamsAPI.getPlayerTeam(source.m_81373_().m_20148_());
            return team != null && team.getType().isParty() && team.getHighestRank(source.m_81373_().m_20148_()).is(rank);
        }
        return false;
    }

    private Team team(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return FTBTeamsAPI.getPlayerTeam(player);
    }

    private Team teamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TeamArgument.get(context, "team");
    }

    private Team teamArg(CommandContext<CommandSourceStack> context, TeamType type) throws CommandSyntaxException {
        Team team = this.teamArg(context);
        if (team.getType() != type) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)team.getName());
        }
        return team;
    }

    private ServerTeam serverTeamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return (ServerTeam)this.teamArg(context, TeamType.SERVER);
    }

    private PartyTeam partyTeamArg(CommandContext<CommandSourceStack> context, TeamRank rank) throws CommandSyntaxException {
        PartyTeam team = (PartyTeam)this.teamArg(context, TeamType.PARTY);
        if (rank != TeamRank.NONE && !team.getHighestRank(((CommandSourceStack)context.getSource()).m_81375_().m_20148_()).is(rank)) {
            throw TeamArgument.NOT_INVITED.create((Object)team.getName());
        }
        return team;
    }

    private PartyTeam team(CommandContext<CommandSourceStack> context, TeamRank rank) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (!(team instanceof PartyTeam)) {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        if (!team.getHighestRank(player.m_20148_()).is(rank)) {
            throw TeamArgument.CANT_EDIT.create((Object)team.getName());
        }
        return (PartyTeam)team;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbteams").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(this::hasNoParty)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManager.INSTANCE.createParty(((CommandSourceStack)ctx.getSource()).m_81375_(), this.string(ctx, "name")).getLeft()))).executes(ctx -> (Integer)TeamManager.INSTANCE.createParty(((CommandSourceStack)ctx.getSource()).m_81375_(), "").getLeft()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"join").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).join((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"deny_invite").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).denyInvite((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"leave").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> ((PartyTeam)this.team((CommandContext<CommandSourceStack>)ctx)).leave(((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"invite").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).invite(((CommandSourceStack)ctx.getSource()).m_81375_(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kick").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).kick((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer_ownership").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(Commands.m_82129_((String)"player_id", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player_id")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer_ownership_for").requires(this.requiresOPorSP())).then(this.teamArg().then(Commands.m_82129_((String)"player_id", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player_id"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"settings").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"settings_for").requires(this.requiresOPorSP())).then(this.teamArg().then(((RequiredArgumentBuilder)Commands.m_82129_((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.teamArg((CommandContext<CommandSourceStack>)ctx, TeamType.PARTY).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.teamArg((CommandContext<CommandSourceStack>)ctx, TeamType.PARTY).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), "")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"allies").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).addAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).removeAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).listAllies((CommandSourceStack)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"server").requires(this.requiresOPorSP())).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManager.INSTANCE.createServer((CommandSourceStack)ctx.getSource(), this.string(ctx, "name")).getLeft())))).then(Commands.m_82127_((String)"delete").then(this.teamArg().executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).delete((CommandSourceStack)ctx.getSource()))))).then(Commands.m_82127_((String)"settings").then(this.teamArg().then(((RequiredArgumentBuilder)Commands.m_82129_((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))))).then(Commands.m_82127_((String)"msg").then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx).msg(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"text")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").then(Commands.m_82127_((String)"server_id").executes(ctx -> this.serverId((CommandSourceStack)ctx.getSource())))).then(this.teamArg().executes(ctx -> this.teamArg((CommandContext<CommandSourceStack>)ctx).info((CommandSourceStack)ctx.getSource())))).executes(ctx -> this.team((CommandContext<CommandSourceStack>)ctx).info((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), null))).then(Commands.m_82127_((String)"parties").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), TeamType.PARTY)))).then(Commands.m_82127_((String)"server_teams").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), TeamType.SERVER)))).then(Commands.m_82127_((String)"players").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), TeamType.PLAYER))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"force-disband").requires(source -> source.m_6761_(2))).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).forceDisband((CommandSourceStack)ctx.getSource())))));
        if (Platform.isDevelopmentEnvironment()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbteams_add_fake_player").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"profile", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.addFakePlayer(GameProfileArgument.m_94590_((CommandContext)ctx, (String)"profile")))));
        }
    }

    private int serverId(CommandSourceStack source) {
        MutableComponent component = Component.m_237113_((String)("Server ID: " + FTBTeamsAPI.getManager().getId()));
        component.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy"))));
        component.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, FTBTeamsAPI.getManager().getId().toString())));
        source.m_81354_((Component)component, false);
        return 1;
    }

    private int list(CommandSourceStack source, @Nullable TeamType type) {
        MutableComponent list = Component.m_237113_((String)"");
        boolean first = true;
        for (Team team : FTBTeamsAPI.getManager().getTeams()) {
            if (type != null && team.getType() != type) continue;
            if (first) {
                first = false;
            } else {
                list.m_130946_(", ");
            }
            list.m_7220_(team.getName());
        }
        source.m_81354_((Component)Component.m_237110_((String)"ftbteams.list", (Object[])new Object[]{first ? Component.m_237115_((String)"ftbteams.info.owner.none") : list}), false);
        return 1;
    }

    private int addFakePlayer(Collection<GameProfile> profiles) {
        for (GameProfile profile : profiles) {
            TeamManager.INSTANCE.playerLoggedIn(null, profile.getId(), profile.getName());
        }
        return 1;
    }
}

