/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.recipies;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.ftbsba.tools.recipies.FusingMachineRecipe;
import dev.ftb.ftbsba.tools.recipies.SuperCoolerRecipe;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FusingMachineRecipeSerializer
implements RecipeSerializer<FusingMachineRecipe> {
    public FusingMachineRecipe fromJson(ResourceLocation id, JsonObject json) {
        FusingMachineRecipe recipe = new FusingMachineRecipe(id, json.has("group") ? json.get("group").getAsString() : "");
        JsonArray ingredients = json.get("ingredients").getAsJsonArray();
        for (JsonElement e : ingredients) {
            recipe.ingredients.add(Ingredient.m_43917_((JsonElement)e));
        }
        JsonObject fluidResult = json.get("result").getAsJsonObject();
        recipe.fluidResult = FluidStackSerializer.deserialize((JsonElement)fluidResult);
        recipe.energyComponent = SuperCoolerRecipe.EnergyComponent.fromJson(json.get("energy"));
        return recipe;
    }

    @Nullable
    public FusingMachineRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        String groups = buf.m_130277_();
        FusingMachineRecipe recipe = new FusingMachineRecipe(recipeId, groups);
        List ingredients = buf.m_236845_(Ingredient::m_43940_);
        FluidStack fluidResult = FluidStack.readFromPacket((FriendlyByteBuf)buf);
        SuperCoolerRecipe.EnergyComponent energyComponent = SuperCoolerRecipe.EnergyComponent.fromNetwork(buf);
        recipe.ingredients = ingredients;
        recipe.fluidResult = fluidResult;
        recipe.energyComponent = energyComponent;
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buf, FusingMachineRecipe recipe) {
        buf.m_130070_(recipe.group);
        buf.m_236828_(recipe.ingredients, (buf1, ingredient) -> ingredient.m_43923_(buf1));
        recipe.fluidResult.writeToPacket(buf);
        recipe.energyComponent.toNetwork(buf);
    }

    public static class FluidStackSerializer {
        public static JsonElement serialize(FluidStack stack) {
            JsonObject o = new JsonObject();
            ResourceLocation fluidLookup = ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid());
            if (fluidLookup == null) {
                throw new RuntimeException("Fluid " + stack.getFluid() + " is not registered");
            }
            o.addProperty("fluid", fluidLookup.toString());
            o.addProperty("amount", (Number)stack.getAmount());
            return o;
        }

        public static FluidStack deserialize(JsonElement element) {
            JsonObject o = element.getAsJsonObject();
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(o.get("fluid").getAsString()));
            if (fluid == null) {
                throw new RuntimeException("Fluid " + o.get("fluid").getAsString() + " is not registered");
            }
            return new FluidStack(fluid, o.get("amount").getAsInt());
        }
    }
}

