/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.ftbsba.tools.ToolsTags;
import dev.ftb.ftbsba.tools.recipies.CrookDropsResult;
import dev.ftb.ftbsba.tools.recipies.ToolsRecipeCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CrookModifier
extends LootModifier {
    public static final Codec<CrookModifier> CODEC = RecordCodecBuilder.create(builder -> CrookModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, CrookModifier::new));

    public CrookModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        ItemStack crook = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (!(entity instanceof Player && crook != null && blockState != null && crook.m_204117_(ToolsTags.Items.CROOKS) && ToolsRecipeCache.crookable(blockState))) {
            return list;
        }
        CrookDropsResult crookDrops = ToolsRecipeCache.getCrookDrops(entity.f_19853_, new ItemStack((ItemLike)blockState.m_60734_()));
        if (crookDrops.items().size() > 0) {
            RandomSource random = context.m_230907_();
            List collect = crookDrops.items().stream().filter(itemWithChance -> (double)random.m_188501_() < itemWithChance.chance()).map(itemWithChance -> itemWithChance.item().m_41777_()).collect(Collectors.toList());
            Collections.shuffle(collect);
            list.clear();
            collect.stream().limit(crookDrops.max()).forEach(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

