/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.ftbsba.tools.recipies.CrookRecipe;
import dev.ftb.ftbsba.tools.recipies.ItemWithChance;
import java.util.ArrayList;
import java.util.Comparator;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CrookCategory
implements IRecipeCategory<CrookRecipe> {
    public static final RecipeType<CrookRecipe> TYPE = RecipeType.create((String)"ftbsba", (String)"crook_jei", CrookRecipe.class);
    public static final ResourceLocation BACKGROUND = new ResourceLocation("ftbsba", "textures/gui/crook_jei_background.png");
    private static final Comparator<ItemWithChance> COMPARATOR = (a, b) -> (int)(b.chance() * 100.0 - a.chance() * 100.0);
    private final IDrawableStatic background;

    public CrookCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 156, 78).setTextureSize(180, 78).build();
    }

    public RecipeType<CrookRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"ftbsba.jei.recipe.crook");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrookRecipe crookRecipe, IFocusGroup iFocusGroup) {
        ArrayList<ItemWithChance> itemWithChance = new ArrayList<ItemWithChance>(crookRecipe.results);
        itemWithChance.sort(COMPARATOR);
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addIngredients(crookRecipe.ingredient);
        for (int i = 0; i < itemWithChance.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 28 + i % 7 * 18, 5 + i / 7 * 24).addItemStack(itemWithChance.get(i).item());
        }
    }

    public void draw(CrookRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
        ArrayList<ItemWithChance> itemWithWeights = new ArrayList<ItemWithChance>(recipe.results);
        itemWithWeights.sort(COMPARATOR);
        int row = 0;
        for (int i = 0; i < itemWithWeights.size(); ++i) {
            if (i > 0 && i % 7 == 0) {
                ++row;
            }
            stack.m_85836_();
            stack.m_85837_((double)(36 + i % 7 * 18), (double)(23.5f + (float)(row * 24)), 100.0);
            stack.m_85841_(0.5f, 0.5f, 8000.0f);
            Gui.m_93208_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)(Math.round(itemWithWeights.get(i).chance() * 100.0) + "%"), (int)0, (int)0, (int)0xFFFFFF);
            stack.m_85849_();
        }
    }
}

