/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import dev.ftb.mods.ftbranks.api.PermissionValue;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class NumberPermissionValue
implements PermissionValue {
    public static final NumberPermissionValue ZERO = new NumberPermissionValue(0);
    public final Number value;
    private final Optional<Number> cachedValue;
    private final OptionalInt cachedInteger;
    private final OptionalLong cachedLong;
    private final OptionalDouble cachedDouble;

    public static NumberPermissionValue of(Number n) {
        return (n instanceof Long || n instanceof Integer) && n.longValue() == 0L ? ZERO : new NumberPermissionValue(n);
    }

    private NumberPermissionValue(Number n) {
        this.value = n;
        this.cachedValue = Optional.of(this.value);
        this.cachedInteger = OptionalInt.of(this.value.intValue());
        this.cachedLong = OptionalLong.of(this.value.longValue());
        this.cachedDouble = OptionalDouble.of(this.value.doubleValue());
    }

    @Override
    public Optional<Number> asNumber() {
        return this.cachedValue;
    }

    @Override
    public OptionalInt asInteger() {
        return this.cachedInteger;
    }

    @Override
    public OptionalLong asLong() {
        return this.cachedLong;
    }

    @Override
    public OptionalDouble asDouble() {
        return this.cachedDouble;
    }

    @Override
    public Optional<String> asString() {
        return Optional.of(this.value.toString());
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof NumberPermissionValue && this.value.equals(((NumberPermissionValue)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

