/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LocationTask
extends BooleanTask {
    public ResourceKey<Level> dimension = Level.f_46428_;
    public boolean ignoreDimension = false;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int w = 1;
    public int h = 1;
    public int d = 1;

    public LocationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.LOCATION;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
        nbt.m_128379_("ignore_dimension", this.ignoreDimension);
        nbt.m_128385_("position", new int[]{this.x, this.y, this.z});
        nbt.m_128385_("size", new int[]{this.w, this.h, this.d});
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
        this.ignoreDimension = nbt.m_128471_("ignore_dimension");
        int[] pos = nbt.m_128465_("position");
        if (pos.length == 3) {
            this.x = pos[0];
            this.y = pos[1];
            this.z = pos[2];
        }
        int[] size = nbt.m_128465_("size");
        if (pos.length == 3) {
            this.w = size[0];
            this.h = size[1];
            this.d = size[2];
        }
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(this.dimension.m_135782_());
        buffer.writeBoolean(this.ignoreDimension);
        buffer.m_130130_(this.x);
        buffer.m_130130_(this.y);
        buffer.m_130130_(this.z);
        buffer.m_130130_(this.w);
        buffer.m_130130_(this.h);
        buffer.m_130130_(this.d);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_());
        this.ignoreDimension = buffer.readBoolean();
        this.x = buffer.m_130242_();
        this.y = buffer.m_130242_();
        this.z = buffer.m_130242_();
        this.w = buffer.m_130242_();
        this.h = buffer.m_130242_();
        this.d = buffer.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("dim", this.dimension.m_135782_().toString(), v -> {
            this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(v));
        }, "minecraft:overworld");
        config.addBool("ignore_dim", this.ignoreDimension, v -> {
            this.ignoreDimension = v;
        }, false);
        config.addInt("x", this.x, v -> {
            this.x = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("y", this.y, v -> {
            this.y = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("z", this.z, v -> {
            this.z = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("w", this.w, v -> {
            this.w = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("h", this.h, v -> {
            this.h = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("d", this.d, v -> {
            this.d = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        int px;
        int py;
        if ((this.ignoreDimension || this.dimension == player.f_19853_.m_46472_()) && (py = Mth.m_14107_((double)player.m_20186_())) >= this.y && py < this.y + this.h && (px = Mth.m_14107_((double)player.m_20185_())) >= this.x && px < this.x + this.w) {
            int pz = Mth.m_14107_((double)player.m_20189_());
            return pz >= this.z && pz < this.z + this.d;
        }
        return false;
    }
}

