/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectFluidScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuestsCommon;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient
extends FTBQuestsCommon {
    public static KeyMapping KEY_QUESTS;

    @Override
    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::setup);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new QuestFileCacheReloader());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ThemeLoader());
        KEY_QUESTS = new KeyMapping("key.ftbquests.quests", InputConstants.Type.KEYSYM, -1, "key.categories.ftbquests");
        KeyMappingRegistry.register((KeyMapping)KEY_QUESTS);
        new FTBQuestsClientEventHandler().init();
    }

    private void setup(Minecraft minecraft) {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.STAGE_BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_1.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_3.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_5.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_7.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.AUX_SCREEN.get()});
        this.setTaskGuiProviders();
        this.setRewardGuiProviders();
    }

    @Override
    @Nullable
    public QuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    @Override
    public QuestFile getQuestFile(boolean isClient) {
        if (isClient) {
            QuestFile f = this.getClientQuestFile();
            if (f == null) {
                throw new NullPointerException("Client quest file not loaded!");
            }
            return f;
        }
        return ServerQuestFile.INSTANCE;
    }

    @Override
    public void setTaskGuiProviders() {
        TaskTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            c.defaultValue = ItemStack.f_41583_;
            c.value = ItemStack.f_41583_;
            new SelectItemStackScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(quest);
                    itemTask.item = ((ItemStack)c.value).m_41777_();
                    itemTask.item.m_41764_(1);
                    itemTask.count = ((ItemStack)c.value).m_41613_();
                    callback.accept(itemTask);
                }
            }).openGui();
        });
        TaskTypes.CHECKMARK.setGuiProvider((gui, quest, callback) -> {
            StringConfig c = new StringConfig(null);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                if (accepted) {
                    CheckmarkTask checkmarkTask = new CheckmarkTask(quest);
                    checkmarkTask.title = (String)c.value;
                    callback.accept(checkmarkTask);
                }
                gui.run();
            });
        });
        TaskTypes.FLUID.setGuiProvider((gui, quest, callback) -> {
            FluidConfig c = new FluidConfig(false);
            new SelectFluidScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    FluidTask fluidTask = new FluidTask(quest);
                    fluidTask.fluid = (Fluid)c.value;
                    callback.accept(fluidTask);
                }
            }).openGui();
        });
        TaskTypes.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(quest);
            task.dimension = Minecraft.m_91087_().f_91073_.m_46472_();
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
        TaskTypes.OBSERVATION.setGuiProvider((gui, quest, callback) -> {
            ObservationTask task = new ObservationTask(quest);
            HitResult patt5685$temp = Minecraft.m_91087_().f_91077_;
            if (patt5685$temp instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)patt5685$temp;
                Block block = Minecraft.m_91087_().f_91073_.m_8055_(bhr.m_82425_()).m_60734_();
                task.toObserve = Registry.f_122824_.m_7981_((Object)block).toString();
            }
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
        TaskTypes.LOCATION.setGuiProvider((gui, quest, callback) -> {
            BlockHitResult bhr;
            BlockEntity blockEntity;
            LocationTask task = new LocationTask(quest);
            Minecraft mc = Minecraft.m_91087_();
            HitResult patt6099$temp = mc.f_91077_;
            if (patt6099$temp instanceof BlockHitResult && (blockEntity = mc.f_91073_.m_7702_((bhr = (BlockHitResult)patt6099$temp).m_82425_())) instanceof StructureBlockEntity) {
                StructureBlockEntity structure = (StructureBlockEntity)blockEntity;
                BlockPos pos = structure.m_59902_();
                Vec3i size = structure.m_155805_();
                task.dimension = mc.f_91073_.m_46472_();
                task.x = pos.m_123341_() + blockEntity.m_58899_().m_123341_();
                task.y = pos.m_123342_() + blockEntity.m_58899_().m_123342_();
                task.z = pos.m_123343_() + blockEntity.m_58899_().m_123343_();
                task.w = Math.max(1, size.m_123341_());
                task.h = Math.max(1, size.m_123342_());
                task.d = Math.max(1, size.m_123343_());
                callback.accept(task);
                return;
            }
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
    }

    private static void openSetupGui(Runnable gui, Consumer<Task> callback, Task task) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        task.getConfig(task.createSubGroup(group));
        group.savedCallback = accepted -> {
            gui.run();
            if (accepted) {
                callback.accept(task);
            }
        };
        new EditConfigScreen(group).openGui();
    }

    @Override
    public void setRewardGuiProviders() {
        RewardTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            c.defaultValue = ItemStack.f_41583_;
            c.value = ItemStack.f_41583_;
            new SelectItemStackScreen(c, accepted -> {
                if (accepted) {
                    ItemStack copy = ((ItemStack)c.value).m_41777_();
                    copy.m_41764_(1);
                    ItemReward reward = new ItemReward(quest, copy);
                    reward.count = ((ItemStack)c.value).m_41613_();
                    callback.accept(reward);
                }
                gui.run();
            }).openGui();
        });
        RewardTypes.XP.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)100, (Object)100, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
        RewardTypes.XP_LEVELS.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)5, (Object)5, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public boolean isClientDataLoaded() {
        return ClientQuestFile.INSTANCE != null;
    }

    @Override
    public TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.self;
    }

    @Override
    public QuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    @Override
    public void openGui() {
        ClientQuestFile.openGui();
    }

    @Override
    public void openCustomIconGui(Player player, InteractionHand hand) {
        ImageConfig config = new ImageConfig();
        config.onClicked(MouseButton.LEFT, b -> {
            if (b) {
                if (((String)config.value).isEmpty()) {
                    player.m_21120_(hand).m_41749_("Icon");
                } else {
                    player.m_21120_(hand).m_41700_("Icon", (Tag)StringTag.m_129297_((String)((String)config.value)));
                }
                new SetCustomImageMessage(hand, (String)config.value).sendToServer();
            }
            Minecraft.m_91087_().m_91152_(null);
        });
    }

    @Override
    public void openScreenConfigGui(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)blockEntity;
            new EditConfigScreen(coreScreen.getConfigGroup(ClientQuestFile.INSTANCE.getData(coreScreen.getTeamId()))).setAutoclose(true).openGui();
        }
    }

    @Override
    public float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        List quads = model.m_213637_(state, face, RandomSource.m_216327_());
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).m_173410_();
            return new float[]{sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_()};
        }
        return new float[0];
    }
}

