/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.storage;

import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.storage.StorageManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BeltStorage {
    private final UUID uuid;
    private final BeltHandler inventory;
    private final LazyOptional<IItemHandler> optional;

    public BeltStorage(UUID uuidIn) {
        this.uuid = uuidIn;
        this.inventory = new BeltHandler(8);
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public BeltStorage(CompoundTag tag) {
        this.uuid = tag.m_128342_("uuid");
        this.inventory = new BeltHandler(8);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("uuid", this.uuid);
        tag.m_128359_("sUUID", this.uuid.toString());
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return tag;
    }

    private static class BeltHandler
    extends ItemStackHandler {
        public BeltHandler(int size) {
            super(size);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ForceBeltItem.filter(stack);
        }

        protected void onContentsChanged(int slot) {
            StorageManager.getBelts().m_77762_();
        }
    }
}

