/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.entities.AngryEndermanEntity;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class EnderTotEntity
extends EnderMan {
    private static final ResourceLocation TOT_HOLDABLE = new ResourceLocation("forcecraft", "endertot_holdable");

    public EnderTotEntity(EntityType<? extends EnderMan> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 8.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StareGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new PlaceBlockGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new TakeBlockGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((EnderTotEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.35f;
    }

    public boolean m_6162_() {
        return true;
    }

    public boolean m_32529_() {
        if (!this.f_19853_.m_5776_() && this.m_6084_() && !this.m_20072_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(32) - 16);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            return this.m_32543_(d0, d1, d2);
        }
        return false;
    }

    public void m_6667_(DamageSource cause) {
        Entity entitySource = cause.m_7640_();
        if (entitySource instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entitySource;
            if (!this.f_19853_.f_46443_) {
                int total = this.m_217043_().m_188503_(2) + 1;
                for (int i = 0; i < total; ++i) {
                    AngryEndermanEntity endermanEntity = (AngryEndermanEntity)((EntityType)ForceEntities.ANGRY_ENDERMAN.get()).m_20615_(this.f_19853_);
                    endermanEntity.m_7678_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0f, 0.0f);
                    endermanEntity.m_6710_(livingEntity);
                    this.f_19853_.m_7967_((Entity)endermanEntity);
                }
            }
        }
        super.m_6667_(cause);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    static class StareGoal
    extends Goal {
        private final EnderTotEntity endertot;
        private LivingEntity targetPlayer;

        public StareGoal(EnderTotEntity endertotIn) {
            this.endertot = endertotIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.targetPlayer = this.endertot.m_5448_();
            if (!(this.targetPlayer instanceof Player)) {
                return false;
            }
            double d0 = this.targetPlayer.m_20280_((Entity)this.endertot);
            return !(d0 > 256.0) && this.endertot.m_32534_((Player)this.targetPlayer);
        }

        public void m_8056_() {
            this.endertot.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.endertot.m_21563_().m_24946_(this.targetPlayer.m_20185_(), this.targetPlayer.m_20188_(), this.targetPlayer.m_20189_());
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EnderTotEntity endertot;

        public PlaceBlockGoal(EnderTotEntity totEntity) {
            this.endertot = totEntity;
        }

        public boolean m_8036_() {
            if (this.endertot.m_32530_() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.endertot.f_19853_, (Entity)this.endertot)) {
                return false;
            }
            return this.endertot.m_217043_().m_188503_(2000) == 0;
        }

        public void m_8037_() {
            RandomSource random = this.endertot.m_217043_();
            Level world = this.endertot.f_19853_;
            int i = Mth.m_14107_((double)(this.endertot.m_20185_() - 1.0 + random.m_188500_() * 2.0));
            int j = Mth.m_14107_((double)(this.endertot.m_20186_() + random.m_188500_() * 2.0));
            int k = Mth.m_14107_((double)(this.endertot.m_20189_() - 1.0 + random.m_188500_() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos belowPos = blockpos.m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            BlockState carriedState = this.endertot.m_32530_();
            if (carriedState != null && this.canPlaceBlock(world, blockpos, carriedState = Block.m_49931_((BlockState)carriedState, (LevelAccessor)this.endertot.f_19853_, (BlockPos)blockpos), blockstate, belowState, belowPos) && !ForgeEventFactory.onBlockPlace((Entity)this.endertot, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)belowPos), (Direction)Direction.UP)) {
                world.m_7731_(blockpos, carriedState, 3);
                this.endertot.m_32521_(null);
            }
        }

        private boolean canPlaceBlock(Level level, BlockPos p_32560_, BlockState p_32561_, BlockState p_32562_, BlockState p_32563_, BlockPos p_32564_) {
            return p_32562_.m_60795_() && !p_32563_.m_60795_() && !p_32563_.m_60713_(Blocks.f_50752_) && !p_32563_.m_204336_(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_32563_.m_60838_((BlockGetter)level, p_32564_) && p_32561_.m_60710_((LevelReader)level, p_32560_) && level.m_45933_((Entity)this.endertot, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)p_32560_))).isEmpty();
        }
    }

    static class TakeBlockGoal
    extends Goal {
        private final EnderTotEntity endertot;

        public TakeBlockGoal(EnderTotEntity endertotIn) {
            this.endertot = endertotIn;
        }

        public boolean m_8036_() {
            if (this.endertot.m_32530_() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.endertot.f_19853_, (Entity)this.endertot)) {
                return false;
            }
            return this.endertot.m_217043_().m_188503_(20) == 0;
        }

        public void m_8037_() {
            RandomSource random = this.endertot.m_217043_();
            Level world = this.endertot.f_19853_;
            int i = Mth.m_14107_((double)(this.endertot.m_20185_() - 2.0 + random.m_188500_() * 4.0));
            int j = Mth.m_14107_((double)(this.endertot.m_20186_() + random.m_188500_() * 3.0));
            int k = Mth.m_14107_((double)(this.endertot.m_20189_() - 2.0 + random.m_188500_() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.m_8055_(blockpos);
            Vec3 vector3d = new Vec3((double)Mth.m_14107_((double)this.endertot.m_20185_()) + 0.5, (double)j + 0.5, (double)Mth.m_14107_((double)this.endertot.m_20189_()) + 0.5);
            Vec3 vector3d1 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockHitResult = world.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.endertot));
            boolean flag = blockHitResult.m_82425_().equals((Object)blockpos);
            if (blockstate.m_204336_(ForceTags.ENDERTOT_HOLDABLE) && flag) {
                world.m_7471_(blockpos, false);
                this.endertot.m_32521_(blockstate.m_60734_().m_49966_());
            }
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EnderTotEntity endertot;
        private Player player;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public FindPlayerGoal(EnderTotEntity enderTotIn, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((Mob)enderTotIn, Player.class, 10, false, false, p_i241912_2_);
            this.endertot = enderTotIn;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(livingEntity -> enderTotIn.m_32534_((Player)livingEntity));
        }

        public boolean m_8036_() {
            this.player = this.endertot.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.endertot);
            return this.player != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.endertot.m_32533_();
        }

        public void m_8041_() {
            this.player = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.player != null) {
                if (!this.endertot.m_32534_(this.player)) {
                    return false;
                }
                this.endertot.m_21391_((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.endertot, this.f_26050_) || super.m_8045_();
        }

        public void m_8037_() {
            if (this.endertot.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.player;
                    this.player = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.endertot.m_20159_()) {
                    if (this.endertot.m_32534_((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.endertot) < 16.0) {
                            this.endertot.m_32529_();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.endertot) > 128.0 && this.teleportTime++ >= 30 && this.endertot.m_32500_((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

