/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.blocks.torch.TimeTorchBlock;
import com.mrbysco.forcecraft.blocks.torch.WallTimeTorchBlock;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TimeTorchBlockEntity
extends BlockEntity {
    private final List<BlockPos> positionList = new ArrayList<BlockPos>();
    private int speed;

    public TimeTorchBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.speed = (Integer)ConfigHandler.COMMON.timeTorchAmount.get();
        this.initializePositions();
    }

    public TimeTorchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ForceRegistry.TIME_TORCH_BLOCK_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TimeTorchBlockEntity timeTorch) {
        int rate = (Integer)ConfigHandler.COMMON.timeTorchRate.get();
        if (rate > 0 && level.m_46467_() % (long)rate == 0L) {
            timeTorch.tickNeighbor();
        }
    }

    private void tickNeighbor() {
        this.positionList.forEach(this::tickBlock);
    }

    private void initializePositions() {
        this.positionList.clear();
        this.positionList.addAll(BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-1, -1, -1), (BlockPos)this.f_58858_.m_7918_(1, 1, 1)).map(BlockPos::m_7949_).toList());
    }

    private void tickBlock(@Nonnull BlockPos pos) {
        if (pos.equals((Object)this.m_58899_()) || !this.f_58857_.isAreaLoaded(pos, 1)) {
            return;
        }
        BlockState blockState = this.f_58857_.m_8055_(pos);
        if (blockState != null) {
            BlockEntity blockEntity;
            Block block = blockState.m_60734_();
            if (block == null || block instanceof LiquidBlock || block instanceof TimeTorchBlock || block instanceof WallTimeTorchBlock || block == Blocks.f_50016_) {
                return;
            }
            if (block.m_6724_(blockState) && !this.f_58857_.f_46443_) {
                for (int i = 0; i < this.speed && this.m_58904_().m_8055_(pos) == blockState; ++i) {
                    if (!this.m_58904_().f_46441_.m_188499_()) continue;
                    block.m_213898_(blockState, (ServerLevel)this.f_58857_, pos, this.f_58857_.f_46441_);
                }
            }
            if ((blockEntity = this.f_58857_.m_7702_(pos)) != null) {
                for (int i = 0; i < this.speed && !blockEntity.m_58901_(); ++i) {
                    BlockEntityTicker ticker = blockState.m_155944_(this.f_58857_, blockEntity.m_58903_());
                    if (ticker == null) continue;
                    ticker.m_155252_(this.f_58857_, pos, blockEntity.m_58900_(), blockEntity);
                }
            }
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Speed", this.speed);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Speed")) {
            this.speed = nbt.m_128451_("Speed");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }
}

