/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.variables;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageVariablesScreen
extends Screen {
    protected Consumer<List<Variable>> callback;
    protected ScrollArea variableListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton setValueButton;
    protected ExtendedButton deleteVariableButton;
    protected ExtendedButton addVariableButton;
    protected ExtendedButton toggleResetOnLaunchButton;

    public ManageVariablesScreen(@NotNull Consumer<List<Variable>> callback) {
        super((Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage", new Object[0]));
        this.callback = callback;
        this.updateVariableScrollArea();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addVariableButton = new ExtendedButton(0, 0, 220, 20, (Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.add_variable", new Object[0]), button -> {
            TextInputScreen s = new TextInputScreen((Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.add_variable.input_name", new Object[0]), CharacterFilter.buildOnlyLowercaseFileNameFilter(), call -> {
                if (call != null && !VariableHandler.variableExists(call)) {
                    VariableHandler.setVariable(call, "");
                    this.updateVariableScrollArea();
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        });
        this.m_7787_((GuiEventListener)this.addVariableButton);
        UIBase.applyDefaultWidgetSkinTo(this.addVariableButton);
        this.setValueButton = new ExtendedButton(0, 0, 220, 20, (Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.set_value", new Object[0]), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                TextInputScreen s = new TextInputScreen((Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.set_value", new Object[0]), null, call -> {
                    if (call != null) {
                        e.variable.setValue((String)call);
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                });
                s.setText(e.variable.getValue());
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_7787_((GuiEventListener)this.setValueButton);
        UIBase.applyDefaultWidgetSkinTo(this.setValueButton);
        this.deleteVariableButton = new ExtendedButton(0, 0, 220, 20, (Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.delete_variable", new Object[0]), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        VariableHandler.removeVariable(e.variable.getName());
                        this.updateVariableScrollArea();
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.variables.manage.delete_variable.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_7787_((GuiEventListener)this.deleteVariableButton);
        UIBase.applyDefaultWidgetSkinTo(this.deleteVariableButton);
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> resetOnLaunchDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch", false);
        this.toggleResetOnLaunchButton = new ExtendedButton(0, 0, 220, 20, (Component)Components.empty(), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.variable.setResetOnLaunch(!e.variable.isResetOnLaunch());
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null).setLabelSupplier(consumes -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> enabledDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch");
                enabledDisabled.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(e.variable.isResetOnLaunch()));
                return enabledDisabled.getCycleComponent();
            }
            return resetOnLaunchDisabled.getCycleComponent();
        });
        this.m_7787_((GuiEventListener)this.toggleResetOnLaunchButton);
        UIBase.applyDefaultWidgetSkinTo(this.toggleResetOnLaunchButton);
        this.doneButton = new ExtendedButton(0, 0, 220, 20, (Component)Components.translatable("fancymenu.guicomponents.done", new Object[0]), button -> this.callback.accept(VariableHandler.getVariables()));
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void m_7379_() {
        this.callback.accept(VariableHandler.getVariables());
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        ManageVariablesScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        this.f_96547_.m_92889_(pose, (Component)titleComp, 20.0f, 20.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.f_96547_.m_92889_(pose, (Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.variables", new Object[0]), 20.0f, 50.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.variableListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.variableListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.variableListScrollArea.setX(20, true);
        this.variableListScrollArea.setY(65, true);
        this.variableListScrollArea.render(pose, mouseX, mouseY, partial);
        int buttonWidth = this.f_96543_ - 20 - (this.variableListScrollArea.getXWithBorder() + (this.variableListScrollArea.getWidthWithBorder() + 20));
        if (buttonWidth < 150) {
            buttonWidth = 150;
        }
        if (buttonWidth > 220) {
            buttonWidth = 220;
        }
        this.doneButton.m_93674_(buttonWidth);
        this.doneButton.setX(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.setY(this.f_96544_ - 20 - 20);
        this.doneButton.m_6305_(pose, mouseX, mouseY, partial);
        this.toggleResetOnLaunchButton.m_93674_(buttonWidth);
        this.toggleResetOnLaunchButton.setX(this.f_96543_ - 20 - this.toggleResetOnLaunchButton.m_5711_());
        this.toggleResetOnLaunchButton.setY(this.doneButton.getY() - 15 - 20);
        this.toggleResetOnLaunchButton.m_6305_(pose, mouseX, mouseY, partial);
        this.deleteVariableButton.m_93674_(buttonWidth);
        this.deleteVariableButton.setX(this.f_96543_ - 20 - this.deleteVariableButton.m_5711_());
        this.deleteVariableButton.setY(this.toggleResetOnLaunchButton.getY() - 5 - 20);
        this.deleteVariableButton.m_6305_(pose, mouseX, mouseY, partial);
        this.setValueButton.m_93674_(buttonWidth);
        this.setValueButton.setX(this.f_96543_ - 20 - this.setValueButton.m_5711_());
        this.setValueButton.setY(this.deleteVariableButton.getY() - 5 - 20);
        this.setValueButton.m_6305_(pose, mouseX, mouseY, partial);
        this.addVariableButton.m_93674_(buttonWidth);
        this.addVariableButton.setX(this.f_96543_ - 20 - this.addVariableButton.m_5711_());
        this.addVariableButton.setY(this.setValueButton.getY() - 15 - 20);
        this.addVariableButton.m_6305_(pose, mouseX, mouseY, partial);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    @Nullable
    protected VariableScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.variableListScrollArea.getEntries()) {
            VariableScrollEntry s;
            if (!(e instanceof VariableScrollEntry) || !(s = (VariableScrollEntry)e).isSelected()) continue;
            return s;
        }
        return null;
    }

    protected void updateVariableScrollArea() {
        this.variableListScrollArea.clearEntries();
        for (Variable v : VariableHandler.getVariables()) {
            VariableScrollEntry e = new VariableScrollEntry(this.variableListScrollArea, v, entry -> {});
            this.variableListScrollArea.addEntry(e);
        }
        if (this.variableListScrollArea.getEntries().isEmpty()) {
            this.variableListScrollArea.addEntry(new TextScrollAreaEntry(this.variableListScrollArea, (Component)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.no_variables", new Object[0]).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt())), entry -> {}));
        }
    }

    public static class VariableScrollEntry
    extends TextListScrollAreaEntry {
        public Variable variable;

        public VariableScrollEntry(ScrollArea parent, @NotNull Variable variable, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Components.literal(variable.name).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.variable = variable;
        }
    }
}

