/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.panorama;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.panorama.LocalTexturePanoramaRenderer;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanoramaHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, LocalTexturePanoramaRenderer> PANORAMAS = new HashMap<String, LocalTexturePanoramaRenderer>();
    public static final File PANORAMA_DIR = FileUtils.createDirectory(new File(FancyMenu.MOD_DIR, "panoramas"));

    public static void init() {
        PanoramaHandler.updatePanoramas();
        EventHandler.INSTANCE.registerListenersOf(new PanoramaHandler());
    }

    public static void updatePanoramas() {
        File[] files;
        PANORAMAS.clear();
        for (File panorama : files = Objects.requireNonNullElse(PANORAMA_DIR.listFiles(), new File[0])) {
            if (panorama.isDirectory()) {
                File propertiesFile = new File(panorama, "properties.txt");
                if (!propertiesFile.isFile()) {
                    propertiesFile = new File(panorama, "properties.txt.txt");
                }
                File imageDir = new File(panorama, "panorama");
                File overlayImageFile = new File(panorama, "overlay.png");
                if (!overlayImageFile.isFile()) {
                    overlayImageFile = null;
                }
                if (propertiesFile.isFile() && imageDir.isDirectory()) {
                    LocalTexturePanoramaRenderer renderer = LocalTexturePanoramaRenderer.build(propertiesFile, imageDir, overlayImageFile);
                    if (renderer != null) {
                        PANORAMAS.put(renderer.getName(), renderer);
                        continue;
                    }
                    LOGGER.error(PanoramaHandler.buildErrorMessage(panorama, false, false, false) + " (failed to build renderer - was NULL)");
                    continue;
                }
                LOGGER.error(PanoramaHandler.buildErrorMessage(panorama, true, propertiesFile.isFile(), imageDir.isDirectory()));
                continue;
            }
            LOGGER.error(PanoramaHandler.buildErrorMessage(panorama, false, false, false) + " (not a directory)");
        }
    }

    private static String buildErrorMessage(@NotNull File panoramaDir, boolean addDetails, boolean propertiesFileFound, boolean imageDirFound) {
        String msg = "[FANCYMENU] Invalid panorama found: " + panoramaDir.getName();
        if (addDetails) {
            Object details = "";
            if (!propertiesFileFound) {
                details = (String)details + "Missing \"properties.txt\" file";
            }
            if (!((String)details).isEmpty()) {
                details = (String)details + "; ";
            }
            if (!imageDirFound) {
                details = (String)details + "Missing \"panorama\" directory for images";
            }
            if (!((String)details).isEmpty()) {
                msg = msg + " (" + (String)details + ")";
            }
        }
        return msg;
    }

    @Nullable
    public static LocalTexturePanoramaRenderer getPanorama(@NotNull String name) {
        return PANORAMAS.get(Objects.requireNonNull(name));
    }

    @NotNull
    public static List<LocalTexturePanoramaRenderer> getPanoramas() {
        return new ArrayList<LocalTexturePanoramaRenderer>(PANORAMAS.values());
    }

    @NotNull
    public static List<String> getPanoramaNames() {
        return new ArrayList<String>(PANORAMAS.keySet());
    }

    public static boolean panoramaExists(@NotNull String name) {
        return PANORAMAS.containsKey(Objects.requireNonNull(name));
    }

    @EventListener
    public void onMenuReload(ModReloadEvent e) {
        LOGGER.info("[FANCYMENU] Reloading panoramas..");
        PanoramaHandler.updatePanoramas();
    }
}

