/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsEntityNearbyRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsEntityNearbyRequirement() {
        super("is_entity_nearby");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (level != null && player != null) {
                if (value == null || value.trim().isEmpty() || !value.contains(":")) {
                    return false;
                }
                String[] valsRaw = value.split(":", 2);
                int radius = SerializationUtils.deserializeNumber(Integer.class, 1, valsRaw[0]);
                String entityKey = valsRaw[1];
                for (Entity entity : IsEntityNearbyRequirement.getEntitiesAroundPlayer((Player)player, level, radius)) {
                    ResourceLocation loc = Services.PLATFORM.getEntityKey(entity.m_6095_());
                    if (loc == null || !loc.toString().equals(entityKey)) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", (Throwable)ex);
        }
        return false;
    }

    @NotNull
    private static List<Entity> getEntitiesAroundPlayer(@NotNull Player player, @NotNull ClientLevel level, double radius) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        AABB boundingBox = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        return level.m_6249_((Entity)player, boundingBox, entity -> true);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.world.is_entity_nearby", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_entity_nearby.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.editor.loading_requirement.category.world", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "10:minecraft:pig";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsEntityNearbyValueConfigScreen s = new IsEntityNearbyValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    @NotNull
    private static List<ResourceLocation> getEntityKeys() {
        ArrayList<ResourceLocation> types = new ArrayList<ResourceLocation>();
        try {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                Registry.f_122826_.m_206115_().forEach(biomeHolder -> biomeHolder.m_203439_().map(key -> Boolean.valueOf(types.add(key.m_135782_())), biome -> ""));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get entity types for 'Is Entity Nearby' loading requirement!", (Throwable)ex);
        }
        return types;
    }

    public static class IsEntityNearbyValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String radius;
        @NotNull
        protected String entityKey;
        protected CellScreen.TextInputCell radiusTextInput;
        protected CellScreen.TextInputCell entityKeyTextInput;
        protected EditBoxSuggestions suggestions;

        protected IsEntityNearbyValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            if (value.contains(":")) {
                this.radius = value.split(":", 2)[0];
                this.entityKey = value.split(":", 2)[1];
            } else {
                this.radius = "10";
                this.entityKey = "minecraft:pig";
            }
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String entityId = this.getEntityKeyString();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.requirements.world.is_entity_nearby.value.key"));
            this.entityKeyTextInput = this.addTextInputCell(null, true, true).setText(entityId);
            ArrayList<String> suggestionValues = new ArrayList<String>();
            IsEntityNearbyRequirement.getEntityKeys().forEach(location -> suggestionValues.add(location.toString()));
            if (suggestionValues.isEmpty()) {
                suggestionValues.add(I18n.m_118938_((String)"fancymenu.requirements.world.is_entity_nearby.suggestions.error", (Object[])new Object[0]));
            }
            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.entityKeyTextInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, suggestionValues);
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            this.entityKeyTextInput.editBox.m_94151_(s -> this.suggestions.m_93881_());
            this.addCellGroupEndSpacerCell();
            String radiusString = this.getRadiusString();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.requirements.world.is_entity_nearby.value.radius"));
            this.radiusTextInput = this.addTextInputCell(null, true, true).setText(radiusString);
            this.addSpacerCell(20);
        }

        @Override
        public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partial) {
            super.m_6305_(graphics, mouseX, mouseY, partial);
            this.suggestions.m_93900_(graphics, mouseX, mouseY);
        }

        @Override
        public boolean m_7933_(int $$0, int $$1, int $$2) {
            if (this.suggestions.m_93888_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_7933_($$0, $$1, $$2);
        }

        public boolean m_6050_(double $$0, double $$1, double scrollDeltaY) {
            if (this.suggestions.m_93882_(scrollDeltaY)) {
                return true;
            }
            return super.m_6050_($$0, $$1, scrollDeltaY);
        }

        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (this.suggestions.m_93884_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getRadiusString() + ":" + this.getEntityKeyString();
        }

        @NotNull
        protected String getRadiusString() {
            if (this.radiusTextInput != null) {
                return this.radiusTextInput.getText();
            }
            return this.radius;
        }

        @NotNull
        protected String getEntityKeyString() {
            if (this.entityKeyTextInput != null) {
                return this.entityKeyTextInput.getText();
            }
            return this.entityKey;
        }
    }
}

