/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.widget.widgets.layer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidgetBuilder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayerLayoutEditorWidget
extends AbstractLayoutEditorWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    protected ScrollArea scrollArea;

    public LayerLayoutEditorWidget(LayoutEditorScreen editor, AbstractLayoutEditorWidgetBuilder<?> builder) {
        super(editor, builder);
        this.displayLabel = Components.translatable("fancymenu.editor.widgets.layers", new Object[0]);
        this.scrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f){

            @Override
            public void updateScrollArea() {
                int grabberOffset = 5;
                this.verticalScrollBar.scrollAreaStartX = this.getInnerX() + (float)grabberOffset;
                this.verticalScrollBar.scrollAreaStartY = this.getInnerY() + (float)grabberOffset;
                this.verticalScrollBar.scrollAreaEndX = this.getInnerX() + this.getInnerWidth() - (float)grabberOffset;
                this.verticalScrollBar.scrollAreaEndY = this.getInnerY() + this.getInnerHeight() - this.horizontalScrollBar.grabberHeight - (float)grabberOffset - 1.0f;
                this.horizontalScrollBar.scrollAreaStartX = this.getInnerX() + (float)grabberOffset;
                this.horizontalScrollBar.scrollAreaStartY = this.getInnerY() + (float)grabberOffset;
                this.horizontalScrollBar.scrollAreaEndX = this.getInnerX() + this.getInnerWidth() - this.verticalScrollBar.grabberWidth - (float)grabberOffset - 1.0f;
                this.horizontalScrollBar.scrollAreaEndY = this.getInnerY() + this.getInnerHeight() - (float)grabberOffset;
            }
        };
        this.scrollArea.borderColor = () -> UIBase.getUIColorTheme().area_background_color;
        this.updateList(false);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateList(false);
    }

    public void updateList(boolean keepScroll) {
        float scroll = this.scrollArea.verticalScrollBar.getScroll();
        for (GuiComponent e : this.scrollArea.getEntries()) {
            if (!(e instanceof LayerElementEntry)) continue;
            LayerElementEntry l = (LayerElementEntry)e;
            this.children.remove(l.editLayerNameBox);
        }
        this.scrollArea.clearEntries();
        if (this.editor.layout.renderElementsBehindVanilla) {
            this.scrollArea.addEntry(new VanillaLayerElementEntry(this.scrollArea, this));
            this.scrollArea.addEntry(new SeparatorEntry(this.scrollArea));
        }
        for (GuiComponent e : Lists.reverse(new ArrayList<AbstractEditorElement>(this.editor.normalEditorElements))) {
            LayerElementEntry layer = new LayerElementEntry(this.scrollArea, this, (AbstractEditorElement)e);
            this.children.add(layer.editLayerNameBox);
            this.scrollArea.addEntry(layer);
            this.scrollArea.addEntry(new SeparatorEntry(this.scrollArea));
        }
        if (!this.editor.layout.renderElementsBehindVanilla) {
            this.scrollArea.addEntry(new VanillaLayerElementEntry(this.scrollArea, this));
            this.scrollArea.addEntry(new SeparatorEntry(this.scrollArea));
        }
        if (keepScroll) {
            this.scrollArea.verticalScrollBar.setScroll(scroll);
        }
    }

    @Override
    protected void renderBody(@NotNull PoseStack pose, double mouseX, double mouseY, float partial) {
        RenderingUtils.resetShaderColor();
        LayerLayoutEditorWidget.fillF(pose, this.getRealBodyX(), this.getRealBodyY(), this.getRealBodyX() + this.getBodyWidth(), this.getRealBodyY() + this.getBodyHeight(), UIBase.getUIColorTheme().area_background_color.getColorInt());
        this.scrollArea.setX(this.getRealBodyX());
        this.scrollArea.setY(this.getRealBodyY());
        this.scrollArea.setWidth(this.getBodyWidth());
        this.scrollArea.setHeight(this.getBodyHeight());
        this.scrollArea.setApplyScissor(false);
        this.scrollArea.horizontalScrollBar.active = false;
        this.scrollArea.makeEntriesWidthOfArea = true;
        this.scrollArea.makeAllEntriesWidthOfWidestEntry = false;
        this.enableComponentScissor((int)this.getRealBodyX() - 5, (int)this.getRealBodyY(), (int)this.getBodyWidth() + 10, (int)this.getBodyHeight() + 1, true);
        pose.m_85836_();
        pose.m_85837_(0.0, 0.0, 400.0);
        this.scrollArea.m_6305_(pose, (int)mouseX, (int)mouseY, partial);
        pose.m_85849_();
        this.disableComponentScissor();
    }

    @Override
    public void tick() {
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof LayerElementEntry)) continue;
            LayerElementEntry l = (LayerElementEntry)e;
            l.editLayerNameBox.m_94120_();
        }
    }

    @Override
    @Nullable
    protected AbstractLayoutEditorWidget.ResizingEdge updateHoveredResizingEdge() {
        if (this.scrollArea.isMouseInteractingWithGrabbers()) {
            return null;
        }
        return super.updateHoveredResizingEdge();
    }

    @Override
    protected boolean mouseClickedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            LayerElementEntry l;
            if (!(e instanceof LayerElementEntry) || (l = (LayerElementEntry)e).isLayerNameHovered()) continue;
            l.stopEditingLayerName();
        }
        if (this.isVisible()) {
            if (super.mouseClickedComponent(realMouseX, realMouseY, translatedMouseX, translatedMouseY, button)) {
                return true;
            }
            if (this.isExpanded()) {
                if (this.scrollArea.verticalScrollBar.m_6375_(translatedMouseX, translatedMouseY, button)) {
                    return true;
                }
                if (this.scrollArea.horizontalScrollBar.m_6375_(translatedMouseX, translatedMouseY, button)) {
                    return true;
                }
                for (ScrollAreaEntry entry : this.scrollArea.getEntries()) {
                    if (!entry.mouseClicked(realMouseX, realMouseY, button)) continue;
                    return true;
                }
            }
        }
        return this.isVisible() && this.isMouseOver();
    }

    @Override
    protected boolean mouseReleasedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        if (super.mouseReleasedComponent(realMouseX, realMouseY, translatedMouseX, translatedMouseY, button)) {
            return true;
        }
        return this.scrollArea.m_6348_(realMouseX, realMouseY, button);
    }

    @Override
    protected boolean mouseDraggedComponent(double translatedMouseX, double translatedMouseY, int button, double d1, double d2) {
        if (super.mouseDraggedComponent(translatedMouseX, translatedMouseY, button, d1, d2)) {
            return true;
        }
        return this.scrollArea.m_7979_(translatedMouseX, translatedMouseY, button, d1, d2);
    }

    @Override
    protected boolean mouseScrolledComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, double scrollDelta) {
        if (super.mouseScrolledComponent(realMouseX, realMouseY, translatedMouseX, translatedMouseY, scrollDelta)) {
            return true;
        }
        return this.scrollArea.m_6050_(realMouseX, realMouseY, scrollDelta);
    }

    @Override
    public void editorElementAdded(@NotNull AbstractEditorElement element) {
        this.updateList(false);
    }

    @Override
    public void editorElementRemovedOrHidden(@NotNull AbstractEditorElement element) {
        this.updateList(false);
    }

    @Override
    public void editorElementOrderChanged(@NotNull AbstractEditorElement element, boolean movedUp) {
        this.updateList(false);
    }

    public static class LayerElementEntry
    extends ScrollAreaEntry {
        protected static final ResourceLocation MOVE_UP_TEXTURE = new ResourceLocation("fancymenu", "textures/layout_editor/widgets/layers/move_up.png");
        protected static final ResourceLocation MOVE_DOWN_TEXTURE = new ResourceLocation("fancymenu", "textures/layout_editor/widgets/layers/move_down.png");
        protected AbstractEditorElement element;
        protected LayerLayoutEditorWidget layerWidget;
        protected boolean moveUpButtonHovered = false;
        protected boolean moveDownButtonHovered = false;
        protected Font font;
        protected ExtendedEditBox editLayerNameBox;
        protected boolean displayEditLayerNameBox;
        protected boolean layerNameHovered;
        protected long lastLeftClick;

        public LayerElementEntry(ScrollArea parent, LayerLayoutEditorWidget layerWidget, @NotNull AbstractEditorElement element) {
            super(parent, 50.0f, 28.0f);
            this.font = Minecraft.m_91087_().f_91062_;
            this.displayEditLayerNameBox = false;
            this.layerNameHovered = false;
            this.lastLeftClick = -1L;
            this.element = element;
            this.layerWidget = layerWidget;
            this.playClickSound = false;
            this.selectable = false;
            this.selectOnClick = false;
            this.editLayerNameBox = new ExtendedEditBox(this.font, 0, 0, 0, 0, (Component)Components.empty()){

                @Override
                public boolean m_7933_(int keycode, int scancode, int modifiers) {
                    if (this.m_94213_() && displayEditLayerNameBox && keycode == 257) {
                        this.stopEditingLayerName();
                        return true;
                    }
                    return super.m_7933_(keycode, scancode, modifiers);
                }
            };
            this.editLayerNameBox.m_94194_(false);
            this.editLayerNameBox.m_94199_(10000);
        }

        @Override
        public void renderEntry(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
            this.moveUpButtonHovered = this.isMoveUpButtonMouseOver(mouseX, mouseY);
            this.moveDownButtonHovered = this.isMoveDownButtonMouseOver(mouseX, mouseY);
            this.layerNameHovered = this.isLayerNameMouseOver(mouseX, mouseY);
            RenderSystem.m_69478_();
            if (this.element.isSelected() || this.element.isMultiSelected()) {
                RenderingUtils.resetShaderColor();
                LayerElementEntry.fillF(pose, this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), UIBase.getUIColorTheme().element_background_color_hover.getColorInt());
            }
            UIBase.getUIColorTheme().setUITextureShaderColor(this.layerWidget.editor.canMoveLayerUp(this.element) ? 1.0f : 0.3f);
            RenderingUtils.bindTexture(MOVE_UP_TEXTURE);
            LayerElementEntry.blitF(pose, this.x, this.y, 0.0f, 0.0f, this.getButtonWidth(), this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight());
            UIBase.getUIColorTheme().setUITextureShaderColor(this.layerWidget.editor.canMoveLayerDown(this.element) ? 1.0f : 0.3f);
            RenderingUtils.bindTexture(MOVE_DOWN_TEXTURE);
            LayerElementEntry.blitF(pose, this.x, this.y + this.getButtonHeight(), 0.0f, 0.0f, this.getButtonWidth(), this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight());
            RenderingUtils.resetShaderColor();
            if (!this.displayEditLayerNameBox) {
                this.layerWidget.enableComponentScissor((int)(this.x + this.getButtonWidth() + 1.0f), (int)this.y, (int)(this.getWidth() - this.getButtonWidth() - 4.0f), (int)this.getHeight(), true);
                UIBase.drawElementLabelF(pose, this.font, (Component)Components.literal(this.getLayerName()), (float)((int)this.getLayerNameX()), (float)((int)this.getLayerNameY()));
                this.layerWidget.disableComponentScissor();
            } else {
                UIBase.applyDefaultWidgetSkinTo(this.editLayerNameBox);
                this.editLayerNameBox.m_94214_((int)this.getLayerNameX());
                this.editLayerNameBox.f_93621_ = (int)this.getLayerNameY() - 1;
                this.editLayerNameBox.m_93674_((int)Math.min(this.getMaxLayerNameWidth(), (float)this.font.m_92895_(this.editLayerNameBox.m_94155_() + "13")));
                if ((float)this.editLayerNameBox.m_5711_() < this.getMaxLayerNameWidth()) {
                    this.editLayerNameBox.setDisplayPosition(0);
                }
                IMixinAbstractWidget iMixinAbstractWidget = (IMixinAbstractWidget)((Object)this.editLayerNameBox);
                Objects.requireNonNull(this.font);
                iMixinAbstractWidget.setHeightFancyMenu(9 + 2);
                this.editLayerNameBox.m_6305_(pose, mouseX, mouseY, partial);
            }
        }

        protected void startEditingLayerName() {
            this.editLayerNameBox.m_94194_(true);
            this.editLayerNameBox.m_93692_(true);
            this.editLayerNameBox.m_94144_(this.getLayerName());
            this.editLayerNameBox.m_94201_();
            this.displayEditLayerNameBox = true;
        }

        protected void stopEditingLayerName() {
            if (this.displayEditLayerNameBox) {
                String oldLayerName = this.getLayerName();
                this.element.element.customElementLayerName = this.editLayerNameBox.m_94155_();
                if (Objects.equals(oldLayerName, this.element.element.customElementLayerName)) {
                    this.element.element.customElementLayerName = null;
                }
                if (this.element.element.customElementLayerName != null && this.element.element.customElementLayerName.replace(" ", "").isEmpty()) {
                    this.element.element.customElementLayerName = null;
                }
            }
            this.editLayerNameBox.m_93692_(false);
            this.editLayerNameBox.m_94194_(false);
            this.displayEditLayerNameBox = false;
        }

        public String getLayerName() {
            if (this.element.element.customElementLayerName != null) {
                return this.element.element.customElementLayerName;
            }
            return this.element.element.builder.getDisplayName(this.element.element).getString();
        }

        public float getLayerNameX() {
            return this.getX() + this.getButtonWidth() + 3.0f;
        }

        public float getLayerNameY() {
            float f = this.getY() + this.getHeight() / 2.0f;
            Objects.requireNonNull(this.font);
            return f - 9.0f / 2.0f;
        }

        public float getMaxLayerNameWidth() {
            return this.getX() + this.getWidth() - 3.0f - this.getLayerNameX();
        }

        public boolean isMoveUpButtonHovered() {
            return this.moveUpButtonHovered;
        }

        public boolean isMoveDownButtonHovered() {
            return this.moveDownButtonHovered;
        }

        public boolean isLayerNameHovered() {
            return this.layerNameHovered;
        }

        public boolean isMoveUpButtonMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return LayerElementEntry.isXYInArea(mouseX, mouseY, this.x, this.y, this.getButtonWidth(), this.getButtonHeight());
        }

        public boolean isMoveDownButtonMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return LayerElementEntry.isXYInArea(mouseX, mouseY, this.x, this.y + this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight());
        }

        public boolean isLayerNameMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            double d = this.getLayerNameX();
            double d2 = this.getLayerNameY();
            double d3 = this.getMaxLayerNameWidth();
            Objects.requireNonNull(this.font);
            return LayerElementEntry.isXYInArea(mouseX, mouseY, d, d2, d3, 9.0);
        }

        public float getButtonHeight() {
            return 14.0f;
        }

        public float getButtonWidth() {
            return 30.0f;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this.isMoveUpButtonHovered()) {
                    if (this.layerWidget.editor.canMoveLayerUp(this.element)) {
                        if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                        }
                        ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                        if (!this.element.isSelected()) {
                            this.layerWidget.editor.deselectAllElements();
                        }
                        this.element.setSelected(true);
                        this.layerWidget.editor.moveLayerUp(this.element);
                        this.layerWidget.getAllWidgetsExceptThis().forEach(widget -> widget.editorElementOrderChanged(this.element, true));
                        MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }
                } else if (this.isMoveDownButtonHovered()) {
                    if (this.layerWidget.editor.canMoveLayerDown(this.element)) {
                        if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                        }
                        ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                        if (!this.element.isSelected()) {
                            this.layerWidget.editor.deselectAllElements();
                        }
                        this.element.setSelected(true);
                        this.layerWidget.editor.moveLayerDown(this.element);
                        this.layerWidget.getAllWidgetsExceptThis().forEach(widget -> widget.editorElementOrderChanged(this.element, false));
                        MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }
                } else {
                    if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    }
                    if (!Screen.m_96637_()) {
                        this.layerWidget.editor.deselectAllElements();
                    }
                    this.element.setSelected(!this.element.isSelected());
                    if (this.isLayerNameHovered()) {
                        long now = System.currentTimeMillis();
                        if (this.lastLeftClick + 400L > now) {
                            this.startEditingLayerName();
                        }
                        this.lastLeftClick = now;
                    }
                }
            }
            if (button == 1) {
                if (!this.element.isSelected()) {
                    this.layerWidget.editor.deselectAllElements();
                }
                this.element.setSelected(true);
                MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.editor.openElementContextMenuAtMouseIfPossible(), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }
        }
    }

    public static class VanillaLayerElementEntry
    extends ScrollAreaEntry {
        protected static final ResourceLocation MOVE_TO_TOP_TEXTURE = new ResourceLocation("fancymenu", "textures/layout_editor/widgets/layers/move_top.png");
        protected static final ResourceLocation MOVE_BEHIND_TEXTURE = new ResourceLocation("fancymenu", "textures/layout_editor/widgets/layers/move_bottom.png");
        protected LayerLayoutEditorWidget layerWidget;
        protected boolean moveTopBottomButtonHovered = false;
        protected Font font;

        public VanillaLayerElementEntry(ScrollArea parent, LayerLayoutEditorWidget layerWidget) {
            super(parent, 50.0f, 28.0f);
            this.font = Minecraft.m_91087_().f_91062_;
            this.layerWidget = layerWidget;
            this.playClickSound = false;
            this.selectable = false;
            this.selectOnClick = false;
        }

        @Override
        public void renderEntry(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
            this.moveTopBottomButtonHovered = this.isMoveTopBottomButtonHovered(mouseX, mouseY);
            RenderSystem.m_69478_();
            UIBase.getUIColorTheme().setUITextureShaderColor(1.0f);
            RenderingUtils.bindTexture(((LayerLayoutEditorWidget)this.layerWidget).editor.layout.renderElementsBehindVanilla ? MOVE_BEHIND_TEXTURE : MOVE_TO_TOP_TEXTURE);
            VanillaLayerElementEntry.blitF(pose, this.x, this.y, 0.0f, 0.0f, this.getButtonWidth(), this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight());
            RenderingUtils.resetShaderColor();
            this.layerWidget.enableComponentScissor((int)(this.x + this.getButtonWidth() + 1.0f), (int)this.y, (int)(this.getWidth() - this.getButtonWidth() - 4.0f), (int)this.getHeight(), true);
            MutableComponent mutableComponent = Components.translatable("fancymenu.editor.widgets.layers.vanilla_elements", new Object[0]).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            float f = (int)(this.getX() + this.getButtonWidth() + 3.0f);
            float f2 = this.getY() + this.getHeight() / 2.0f;
            Objects.requireNonNull(this.font);
            UIBase.drawElementLabelF(pose, this.font, (Component)mutableComponent, f, (float)((int)(f2 - 9.0f / 2.0f)));
            this.layerWidget.disableComponentScissor();
        }

        public boolean isMoveTopBottomButtonHovered() {
            return this.moveTopBottomButtonHovered;
        }

        public boolean isMoveTopBottomButtonHovered(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return VanillaLayerElementEntry.isXYInArea(mouseX, mouseY, this.x, this.y, this.getButtonWidth(), this.getButtonHeight());
        }

        public float getButtonHeight() {
            return 28.0f;
        }

        public float getButtonWidth() {
            return 30.0f;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            if (button == 0 && this.isMoveTopBottomButtonHovered()) {
                if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }
                ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                ((LayerLayoutEditorWidget)this.layerWidget).editor.layout.renderElementsBehindVanilla = !((LayerLayoutEditorWidget)this.layerWidget).editor.layout.renderElementsBehindVanilla;
                this.layerWidget.editor.deselectAllElements();
                MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }
        }
    }

    public static class SeparatorEntry
    extends ScrollAreaEntry {
        public SeparatorEntry(ScrollArea parent) {
            super(parent, 50.0f, 1.0f);
            this.selectable = false;
            this.selectOnClick = false;
        }

        @Override
        public void renderEntry(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
            RenderSystem.m_69478_();
            SeparatorEntry.fillF(pose, this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), UIBase.getUIColorTheme().element_border_color_normal.getColorInt());
            RenderingUtils.resetShaderColor();
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            return false;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        }
    }
}

