/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChoosePanoramaScreen
extends Screen {
    protected Consumer<String> callback;
    protected String selectedPanoramaName = null;
    protected ScrollArea panoramaListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChoosePanoramaScreen(@Nullable String preSelectedPanorama, @NotNull Consumer<String> callback) {
        super((Component)Component.m_237115_((String)"fancymenu.panorama.choose"));
        this.callback = callback;
        this.updatePanoramaScrollAreaContent();
        if (preSelectedPanorama != null) {
            for (ScrollAreaEntry e : this.panoramaListScrollArea.getEntries()) {
                if (!(e instanceof PanoramaScrollEntry)) continue;
                PanoramaScrollEntry a = (PanoramaScrollEntry)e;
                if (!a.panorama.equals(preSelectedPanorama)) continue;
                a.setSelected(true);
                this.setSelectedPanorama(a);
                break;
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(this.selectedPanoramaName)){

            @Override
            public void m_6303_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partial) {
                if (ChoosePanoramaScreen.this.selectedPanoramaName == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.panorama.choose.no_panorama_selected", new String[0])).setDefaultStyle(), false, true);
                    this.f_93623_ = false;
                } else {
                    this.f_93623_ = true;
                }
                super.m_6303_(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        GuiComponent.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        GuiComponent.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)titleComp, (int)20, (int)20, (int)UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        GuiComponent.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.panorama.choose.available_panoramas"), (int)20, (int)50, (int)UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.panoramaListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.panoramaListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.panoramaListScrollArea.setX(20, true);
        this.panoramaListScrollArea.setY(65, true);
        this.panoramaListScrollArea.render(pose, mouseX, mouseY, partial);
        this.doneButton.setX(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.setY(this.f_96544_ - 20 - 20);
        this.doneButton.m_6305_(pose, mouseX, mouseY, partial);
        this.cancelButton.setX(this.f_96543_ - 20 - this.cancelButton.m_5711_());
        this.cancelButton.setY(this.doneButton.getY() - 5 - 20);
        this.cancelButton.m_6305_(pose, mouseX, mouseY, partial);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    protected void setSelectedPanorama(@Nullable PanoramaScrollEntry entry) {
        if (entry == null) {
            this.selectedPanoramaName = null;
            return;
        }
        this.selectedPanoramaName = entry.panorama;
    }

    protected void updatePanoramaScrollAreaContent() {
        this.panoramaListScrollArea.clearEntries();
        for (String s : PanoramaHandler.getPanoramaNames()) {
            ScrollAreaEntry e = new PanoramaScrollEntry(this.panoramaListScrollArea, s, entry -> this.setSelectedPanorama((PanoramaScrollEntry)((Object)entry)));
            this.panoramaListScrollArea.addEntry(e);
        }
        if (this.panoramaListScrollArea.getEntries().isEmpty()) {
            this.panoramaListScrollArea.addEntry(new TextScrollAreaEntry(this.panoramaListScrollArea, (Component)Component.m_237115_((String)"fancymenu.panorama.choose.no_panoramas"), entry -> {}));
        }
        int totalWidth = this.panoramaListScrollArea.getTotalEntryWidth();
        for (ScrollAreaEntry e : this.panoramaListScrollArea.getEntries()) {
            e.setWidth(totalWidth);
        }
    }

    public boolean m_7933_(int button, int $$1, int $$2) {
        if (button == 257 && this.selectedPanoramaName != null) {
            this.callback.accept(this.selectedPanoramaName);
            return true;
        }
        return super.m_7933_(button, $$1, $$2);
    }

    public static class PanoramaScrollEntry
    extends TextListScrollAreaEntry {
        public String panorama;

        public PanoramaScrollEntry(ScrollArea parent, @NotNull String panorama, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Component.m_237113_((String)panorama).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.panorama = panorama;
        }
    }
}

