/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.progressbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public BarDirection direction = BarDirection.RIGHT;
    public DrawableColor barColor = DrawableColor.of(new Color(82, 149, 255));
    @Nullable
    public ResourceSupplier<ITexture> barTextureSupplier;
    public DrawableColor backgroundColor = DrawableColor.of(new Color(171, 200, 247));
    @Nullable
    public ResourceSupplier<ITexture> backgroundTextureSupplier;
    public boolean useProgressForElementAnchor = false;
    public String progressSource = null;
    public ProgressValueMode progressValueMode = ProgressValueMode.PERCENTAGE;
    protected int lastProgressX = 0;
    protected int lastProgressY = 0;
    protected int lastProgressWidth = 0;
    protected int lastProgressHeight = 0;
    protected float renderProgress = 0.0f;

    public ProgressBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        if (!this.shouldRender()) {
            return;
        }
        this.renderBackground(pose);
        this.renderProgress(pose);
    }

    protected void renderProgress(@NotNull PoseStack pose) {
        float actualProgress = Math.max(0.0f, Math.min(1.0f, this.getCurrentProgress()));
        this.renderProgress = Mth.m_14036_((float)(this.renderProgress * 0.95f + actualProgress * 0.050000012f), (float)0.0f, (float)1.0f);
        int progressWidth = this.getAbsoluteWidth();
        int progressHeight = this.getAbsoluteHeight();
        int progressX = this.getAbsoluteX();
        int progressY = this.getAbsoluteY();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        Mth.m_14179_((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.direction == BarDirection.LEFT || this.direction == BarDirection.RIGHT) {
            progressWidth = (int)((float)this.getAbsoluteWidth() * this.renderProgress);
        }
        if (this.direction == BarDirection.UP || this.direction == BarDirection.DOWN) {
            progressHeight = (int)((float)this.getAbsoluteHeight() * this.renderProgress);
        }
        if (this.direction == BarDirection.LEFT) {
            progressX += this.getAbsoluteWidth() - progressWidth;
            offsetX = this.getAbsoluteWidth() - progressWidth;
        }
        if (this.direction == BarDirection.UP) {
            progressY += this.getAbsoluteHeight() - progressHeight;
            offsetY = this.getAbsoluteHeight() - progressHeight;
        }
        this.lastProgressX = progressX;
        this.lastProgressY = progressY;
        this.lastProgressWidth = progressWidth;
        this.lastProgressHeight = progressHeight;
        RenderSystem.m_69478_();
        if (this.barTextureSupplier != null) {
            ResourceLocation loc;
            ITexture t = this.barTextureSupplier.get();
            if (t != null && (loc = t.getResourceLocation()) != null) {
                RenderUtils.bindTexture((ResourceLocation)loc);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                ProgressBarElement.m_93133_((PoseStack)pose, (int)progressX, (int)progressY, (float)offsetX, (float)offsetY, (int)progressWidth, (int)progressHeight, (int)this.getAbsoluteWidth(), (int)this.getAbsoluteHeight());
                RenderingUtils.resetShaderColor();
            }
        } else if (this.barColor != null) {
            RenderingUtils.resetShaderColor();
            RenderSystem.m_69478_();
            float colorAlpha = Math.min(1.0f, Math.max(0.0f, (float)FastColor.ARGB32.m_13655_((int)this.barColor.getColorInt()) / 255.0f));
            if (this.opacity <= colorAlpha) {
                colorAlpha = this.opacity;
            }
            ProgressBarElement.m_93172_((PoseStack)pose, (int)progressX, (int)progressY, (int)(progressX + progressWidth), (int)(progressY + progressHeight), (int)RenderingUtils.replaceAlphaInColor(this.barColor.getColorInt(), colorAlpha));
            RenderingUtils.resetShaderColor();
        }
    }

    protected void renderBackground(@NotNull PoseStack pose) {
        RenderSystem.m_69478_();
        if (this.backgroundTextureSupplier != null) {
            this.backgroundTextureSupplier.forRenderable((iTexture, location) -> {
                RenderUtils.bindTexture((ResourceLocation)location);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                ProgressBarElement.m_93133_((PoseStack)pose, (int)this.getAbsoluteX(), (int)this.getAbsoluteY(), (float)0.0f, (float)0.0f, (int)this.getAbsoluteWidth(), (int)this.getAbsoluteHeight(), (int)this.getAbsoluteWidth(), (int)this.getAbsoluteHeight());
                RenderingUtils.resetShaderColor();
            });
        } else if (this.backgroundColor != null) {
            RenderingUtils.resetShaderColor();
            RenderSystem.m_69478_();
            float colorAlpha = Math.min(1.0f, Math.max(0.0f, (float)FastColor.ARGB32.m_13655_((int)this.backgroundColor.getColorInt()) / 255.0f));
            if (this.opacity <= colorAlpha) {
                colorAlpha = this.opacity;
            }
            ProgressBarElement.m_93172_((PoseStack)pose, (int)this.getAbsoluteX(), (int)this.getAbsoluteY(), (int)(this.getAbsoluteX() + this.getAbsoluteWidth()), (int)(this.getAbsoluteY() + this.getAbsoluteHeight()), (int)RenderingUtils.replaceAlphaInColor(this.backgroundColor.getColorInt(), colorAlpha));
            RenderingUtils.resetShaderColor();
        }
    }

    public float getCurrentProgress() {
        String s;
        if (ProgressBarElement.isEditor()) {
            return 0.5f;
        }
        if (this.progressSource != null && MathUtils.isFloat((String)(s = StringUtils.replace((String)PlaceholderParser.replacePlaceholders(this.progressSource), (String)" ", (String)"")))) {
            if (this.progressValueMode == ProgressValueMode.PERCENTAGE) {
                return Float.parseFloat(s) / 100.0f;
            }
            return Float.parseFloat(s);
        }
        return 0.0f;
    }

    @Override
    public int getChildElementAnchorPointX() {
        if (this.useProgressForElementAnchor) {
            if (this.direction == BarDirection.RIGHT) {
                return this.getProgressX() + this.getProgressWidth();
            }
            return this.getProgressX();
        }
        return super.getChildElementAnchorPointX();
    }

    @Override
    public int getChildElementAnchorPointY() {
        if (this.useProgressForElementAnchor) {
            if (this.direction == BarDirection.DOWN) {
                return this.getProgressY() + this.getProgressHeight();
            }
            return this.getProgressY();
        }
        return super.getChildElementAnchorPointY();
    }

    public int getProgressX() {
        return this.lastProgressX;
    }

    public int getProgressY() {
        return this.lastProgressY;
    }

    public int getProgressWidth() {
        return this.lastProgressWidth;
    }

    public int getProgressHeight() {
        return this.lastProgressHeight;
    }

    public static enum BarDirection implements LocalizedCycleEnum<BarDirection>
    {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        private final String name;

        private BarDirection(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.editor.elements.progress_bar.direction";
        }

        @Override
        @NotNull
        public Style getValueComponentStyle() {
            return (Style)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public BarDirection[] getValues() {
            return BarDirection.values();
        }

        @Override
        @Nullable
        public BarDirection getByNameInternal(@NotNull String name) {
            return BarDirection.getByName(name);
        }

        @Nullable
        public static BarDirection getByName(@NotNull String name) {
            for (BarDirection d : BarDirection.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum ProgressValueMode implements LocalizedCycleEnum<ProgressValueMode>
    {
        PERCENTAGE("percentage"),
        FLOATING_POINT("float");

        private final String name;

        private ProgressValueMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.editor.elements.progress_bar.mode";
        }

        @Override
        @NotNull
        public Style getValueComponentStyle() {
            return (Style)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ProgressValueMode[] getValues() {
            return ProgressValueMode.values();
        }

        @Override
        @Nullable
        public ProgressValueMode getByNameInternal(@NotNull String name) {
            return ProgressValueMode.getByName(name);
        }

        @Nullable
        public static ProgressValueMode getByName(@NotNull String name) {
            for (ProgressValueMode d : ProgressValueMode.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }
}

