/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntangledBinderItem
extends BaseItem {
    public static boolean isBound(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag data = stack.m_41783_();
        if (!(data.m_128471_("bound") && data.m_128425_("dimension", 8) && data.m_128425_("boundx", 3) && data.m_128425_("boundy", 3) && data.m_128425_("boundz", 3))) {
            return false;
        }
        String dimension = data.m_128461_("dimension");
        return RegistryUtil.isValidIdentifier((String)dimension);
    }

    public static BlockPos getBoundPosition(ItemStack stack) {
        CompoundTag data = stack.m_41783_();
        return new BlockPos(data.m_128451_("boundx"), data.m_128451_("boundy"), data.m_128451_("boundz"));
    }

    public static ResourceLocation getBoundDimension(ItemStack stack) {
        return new ResourceLocation(stack.m_41783_().m_128461_("dimension"));
    }

    public EntangledBinderItem() {
        super(ItemProperties.create().maxStackSize(1).group(CreativeModeTab.f_40753_));
    }

    public BaseItem.InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = stack.m_41783_() == null ? new CompoundTag() : stack.m_41783_();
        if (compound.m_128471_("bound") && compound.m_128461_("dimension").equals(level.m_46472_().m_135782_().toString()) && compound.m_128451_("boundx") == hitPos.m_123341_() && compound.m_128451_("boundy") == hitPos.m_123342_() && compound.m_128451_("boundz") == hitPos.m_123343_()) {
            return BaseItem.InteractionFeedback.CONSUME;
        }
        if (!level.f_46443_) {
            compound.m_128379_("bound", true);
            compound.m_128359_("dimension", level.m_46472_().m_135782_().toString());
            compound.m_128405_("boundx", hitPos.m_123341_());
            compound.m_128405_("boundy", hitPos.m_123342_());
            compound.m_128405_("boundz", hitPos.m_123343_());
            compound.m_128405_("blockstate", Block.m_49956_((BlockState)level.m_8055_(hitPos)));
            stack.m_41751_(compound);
            player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_binder.select").color(ChatFormatting.YELLOW).get(), true);
        }
        return BaseItem.InteractionFeedback.SUCCESS;
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        CompoundTag compound = stack.m_41783_();
        if (player.m_6047_() && compound != null && compound.m_128471_("bound")) {
            if (!level.f_46443_) {
                stack.m_41749_("bound");
                stack.m_41749_("dimension");
                stack.m_41749_("boundx");
                stack.m_41749_("boundy");
                stack.m_41749_("boundz");
                stack.m_41749_("blockstate");
                player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_binder.clear").color(ChatFormatting.YELLOW).get(), true);
            }
            return BaseItem.ItemUseResult.consume((ItemStack)stack);
        }
        return super.interact(stack, player, hand, level);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info").color(ChatFormatting.AQUA).get());
        if (EntangledBinderItem.isBound(stack)) {
            CompoundTag tag = stack.m_41784_();
            int x = tag.m_128451_("boundx");
            int y = tag.m_128451_("boundy");
            int z = tag.m_128451_("boundz");
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")))).color(ChatFormatting.GOLD).get();
            MutableComponent xText = TextComponents.string((String)Integer.toString(x)).color(ChatFormatting.GOLD).get();
            MutableComponent yText = TextComponents.string((String)Integer.toString(y)).color(ChatFormatting.GOLD).get();
            MutableComponent zText = TextComponents.string((String)Integer.toString(z)).color(ChatFormatting.GOLD).get();
            if (tag.m_128441_("blockstate")) {
                MutableComponent name = TextComponents.blockState((BlockState)Block.m_49803_((int)tag.m_128451_("blockstate"))).color(ChatFormatting.GOLD).get();
                info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info.target.known", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
            } else {
                info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info.target.unknown", (Object[])new Object[]{xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
            }
        }
    }
}

