/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledClient;
import com.supermartijn642.entangled.generators.EntangledBlockStateGenerator;
import com.supermartijn642.entangled.generators.EntangledLanguageGenerator;
import com.supermartijn642.entangled.generators.EntangledLootTableGenerator;
import com.supermartijn642.entangled.generators.EntangledModelGenerator;
import com.supermartijn642.entangled.generators.EntangledRecipeGenerator;
import com.supermartijn642.entangled.generators.EntangledTagGenerator;
import com.supermartijn642.entangled.integration.TheOneProbePlugin;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="entangled")
public class Entangled {
    public static final Logger LOGGER = CommonUtils.getLogger((String)"entangled");
    @RegistryEntryAcceptor(namespace="entangled", identifier="block", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static EntangledBlock block;
    @RegistryEntryAcceptor(namespace="entangled", identifier="tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<EntangledBlockEntity> tile;
    @RegistryEntryAcceptor(namespace="entangled", identifier="item", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static EntangledBinderItem item;

    public Entangled() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TheOneProbePlugin::interModEnqueue);
        Entangled.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> EntangledClient::register);
        Entangled.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"entangled");
        handler.registerBlock("block", EntangledBlock::new);
        handler.registerItem("block", () -> new BaseBlockItem((Block)block, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerBlockEntityType("tile", () -> BaseBlockEntityType.create(EntangledBlockEntity::new, (Block[])new Block[]{block}));
        handler.registerItem("item", EntangledBinderItem::new);
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"entangled");
        handler.addGenerator(EntangledBlockStateGenerator::new);
        handler.addGenerator(EntangledModelGenerator::new);
        handler.addGenerator(EntangledLanguageGenerator::new);
        handler.addGenerator(EntangledLootTableGenerator::new);
        handler.addGenerator(EntangledRecipeGenerator::new);
        handler.addGenerator(EntangledTagGenerator::new);
    }
}

