/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.graph;

import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.util.frustum.Frustum;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.Direction;

public class ChunkGraphInfo {
    private static final long DEFAULT_VISIBILITY_DATA = ChunkGraphInfo.calculateVisibilityData(ChunkRenderData.EMPTY.getOcclusionData());
    private static final float FRUSTUM_EPSILON = 1.125f;
    private final RenderSection parent;
    private int lastVisibleFrame = -1;
    private long visibilityData;
    private short cullingState;

    public ChunkGraphInfo(RenderSection parent) {
        this.parent = parent;
        this.visibilityData = DEFAULT_VISIBILITY_DATA;
    }

    public void setLastVisibleFrame(int frame) {
        this.lastVisibleFrame = frame;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public void setOcclusionData(VisibilitySet occlusionData) {
        this.visibilityData = ChunkGraphInfo.calculateVisibilityData(occlusionData);
    }

    private static long calculateVisibilityData(VisibilitySet occlusionData) {
        long visibilityData = 0L;
        for (Direction from : DirectionUtil.ALL_DIRECTIONS) {
            for (Direction to : DirectionUtil.ALL_DIRECTIONS) {
                if (occlusionData != null && !occlusionData.m_112983_(from, to)) continue;
                visibilityData |= 1L << (from.ordinal() << 3) + to.ordinal();
            }
        }
        return visibilityData;
    }

    public short computeQueuePop() {
        short retVal = (short)(this.cullingState & (this.cullingState >> 8 & 0xFF | 0xFF00));
        this.cullingState = 0;
        return retVal;
    }

    public void updateCullingState(Direction flow, short parent) {
        int inbound = flow.ordinal();
        this.cullingState = (short)((long)this.cullingState | this.visibilityData >> (inbound << 3) & 0xFFL);
        this.cullingState = (short)(this.cullingState & ~(1 << inbound + 8));
        this.cullingState = (short)(this.cullingState & (parent | 0xFF));
    }

    public void setCullingState(short parent) {
        this.cullingState = (short)(parent & 0xFF00);
    }

    public void resetCullingState() {
        this.cullingState = (short)-1;
    }

    public boolean isCulledByFrustum(Frustum frustum) {
        float z;
        float y;
        float x = this.getOriginX();
        return !frustum.isBoxVisible(x - 1.125f, (y = (float)this.getOriginY()) - 1.125f, (z = (float)this.getOriginZ()) - 1.125f, x + 16.0f + 1.125f, y + 16.0f + 1.125f, z + 16.0f + 1.125f);
    }

    public int getOriginX() {
        return this.parent.getChunkX() << 4;
    }

    public int getOriginY() {
        return this.parent.getChunkY() << 4;
    }

    public int getOriginZ() {
        return this.parent.getChunkZ() << 4;
    }
}

