/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.config;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.RandomSource;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;

public class RandomElementTypeFeatureConfig
implements IElementTypeFeatureConfig {
    public static final RandomElementTypeFeatureConfig ALL = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.FIRE, (Object)1).put((Object)ElementType.WATER, (Object)1).put((Object)ElementType.EARTH, (Object)1).put((Object)ElementType.AIR, (Object)1).build());
    public static final RandomElementTypeFeatureConfig ICY = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.WATER, (Object)2).put((Object)ElementType.AIR, (Object)1).build());
    public static final RandomElementTypeFeatureConfig JUNGLE = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.FIRE, (Object)1).put((Object)ElementType.WATER, (Object)1).build());
    public static final RandomElementTypeFeatureConfig NETHER = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.FIRE, (Object)5).put((Object)ElementType.EARTH, (Object)1).build());
    public static final RandomElementTypeFeatureConfig WET = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.WATER, (Object)5).put((Object)ElementType.EARTH, (Object)1).build());
    public static final RandomElementTypeFeatureConfig DRY = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.FIRE, (Object)5).put((Object)ElementType.EARTH, (Object)2).put((Object)ElementType.AIR, (Object)1).build());
    public static final RandomElementTypeFeatureConfig END = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.AIR, (Object)5).put((Object)ElementType.FIRE, (Object)1).build());
    public static final RandomElementTypeFeatureConfig FOREST = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.EARTH, (Object)2).put((Object)ElementType.WATER, (Object)1).build());
    public static final RandomElementTypeFeatureConfig HILL = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.EARTH, (Object)4).put((Object)ElementType.AIR, (Object)1).build());
    public static final RandomElementTypeFeatureConfig MOUNTAIN = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.AIR, (Object)2).put((Object)ElementType.EARTH, (Object)1).build());
    public static final RandomElementTypeFeatureConfig PLAIN = new RandomElementTypeFeatureConfig((Map<ElementType, Integer>)ImmutableMap.builder().put((Object)ElementType.EARTH, (Object)2).put((Object)ElementType.WATER, (Object)1).put((Object)ElementType.AIR, (Object)1).put((Object)ElementType.FIRE, (Object)1).build());
    public static final Codec<RandomElementTypeFeatureConfig> CODEC = Codec.unboundedMap(ElementType.CODEC, (Codec)Codec.INT).fieldOf("element_type").xmap(RandomElementTypeFeatureConfig::new, c -> c.elementTypes).codec();
    private final Map<ElementType, Integer> elementTypes;

    public RandomElementTypeFeatureConfig(Map<ElementType, Integer> elementTypes) {
        if (elementTypes.containsKey(ElementType.NONE)) {
            throw new IllegalArgumentException("elementTypes must not contain NONE!");
        }
        this.elementTypes = new EnumMap<ElementType, Integer>(elementTypes);
    }

    @Override
    public ElementType getElementType(RandomSource rand) {
        int roll = rand.m_188503_(this.elementTypes.values().stream().mapToInt(i -> i).sum());
        for (Map.Entry<ElementType, Integer> entry : this.elementTypes.entrySet()) {
            int weight = entry.getValue();
            if (weight > roll) {
                return entry.getKey();
            }
            roll -= weight;
        }
        return ElementType.NONE;
    }

    @Override
    public String getName() {
        return "random";
    }
}

